/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.teavm.cache.NoCache;
import org.teavm.common.Graph;
import org.teavm.common.GraphIndexer;
import org.teavm.common.Loop;
import org.teavm.common.LoopGraph;
import org.teavm.common.RangeTree;
import org.teavm.javascript.AsyncCallsFinder;
import org.teavm.javascript.DecompilationException;
import org.teavm.javascript.MethodNodeCache;
import org.teavm.javascript.Optimizer;
import org.teavm.javascript.StatementGenerator;
import org.teavm.javascript.ast.AsyncMethodNode;
import org.teavm.javascript.ast.AsyncMethodPart;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.ClassNode;
import org.teavm.javascript.ast.FieldNode;
import org.teavm.javascript.ast.GotoPartStatement;
import org.teavm.javascript.ast.IdentifiedStatement;
import org.teavm.javascript.ast.MethodNode;
import org.teavm.javascript.ast.NativeMethodNode;
import org.teavm.javascript.ast.NodeLocation;
import org.teavm.javascript.ast.NodeModifier;
import org.teavm.javascript.ast.RegularMethodNode;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.WhileStatement;
import org.teavm.javascript.spi.GeneratedBy;
import org.teavm.javascript.spi.Generator;
import org.teavm.javascript.spi.InjectedBy;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.Instruction;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.util.AsyncProgramSplitter;
import org.teavm.model.util.ListingBuilder;
import org.teavm.model.util.ProgramUtils;

public class Decompiler {
    private ClassHolderSource classSource;
    private ClassLoader classLoader;
    private Graph graph;
    private LoopGraph loopGraph;
    private GraphIndexer indexer;
    private int[] loops;
    private int[] loopSuccessors;
    private Block[] blockMap;
    private int lastBlockId;
    private RangeTree codeTree;
    private RangeTree.Node currentNode;
    private RangeTree.Node parentNode;
    private Map<MethodReference, Generator> generators = new HashMap<MethodReference, Generator>();
    private Set<MethodReference> methodsToPass = new HashSet<MethodReference>();
    private MethodNodeCache regularMethodCache;
    private Set<MethodReference> asyncMethods;
    private Set<MethodReference> splitMethods = new HashSet<MethodReference>();
    private List<TryCatchBookmark> tryCatchBookmarks = new ArrayList<TryCatchBookmark>();
    private Deque<Block> stack;
    private Program program;

    public Decompiler(ClassHolderSource classSource, ClassLoader classLoader, Set<MethodReference> asyncMethods, Set<MethodReference> asyncFamilyMethods) {
        this.classSource = classSource;
        this.classLoader = classLoader;
        this.asyncMethods = asyncMethods;
        this.splitMethods.addAll(asyncMethods);
        this.splitMethods.addAll(asyncFamilyMethods);
    }

    public MethodNodeCache getRegularMethodCache() {
        return this.regularMethodCache;
    }

    public void setRegularMethodCache(MethodNodeCache regularMethodCache) {
        this.regularMethodCache = regularMethodCache;
    }

    public int getGraphSize() {
        return this.graph.size();
    }

    public List<ClassNode> decompile(Collection<String> classNames) {
        ArrayList<String> sequence = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        for (String className : classNames) {
            this.orderClasses(className, visited, sequence);
        }
        ArrayList<ClassNode> result = new ArrayList<ClassNode>();
        for (int i = 0; i < sequence.size(); ++i) {
            String className = (String)sequence.get(i);
            result.add(this.decompile(this.classSource.get(className)));
        }
        return result;
    }

    public List<String> getClassOrdering(Collection<String> classNames) {
        ArrayList<String> sequence = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        for (String className : classNames) {
            this.orderClasses(className, visited, sequence);
        }
        return sequence;
    }

    public void addGenerator(MethodReference method, Generator generator) {
        this.generators.put(method, generator);
    }

    public void addMethodToPass(MethodReference method) {
        this.methodsToPass.add(method);
    }

    private void orderClasses(String className, Set<String> visited, List<String> order) {
        if (!visited.add(className)) {
            return;
        }
        ClassHolder cls = this.classSource.get(className);
        if (cls == null) {
            return;
        }
        if (cls.getParent() != null) {
            this.orderClasses(cls.getParent(), visited, order);
        }
        for (String iface : cls.getInterfaces()) {
            this.orderClasses(iface, visited, order);
        }
        order.add(className);
    }

    public ClassNode decompile(ClassHolder cls) {
        ClassNode clsNode = new ClassNode(cls.getName(), cls.getParent());
        for (FieldHolder field : cls.getFields()) {
            FieldNode fieldNode = new FieldNode(field.getName(), field.getType());
            fieldNode.getModifiers().addAll(this.mapModifiers(field.getModifiers()));
            fieldNode.setInitialValue(field.getInitialValue());
            clsNode.getFields().add(fieldNode);
        }
        for (MethodHolder method : cls.getMethods()) {
            if (method.getModifiers().contains((Object)ElementModifier.ABSTRACT) || method.getAnnotations().get(InjectedBy.class.getName()) != null || this.methodsToPass.contains(method.getReference())) continue;
            MethodNode methodNode = this.decompile(method);
            clsNode.getMethods().add(methodNode);
        }
        clsNode.getInterfaces().addAll(cls.getInterfaces());
        clsNode.getModifiers().addAll(this.mapModifiers(cls.getModifiers()));
        return clsNode;
    }

    public MethodNode decompile(MethodHolder method) {
        return method.getModifiers().contains((Object)ElementModifier.NATIVE) ? this.decompileNative(method) : (!this.asyncMethods.contains(method.getReference()) ? this.decompileRegular(method) : this.decompileAsync(method));
    }

    public NativeMethodNode decompileNative(MethodHolder method) {
        Generator generator = this.generators.get(method.getReference());
        if (generator == null) {
            AnnotationHolder annotHolder = method.getAnnotations().get(GeneratedBy.class.getName());
            if (annotHolder == null) {
                throw new DecompilationException("Method " + method.getOwnerName() + "." + method.getDescriptor() + " is native, but no " + GeneratedBy.class.getName() + " annotation found");
            }
            ValueType annotValue = annotHolder.getValues().get("value").getJavaClass();
            String generatorClassName = ((ValueType.Object)annotValue).getClassName();
            try {
                Class<?> generatorClass = Class.forName(generatorClassName, true, this.classLoader);
                generator = (Generator)generatorClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new DecompilationException("Error instantiating generator " + generatorClassName + " for native method " + method.getOwnerName() + "." + method.getDescriptor());
            }
        }
        NativeMethodNode methodNode = new NativeMethodNode(new MethodReference(method.getOwnerName(), method.getDescriptor()));
        methodNode.getModifiers().addAll(this.mapModifiers(method.getModifiers()));
        methodNode.setGenerator(generator);
        methodNode.setAsync(this.asyncMethods.contains(method.getReference()));
        return methodNode;
    }

    public RegularMethodNode decompileRegular(MethodHolder method) {
        if (this.regularMethodCache == null || method.getAnnotations().get(NoCache.class.getName()) != null) {
            return this.decompileRegularCacheMiss(method);
        }
        RegularMethodNode node = this.regularMethodCache.get(method.getReference());
        if (node == null) {
            node = this.decompileRegularCacheMiss(method);
            this.regularMethodCache.store(method.getReference(), node);
        }
        return node;
    }

    public RegularMethodNode decompileRegularCacheMiss(MethodHolder method) {
        RegularMethodNode methodNode = new RegularMethodNode(method.getReference());
        Program program = method.getProgram();
        int[] targetBlocks = new int[program.basicBlockCount()];
        Arrays.fill(targetBlocks, -1);
        try {
            methodNode.setBody(this.getRegularMethodStatement(program, targetBlocks, false).getStatement());
        }
        catch (RuntimeException e) {
            StringBuilder sb = new StringBuilder("Error decompiling method " + method.getReference() + ":\n");
            sb.append(new ListingBuilder().buildListing(program, "  "));
            throw new DecompilationException(sb.toString(), e);
        }
        for (int i = 0; i < program.variableCount(); ++i) {
            methodNode.getVariables().add(program.variableAt(i).getRegister());
        }
        Optimizer optimizer = new Optimizer();
        optimizer.optimize(methodNode, method.getProgram());
        methodNode.getModifiers().addAll(this.mapModifiers(method.getModifiers()));
        int paramCount = Math.min(method.getSignature().length, program.variableCount());
        for (int i = 0; i < paramCount; ++i) {
            Variable var = program.variableAt(i);
            methodNode.getParameterDebugNames().add(new HashSet<String>(var.getDebugNames()));
        }
        return methodNode;
    }

    public AsyncMethodNode decompileAsync(MethodHolder method) {
        if (this.regularMethodCache == null || method.getAnnotations().get(NoCache.class.getName()) != null) {
            return this.decompileAsyncCacheMiss(method);
        }
        AsyncMethodNode node = this.regularMethodCache.getAsync(method.getReference());
        if (node == null || !this.checkAsyncRelevant(node)) {
            node = this.decompileAsyncCacheMiss(method);
            this.regularMethodCache.storeAsync(method.getReference(), node);
        }
        return node;
    }

    private boolean checkAsyncRelevant(AsyncMethodNode node) {
        AsyncCallsFinder asyncCallsFinder = new AsyncCallsFinder();
        for (AsyncMethodPart part : node.getBody()) {
            part.getStatement().acceptVisitor(asyncCallsFinder);
        }
        for (MethodReference asyncCall : asyncCallsFinder.asyncCalls) {
            if (this.splitMethods.contains(asyncCall)) continue;
            return false;
        }
        asyncCallsFinder.allCalls.removeAll(asyncCallsFinder.asyncCalls);
        for (MethodReference asyncCall : asyncCallsFinder.allCalls) {
            if (!this.splitMethods.contains(asyncCall)) continue;
            return false;
        }
        return true;
    }

    private AsyncMethodNode decompileAsyncCacheMiss(MethodHolder method) {
        AsyncMethodNode node = new AsyncMethodNode(method.getReference());
        AsyncProgramSplitter splitter = new AsyncProgramSplitter(this.classSource, this.splitMethods);
        splitter.split(method.getProgram());
        for (int i = 0; i < splitter.size(); ++i) {
            AsyncMethodPart part;
            try {
                part = this.getRegularMethodStatement(splitter.getProgram(i), splitter.getBlockSuccessors(i), i > 0);
            }
            catch (RuntimeException e) {
                StringBuilder sb = new StringBuilder("Error decompiling method " + method.getReference() + " part " + i + ":\n");
                sb.append(new ListingBuilder().buildListing(splitter.getProgram(i), "  "));
                throw new DecompilationException(sb.toString(), e);
            }
            node.getBody().add(part);
        }
        Program program = method.getProgram();
        for (int i = 0; i < program.variableCount(); ++i) {
            node.getVariables().add(program.variableAt(i).getRegister());
        }
        Optimizer optimizer = new Optimizer();
        optimizer.optimize(node, splitter);
        node.getModifiers().addAll(this.mapModifiers(method.getModifiers()));
        int paramCount = Math.min(method.getSignature().length, program.variableCount());
        for (int i = 0; i < paramCount; ++i) {
            Variable var = program.variableAt(i);
            node.getParameterDebugNames().add(new HashSet<String>(var.getDebugNames()));
        }
        return node;
    }

    private AsyncMethodPart getRegularMethodStatement(Program program, int[] targetBlocks, boolean async) {
        AsyncMethodPart result = new AsyncMethodPart();
        this.lastBlockId = 1;
        this.graph = ProgramUtils.buildControlFlowGraph(program);
        int[] weights = new int[this.graph.size()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = program.basicBlockAt(i).getInstructions().size();
        }
        int[] priorities = new int[this.graph.size()];
        for (int i = 0; i < targetBlocks.length; ++i) {
            if (targetBlocks[i] < 0) continue;
            priorities[i] = 1;
        }
        this.indexer = new GraphIndexer(this.graph, weights, priorities);
        this.graph = this.indexer.getGraph();
        this.loopGraph = new LoopGraph(this.graph);
        this.unflatCode();
        this.blockMap = new Block[program.basicBlockCount() * 2 + 1];
        this.stack = new ArrayDeque<Block>();
        this.program = program;
        BlockStatement rootStmt = new BlockStatement();
        rootStmt.setId("root");
        this.stack.push(new Block(rootStmt, rootStmt.getBody(), -1, -1));
        StatementGenerator generator = new StatementGenerator();
        generator.classSource = this.classSource;
        generator.program = program;
        generator.blockMap = this.blockMap;
        generator.indexer = this.indexer;
        this.parentNode = this.codeTree.getRoot();
        this.currentNode = this.parentNode.getFirstChild();
        generator.async = async;
        for (int i = 0; i < this.graph.size(); ++i) {
            int node = i < this.indexer.size() ? this.indexer.nodeAt(i) : -1;
            int next = i + 1;
            int head = this.loops[i];
            if (head != -1 && this.loopSuccessors[head] == next) {
                next = head;
            }
            if (node >= 0) {
                generator.currentBlock = program.basicBlockAt(node);
                int tmp = this.indexer.nodeAt(next);
                generator.nextBlock = tmp >= 0 && next < this.indexer.size() ? program.basicBlockAt(tmp) : null;
            }
            this.closeExpiredBookmarks(generator, node, generator.currentBlock.getTryCatchBlocks());
            ArrayList<TryCatchBookmark> inheritedBookmarks = new ArrayList<TryCatchBookmark>();
            Block block = this.stack.peek();
            while (block.end == i) {
                int mappedStart;
                Block oldBlock = block;
                this.stack.pop();
                block = this.stack.peek();
                if (block.start >= 0 && this.blockMap[mappedStart = this.indexer.nodeAt(block.start)] == oldBlock) {
                    this.blockMap[mappedStart] = block;
                }
                for (int j = oldBlock.tryCatches.size() - 1; j >= 0; --j) {
                    TryCatchBookmark bookmark = oldBlock.tryCatches.get(j);
                    TryCatchStatement tryCatchStmt = new TryCatchStatement();
                    tryCatchStmt.setExceptionType(bookmark.exceptionType);
                    tryCatchStmt.setExceptionVariable(bookmark.exceptionVariable);
                    tryCatchStmt.getHandler().add(generator.generateJumpStatement(program.basicBlockAt(bookmark.exceptionHandler)));
                    List<Statement> blockPart = oldBlock.body.subList(bookmark.offset, oldBlock.body.size());
                    tryCatchStmt.getProtectedBody().addAll(blockPart);
                    blockPart.clear();
                    if (!tryCatchStmt.getProtectedBody().isEmpty()) {
                        blockPart.add(tryCatchStmt);
                    }
                    inheritedBookmarks.add(bookmark);
                }
                oldBlock.tryCatches.clear();
            }
            for (int j = inheritedBookmarks.size() - 1; j >= 0; --j) {
                TryCatchBookmark bookmark = (TryCatchBookmark)inheritedBookmarks.get(j);
                bookmark.block = block;
                bookmark.offset = block.body.size();
                block.tryCatches.add(bookmark);
            }
            while (this.parentNode.getEnd() == i) {
                this.currentNode = this.parentNode.getNext();
                this.parentNode = this.parentNode.getParent();
            }
            for (Block newBlock : this.createBlocks(i)) {
                block.body.add(newBlock.statement);
                newBlock.parent = block;
                newBlock.parentOffset = block.body.size();
                this.stack.push(newBlock);
                block = newBlock;
            }
            this.createNewBookmarks(generator.currentBlock.getTryCatchBlocks());
            if (node < 0) continue;
            generator.statements.clear();
            InstructionLocation lastLocation = null;
            NodeLocation nodeLocation = null;
            List<Instruction> instructions = generator.currentBlock.getInstructions();
            for (int j = 0; j < instructions.size(); ++j) {
                Instruction insn = generator.currentBlock.getInstructions().get(j);
                if (insn.getLocation() != null && lastLocation != insn.getLocation()) {
                    lastLocation = insn.getLocation();
                    nodeLocation = new NodeLocation(lastLocation.getFileName(), lastLocation.getLine());
                }
                if (insn.getLocation() != null) {
                    generator.setCurrentLocation(nodeLocation);
                }
                insn.acceptVisitor(generator);
            }
            if (targetBlocks[node] >= 0) {
                GotoPartStatement stmt = new GotoPartStatement();
                stmt.setPart(targetBlocks[node]);
                generator.statements.add(stmt);
            }
            block.body.addAll(generator.statements);
        }
        SequentialStatement resultBody = new SequentialStatement();
        resultBody.getSequence().addAll(rootStmt.getBody());
        result.setStatement(resultBody);
        return result;
    }

    private void closeExpiredBookmarks(StatementGenerator generator, int node, List<TryCatchBlock> tryCatchBlocks) {
        TryCatchBookmark bookmark;
        int start;
        tryCatchBlocks = new ArrayList<TryCatchBlock>(tryCatchBlocks);
        Collections.reverse(tryCatchBlocks);
        int sz = Math.min(tryCatchBlocks.size(), this.tryCatchBookmarks.size());
        for (start = 0; start < sz; ++start) {
            TryCatchBlock tryCatch = tryCatchBlocks.get(start);
            bookmark = this.tryCatchBookmarks.get(start);
            if (tryCatch.getHandler().getIndex() != bookmark.exceptionHandler || !Objects.equals(tryCatch.getExceptionType(), bookmark.exceptionType)) break;
        }
        for (int i = this.tryCatchBookmarks.size() - 1; i >= start; --i) {
            TryCatchStatement tryCatchStmt;
            bookmark = this.tryCatchBookmarks.get(i);
            Block block = this.stack.peek();
            while (block != bookmark.block) {
                tryCatchStmt = new TryCatchStatement();
                tryCatchStmt.setExceptionType(bookmark.exceptionType);
                tryCatchStmt.setExceptionVariable(bookmark.exceptionVariable);
                tryCatchStmt.getHandler().add(generator.generateJumpStatement(this.program.basicBlockAt(bookmark.exceptionHandler)));
                tryCatchStmt.getProtectedBody().addAll(block.body);
                block.body.clear();
                if (!tryCatchStmt.getProtectedBody().isEmpty()) {
                    block.body.add(tryCatchStmt);
                }
                block = block.parent;
            }
            tryCatchStmt = new TryCatchStatement();
            tryCatchStmt.setExceptionType(bookmark.exceptionType);
            tryCatchStmt.setExceptionVariable(bookmark.exceptionVariable);
            if (node != bookmark.exceptionHandler) {
                tryCatchStmt.getHandler().add(generator.generateJumpStatement(this.program.basicBlockAt(bookmark.exceptionHandler)));
            }
            List<Statement> blockPart = block.body.subList(bookmark.offset, block.body.size());
            tryCatchStmt.getProtectedBody().addAll(blockPart);
            blockPart.clear();
            if (!tryCatchStmt.getProtectedBody().isEmpty()) {
                blockPart.add(tryCatchStmt);
            }
            bookmark.block.tryCatches.remove(bookmark);
        }
        this.tryCatchBookmarks.subList(start, this.tryCatchBookmarks.size()).clear();
    }

    private void createNewBookmarks(List<TryCatchBlock> tryCatchBlocks) {
        for (int i = this.tryCatchBookmarks.size(); i < tryCatchBlocks.size(); ++i) {
            TryCatchBlock tryCatch = tryCatchBlocks.get(i);
            TryCatchBookmark bookmark = new TryCatchBookmark();
            bookmark.block = this.stack.peek();
            bookmark.offset = bookmark.block.body.size();
            bookmark.exceptionHandler = tryCatch.getHandler().getIndex();
            bookmark.exceptionType = tryCatch.getExceptionType();
            bookmark.exceptionVariable = tryCatch.getExceptionVariable() != null ? Integer.valueOf(tryCatch.getExceptionVariable().getIndex()) : null;
            bookmark.block.tryCatches.add(bookmark);
            this.tryCatchBookmarks.add(bookmark);
        }
    }

    private Set<NodeModifier> mapModifiers(Set<ElementModifier> modifiers) {
        EnumSet<NodeModifier> result = EnumSet.noneOf(NodeModifier.class);
        if (modifiers.contains((Object)ElementModifier.STATIC)) {
            result.add(NodeModifier.STATIC);
        }
        if (modifiers.contains((Object)ElementModifier.INTERFACE)) {
            result.add(NodeModifier.INTERFACE);
        }
        if (modifiers.contains((Object)ElementModifier.ENUM)) {
            result.add(NodeModifier.ENUM);
        }
        if (modifiers.contains((Object)ElementModifier.SYNCHRONIZED)) {
            result.add(NodeModifier.SYNCHRONIZED);
        }
        return result;
    }

    private List<Block> createBlocks(int start) {
        ArrayList<Block> result = new ArrayList<Block>();
        while (this.currentNode != null && this.currentNode.getStart() == start) {
            Block block;
            IdentifiedStatement statement;
            boolean loop = false;
            if (this.loopSuccessors[start] == this.currentNode.getEnd() || this.isSingleBlockLoop(start)) {
                WhileStatement whileStatement;
                statement = whileStatement = new WhileStatement();
                block = new Block(statement, whileStatement.getBody(), start, this.currentNode.getEnd());
                loop = true;
            } else {
                BlockStatement blockStatement = new BlockStatement();
                statement = blockStatement;
                block = new Block(statement, blockStatement.getBody(), start, this.currentNode.getEnd());
            }
            result.add(block);
            int mappedIndex = this.indexer.nodeAt(this.currentNode.getEnd());
            if (!(mappedIndex < 0 || this.blockMap[mappedIndex] != null && this.blockMap[mappedIndex].statement instanceof WhileStatement)) {
                this.blockMap[mappedIndex] = block;
            }
            if (loop) {
                this.blockMap[this.indexer.nodeAt((int)start)] = block;
            }
            this.parentNode = this.currentNode;
            this.currentNode = this.currentNode.getFirstChild();
        }
        for (Block block : result) {
            block.statement.setId("block" + this.lastBlockId++);
        }
        return result;
    }

    private boolean isSingleBlockLoop(int index) {
        for (int succ : this.graph.outgoingEdges(index)) {
            if (succ != index) continue;
            return true;
        }
        return false;
    }

    private void unflatCode() {
        int node;
        Graph graph = this.graph;
        int sz = graph.size();
        int[] loopSuccessors = new int[sz];
        Arrays.fill(loopSuccessors, sz + 1);
        for (int node2 = 0; node2 < sz; ++node2) {
            for (Loop loop = this.loopGraph.loopAt(node2); loop != null; loop = loop.getParent()) {
                loopSuccessors[loop.getHead()] = node2 + 1;
            }
        }
        int[] loops = new int[sz];
        Arrays.fill(loops, -1);
        for (int head = 0; head < sz; ++head) {
            int end = loopSuccessors[head];
            if (end > sz) continue;
            for (int node3 = head + 1; node3 < end; ++node3) {
                loops[node3] = head;
            }
        }
        ArrayList<RangeTree.Range> ranges = new ArrayList<RangeTree.Range>();
        for (node = 0; node < sz; ++node) {
            if (loopSuccessors[node] <= sz) {
                ranges.add(new RangeTree.Range(node, loopSuccessors[node]));
            }
            int start = sz;
            for (int prev : graph.incomingEdges(node)) {
                start = Math.min(start, prev);
            }
            if (start >= node - 1) continue;
            ranges.add(new RangeTree.Range(start, node));
        }
        for (node = 0; node < sz; ++node) {
            if (!this.isSingleBlockLoop(node)) continue;
            ranges.add(new RangeTree.Range(node, node + 1));
        }
        this.codeTree = new RangeTree(sz + 1, ranges);
        this.loopSuccessors = loopSuccessors;
        this.loops = loops;
    }

    static class TryCatchBookmark {
        Block block;
        int offset;
        String exceptionType;
        Integer exceptionVariable;
        int exceptionHandler;

        TryCatchBookmark() {
        }
    }

    static class Block {
        public Block parent;
        public int parentOffset;
        public final IdentifiedStatement statement;
        public final List<Statement> body;
        public final int end;
        public final int start;
        public final List<TryCatchBookmark> tryCatches = new ArrayList<TryCatchBookmark>();

        public Block(IdentifiedStatement statement, List<Statement> body, int start, int end) {
            this.statement = statement;
            this.body = body;
            this.start = start;
            this.end = end;
        }
    }
}

