/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.teavm.cache.DiskCachedClassHolderSource;
import org.teavm.cache.DiskProgramCache;
import org.teavm.cache.DiskRegularMethodNodeCache;
import org.teavm.cache.FileSymbolTable;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationBuilder;
import org.teavm.dependency.DependencyInfo;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.javascript.RenderingContext;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.PreOptimizingClassHolderSource;
import org.teavm.model.ProgramReader;
import org.teavm.parsing.ClasspathClassHolderSource;
import org.teavm.tooling.ClassAlias;
import org.teavm.tooling.EmptyTeaVMToolLog;
import org.teavm.tooling.InstructionLocationReader;
import org.teavm.tooling.MethodAlias;
import org.teavm.tooling.RuntimeCopyOperation;
import org.teavm.tooling.SourceFileProvider;
import org.teavm.tooling.SourceFilesCopier;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.TeaVMEntryPoint;
import org.teavm.vm.TeaVMProgressListener;
import org.teavm.vm.spi.AbstractRendererListener;

public class TeaVMTool {
    private File targetDirectory = new File(".");
    private String targetFileName = "classes.js";
    private boolean minifying = true;
    private String mainClass;
    private RuntimeCopyOperation runtime = RuntimeCopyOperation.SEPARATE;
    private Properties properties = new Properties();
    private boolean mainPageIncluded;
    private boolean bytecodeLogging;
    private boolean debugInformationGenerated;
    private boolean sourceMapsFileGenerated;
    private boolean sourceFilesCopied;
    private boolean incremental;
    private File cacheDirectory = new File("./teavm-cache");
    private List<ClassHolderTransformer> transformers = new ArrayList<ClassHolderTransformer>();
    private List<ClassAlias> classAliases = new ArrayList<ClassAlias>();
    private List<MethodAlias> methodAliases = new ArrayList<MethodAlias>();
    private TeaVMToolLog log = new EmptyTeaVMToolLog();
    private ClassLoader classLoader = TeaVMTool.class.getClassLoader();
    private DiskCachedClassHolderSource cachedClassSource;
    private DiskProgramCache programCache;
    private DiskRegularMethodNodeCache astCache;
    private FileSymbolTable symbolTable;
    private FileSymbolTable fileTable;
    private boolean cancelled;
    private TeaVMProgressListener progressListener;
    private TeaVM vm;
    private List<SourceFileProvider> sourceFileProviders = new ArrayList<SourceFileProvider>();
    private AbstractRendererListener runtimeInjector = new AbstractRendererListener(){

        @Override
        public void begin(RenderingContext context, BuildTarget buildTarget) throws IOException {
            StringWriter writer = new StringWriter();
            TeaVMTool.this.resourceToWriter("org/teavm/javascript/runtime.js", writer);
            writer.close();
            context.getWriter().append(writer.toString()).newLine();
        }
    };

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public RuntimeCopyOperation getRuntime() {
        return this.runtime;
    }

    public void setRuntime(RuntimeCopyOperation runtime) {
        this.runtime = runtime;
    }

    public boolean isMainPageIncluded() {
        return this.mainPageIncluded;
    }

    public void setMainPageIncluded(boolean mainPageIncluded) {
        this.mainPageIncluded = mainPageIncluded;
    }

    public boolean isBytecodeLogging() {
        return this.bytecodeLogging;
    }

    public void setBytecodeLogging(boolean bytecodeLogging) {
        this.bytecodeLogging = bytecodeLogging;
    }

    public boolean isDebugInformationGenerated() {
        return this.debugInformationGenerated;
    }

    public void setDebugInformationGenerated(boolean debugInformationGenerated) {
        this.debugInformationGenerated = debugInformationGenerated;
    }

    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public boolean isSourceMapsFileGenerated() {
        return this.sourceMapsFileGenerated;
    }

    public void setSourceMapsFileGenerated(boolean sourceMapsFileGenerated) {
        this.sourceMapsFileGenerated = sourceMapsFileGenerated;
    }

    public boolean isSourceFilesCopied() {
        return this.sourceFilesCopied;
    }

    public void setSourceFilesCopied(boolean sourceFilesCopied) {
        this.sourceFilesCopied = sourceFilesCopied;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<ClassHolderTransformer> getTransformers() {
        return this.transformers;
    }

    public List<ClassAlias> getClassAliases() {
        return this.classAliases;
    }

    public List<MethodAlias> getMethodAliases() {
        return this.methodAliases;
    }

    public TeaVMToolLog getLog() {
        return this.log;
    }

    public void setLog(TeaVMToolLog log) {
        this.log = log;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setProgressListener(TeaVMProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public ProblemProvider getProblemProvider() {
        return this.vm != null ? this.vm.getProblemProvider() : null;
    }

    public DependencyInfo getDependencyInfo() {
        return this.vm.getDependencyInfo();
    }

    public Collection<String> getClasses() {
        return this.vm != null ? this.vm.getClasses() : Collections.emptyList();
    }

    public Collection<String> getUsedResources() {
        if (this.vm == null) {
            return Collections.emptyList();
        }
        HashSet<String> resources = new HashSet<String>();
        ClassReaderSource classSource = this.vm.getDependencyClassSource();
        InstructionLocationReader reader = new InstructionLocationReader(resources);
        for (MethodReference methodRef : this.vm.getMethods()) {
            ProgramReader program;
            MethodReader method;
            ClassReader cls = classSource.get(methodRef.getClassName());
            if (cls == null || (method = cls.getMethod(methodRef.getDescriptor())) == null || (program = method.getProgram()) == null) continue;
            for (int i = 0; i < program.basicBlockCount(); ++i) {
                program.basicBlockAt(i).readAllInstructions(reader);
            }
        }
        return resources;
    }

    public void addSourceFileProvider(SourceFileProvider sourceFileProvider) {
        this.sourceFileProviders.add(sourceFileProvider);
    }

    public void generate() throws TeaVMToolException {
        block92: {
            try {
                String text;
                Object problemProvider22;
                Object types;
                this.cancelled = false;
                this.log.info("Building JavaScript file");
                TeaVMBuilder vmBuilder = new TeaVMBuilder();
                if (this.incremental) {
                    this.cacheDirectory.mkdirs();
                    this.symbolTable = new FileSymbolTable(new File(this.cacheDirectory, "symbols"));
                    this.fileTable = new FileSymbolTable(new File(this.cacheDirectory, "files"));
                    ClasspathClassHolderSource innerClassSource = new ClasspathClassHolderSource(this.classLoader);
                    PreOptimizingClassHolderSource classSource = new PreOptimizingClassHolderSource(innerClassSource);
                    this.cachedClassSource = new DiskCachedClassHolderSource(this.cacheDirectory, this.symbolTable, this.fileTable, classSource, innerClassSource);
                    this.programCache = new DiskProgramCache(this.cacheDirectory, this.symbolTable, this.fileTable, innerClassSource);
                    this.astCache = new DiskRegularMethodNodeCache(this.cacheDirectory, this.symbolTable, this.fileTable, innerClassSource);
                    try {
                        this.symbolTable.update();
                        this.fileTable.update();
                    }
                    catch (IOException iOException) {
                        this.log.info("Cache is missing");
                    }
                    vmBuilder.setClassLoader(this.classLoader).setClassSource(this.cachedClassSource);
                } else {
                    vmBuilder.setClassLoader(this.classLoader).setClassSource(new PreOptimizingClassHolderSource(new ClasspathClassHolderSource(this.classLoader)));
                }
                this.vm = vmBuilder.build();
                if (this.progressListener != null) {
                    this.vm.setProgressListener(this.progressListener);
                }
                this.vm.setMinifying(this.minifying);
                this.vm.setBytecodeLogging(this.bytecodeLogging);
                this.vm.setProperties(this.properties);
                DebugInformationBuilder debugEmitter = this.debugInformationGenerated || this.sourceMapsFileGenerated ? new DebugInformationBuilder() : null;
                this.vm.setDebugEmitter(debugEmitter);
                this.vm.setIncremental(this.incremental);
                if (this.incremental) {
                    this.vm.setAstCache(this.astCache);
                    this.vm.setProgramCache(this.programCache);
                }
                this.vm.installPlugins();
                for (ClassHolderTransformer classHolderTransformer : this.transformers) {
                    this.vm.add(classHolderTransformer);
                }
                if (this.mainClass != null) {
                    MethodDescriptor mainMethodDesc = new MethodDescriptor("main", String[].class, Void.TYPE);
                    this.vm.entryPoint("main", new MethodReference(this.mainClass, mainMethodDesc)).withValue(1, "[java.lang.String").withArrayValue(1, "java.lang.String").async();
                }
                for (ClassAlias classAlias : this.classAliases) {
                    this.vm.exportType(classAlias.getAlias(), classAlias.getClassName());
                }
                for (MethodAlias methodAlias : this.methodAliases) {
                    MethodReference ref = new MethodReference(methodAlias.getClassName(), methodAlias.getMethodName(), MethodDescriptor.parseSignature(methodAlias.getDescriptor()));
                    TeaVMEntryPoint entryPoint = this.vm.entryPoint(methodAlias.getAlias(), ref).async();
                    if (methodAlias.getTypes() == null) continue;
                    for (int i = 0; i < methodAlias.getTypes().length; ++i) {
                        types = methodAlias.getTypes()[i];
                        if (types == null) continue;
                        for (String type : ((String)types).split(" +")) {
                            if ((type = type.trim()).isEmpty()) continue;
                            entryPoint.withValue(i, type);
                        }
                    }
                }
                this.targetDirectory.mkdirs();
                Throwable throwable = null;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(this.targetDirectory, this.targetFileName)), 65536), "UTF-8");){
                    DebugInformation debugInfo;
                    if (this.runtime == RuntimeCopyOperation.MERGED) {
                        this.vm.add(this.runtimeInjector);
                    }
                    this.vm.build(writer, new DirectoryBuildTarget(this.targetDirectory));
                    if (this.vm.wasCancelled()) {
                        this.log.info("Build cancelled");
                        this.cancelled = true;
                        return;
                    }
                    if (this.mainClass != null) {
                        ((Writer)writer).append("main = $rt_mainStarter(main);\n");
                    }
                    if ((problemProvider22 = this.vm.getProblemProvider()).getProblems().isEmpty()) {
                        this.log.info("JavaScript file successfully built");
                    } else if (problemProvider22.getSevereProblems().isEmpty()) {
                        this.log.info("JavaScript file built with warnings");
                        TeaVMProblemRenderer.describeProblems(this.vm, this.log);
                    } else {
                        this.log.info("JavaScript file built with errors");
                        TeaVMProblemRenderer.describeProblems(this.vm, this.log);
                    }
                    if (this.debugInformationGenerated) {
                        debugInfo = debugEmitter.getDebugInformation();
                        FileOutputStream debugInfoOut = new FileOutputStream(new File(this.targetDirectory, this.targetFileName + ".teavmdbg"));
                        types = null;
                        try {
                            debugInfo.write(debugInfoOut);
                        }
                        catch (Throwable throwable2) {
                            types = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (debugInfoOut != null) {
                                if (types != null) {
                                    try {
                                        ((OutputStream)debugInfoOut).close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)types).addSuppressed(throwable3);
                                    }
                                } else {
                                    ((OutputStream)debugInfoOut).close();
                                }
                            }
                        }
                        this.log.info("Debug information successfully written");
                    }
                    if (this.sourceMapsFileGenerated) {
                        debugInfo = debugEmitter.getDebugInformation();
                        String sourceMapsFileName = this.targetFileName + ".map";
                        ((Writer)writer).append("\n//# sourceMappingURL=").append(sourceMapsFileName);
                        OutputStreamWriter sourceMapsOut = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.targetDirectory, sourceMapsFileName)), "UTF-8");
                        Object object = null;
                        try {
                            debugInfo.writeAsSourceMaps(sourceMapsOut, "src", this.targetFileName);
                        }
                        catch (Throwable throwable4) {
                            object = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (sourceMapsOut != null) {
                                if (object != null) {
                                    try {
                                        ((Writer)sourceMapsOut).close();
                                    }
                                    catch (Throwable throwable5) {
                                        ((Throwable)object).addSuppressed(throwable5);
                                    }
                                } else {
                                    ((Writer)sourceMapsOut).close();
                                }
                            }
                        }
                        this.log.info("Source maps successfully written");
                    }
                    if (this.sourceFilesCopied) {
                        this.copySourceFiles();
                        this.log.info("Source files successfully written");
                    }
                    if (this.incremental) {
                        this.programCache.flush();
                        this.astCache.flush();
                        this.cachedClassSource.flush();
                        this.symbolTable.flush();
                        this.fileTable.flush();
                        this.log.info("Cache updated");
                    }
                }
                catch (Throwable problemProvider22) {
                    Throwable throwable6 = problemProvider22;
                    throw problemProvider22;
                }
                if (this.runtime == RuntimeCopyOperation.SEPARATE) {
                    this.resourceToFile("org/teavm/javascript/runtime.js", "runtime.js");
                }
                if (!this.mainPageIncluded) break block92;
                InputStreamReader inputStreamReader = new InputStreamReader(this.classLoader.getResourceAsStream("org/teavm/tooling/main.html"), "UTF-8");
                problemProvider22 = null;
                try {
                    text = IOUtils.toString((Reader)inputStreamReader).replace("${classes.js}", this.targetFileName);
                }
                catch (Throwable throwable7) {
                    problemProvider22 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (inputStreamReader != null) {
                        if (problemProvider22 != null) {
                            try {
                                ((Reader)inputStreamReader).close();
                            }
                            catch (Throwable throwable8) {
                                ((Throwable)problemProvider22).addSuppressed(throwable8);
                            }
                        } else {
                            ((Reader)inputStreamReader).close();
                        }
                    }
                }
                File file = new File(this.targetDirectory, "main.html");
                try (OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
                    ((Writer)writer2).append(text);
                }
            }
            catch (IOException e) {
                throw new TeaVMToolException("IO error occured", e);
            }
        }
    }

    private void copySourceFiles() {
        if (this.vm.getWrittenClasses() == null) {
            return;
        }
        SourceFilesCopier copier = new SourceFilesCopier(this.sourceFileProviders);
        copier.addClasses(this.vm.getWrittenClasses());
        copier.setLog(this.log);
        copier.copy(new File(this.targetDirectory, "src"));
    }

    private void resourceToFile(String resource, String fileName) throws IOException {
        try (InputStream input = TeaVMTool.class.getClassLoader().getResourceAsStream(resource);
             FileOutputStream output = new FileOutputStream(new File(this.targetDirectory, fileName));){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    private void resourceToWriter(String resource, Writer writer) throws IOException {
        try (InputStream input = TeaVMTool.class.getClassLoader().getResourceAsStream(resource);){
            IOUtils.copy((InputStream)input, (Writer)writer, (String)"UTF-8");
        }
    }
}

