/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.teavm.common.FiniteExecutor;
import org.teavm.common.SimpleFiniteExecutor;
import org.teavm.common.ThreadPoolFiniteExecutor;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationBuilder;
import org.teavm.javascript.EmptyRegularMethodNodeCache;
import org.teavm.javascript.InMemoryRegularMethodNodeCache;
import org.teavm.javascript.MethodNodeCache;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.CopyClassHolderSource;
import org.teavm.model.InMemoryProgramCache;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.PreOptimizingClassHolderSource;
import org.teavm.model.ProgramCache;
import org.teavm.model.ValueType;
import org.teavm.parsing.ClasspathClassHolderSource;
import org.teavm.testing.JUnitTestAdapter;
import org.teavm.testing.TestAdapter;
import org.teavm.tooling.EmptyTeaVMToolLog;
import org.teavm.tooling.ExceptionHelper;
import org.teavm.tooling.SourceFileProvider;
import org.teavm.tooling.SourceFilesCopier;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.TestExceptionPlugin;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;

public class TeaVMTestTool {
    private Map<String, List<MethodReference>> groupedMethods = new HashMap<String, List<MethodReference>>();
    private Map<MethodReference, String> fileNames = new HashMap<MethodReference, String>();
    private List<MethodReference> testMethods = new ArrayList<MethodReference>();
    private File outputDir = new File(".");
    private boolean minifying = true;
    private int numThreads = 1;
    private TestAdapter adapter = new JUnitTestAdapter();
    private List<ClassHolderTransformer> transformers = new ArrayList<ClassHolderTransformer>();
    private List<String> additionalScripts = new ArrayList<String>();
    private List<String> additionalScriptLocalPaths = new ArrayList<String>();
    private Properties properties = new Properties();
    private List<String> testClasses = new ArrayList<String>();
    private ClassLoader classLoader = TeaVMTestTool.class.getClassLoader();
    private TeaVMToolLog log = new EmptyTeaVMToolLog();
    private boolean debugInformationGenerated;
    private boolean sourceMapsGenerated;
    private boolean sourceFilesCopied;
    private boolean incremental;
    private List<SourceFileProvider> sourceFileProviders = new ArrayList<SourceFileProvider>();
    private MethodNodeCache astCache;
    private ProgramCache programCache;
    private SourceFilesCopier sourceFilesCopier;

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public TestAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(TestAdapter adapter) {
        this.adapter = adapter;
    }

    public List<ClassHolderTransformer> getTransformers() {
        return this.transformers;
    }

    public List<String> getAdditionalScripts() {
        return this.additionalScripts;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<String> getTestClasses() {
        return this.testClasses;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public TeaVMToolLog getLog() {
        return this.log;
    }

    public void setLog(TeaVMToolLog log) {
        this.log = log;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public boolean isDebugInformationGenerated() {
        return this.debugInformationGenerated;
    }

    public void setDebugInformationGenerated(boolean debugInformationGenerated) {
        this.debugInformationGenerated = debugInformationGenerated;
    }

    public boolean isSourceMapsGenerated() {
        return this.sourceMapsGenerated;
    }

    public void setSourceMapsGenerated(boolean sourceMapsGenerated) {
        this.sourceMapsGenerated = sourceMapsGenerated;
    }

    public boolean isSourceFilesCopied() {
        return this.sourceFilesCopied;
    }

    public void setSourceFilesCopied(boolean sourceFilesCopied) {
        this.sourceFilesCopied = sourceFilesCopied;
    }

    public void addSourceFileProvider(SourceFileProvider sourceFileProvider) {
        this.sourceFileProviders.add(sourceFileProvider);
    }

    public void generate() throws TeaVMToolException {
        Runnable finalizer = null;
        try {
            Object classHolder;
            new File(this.outputDir, "tests").mkdirs();
            new File(this.outputDir, "res").mkdirs();
            this.resourceToFile("org/teavm/javascript/runtime.js", "res/runtime.js");
            String prefix = "org/teavm/tooling/test";
            this.resourceToFile(prefix + "/res/junit-support.js", "res/junit-support.js");
            this.resourceToFile(prefix + "/res/junit.css", "res/junit.css");
            this.resourceToFile(prefix + "/res/class_obj.png", "res/class_obj.png");
            this.resourceToFile(prefix + "/res/control-000-small.png", "res/control-000-small.png");
            this.resourceToFile(prefix + "/res/methpub_obj.png", "res/methpub_obj.png");
            this.resourceToFile(prefix + "/res/package_obj.png", "res/package_obj.png");
            this.resourceToFile(prefix + "/res/tick-small-red.png", "res/tick-small-red.png");
            this.resourceToFile(prefix + "/res/tick-small.png", "res/tick-small.png");
            this.resourceToFile(prefix + "/res/toggle-small-expand.png", "res/toggle-small-expand.png");
            this.resourceToFile(prefix + "/res/toggle-small.png", "res/toggle-small.png");
            this.resourceToFile(prefix + "/junit.html", "junit.html");
            ClassHolderSource classSource = new ClasspathClassHolderSource(this.classLoader);
            if (this.incremental) {
                classSource = new PreOptimizingClassHolderSource(classSource);
            }
            for (String testClass : this.testClasses) {
                classHolder = classSource.get(testClass);
                if (classHolder == null) {
                    throw new TeaVMToolException("Could not find class " + testClass);
                }
                this.findTests((ClassHolder)classHolder);
            }
            this.includeAdditionalScripts(this.classLoader);
            this.astCache = new EmptyRegularMethodNodeCache();
            if (this.incremental) {
                this.astCache = new InMemoryRegularMethodNodeCache();
                this.programCache = new InMemoryProgramCache();
            }
            File allTestsFile = new File(this.outputDir, "tests/all.js");
            OutputStreamWriter allTestsWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(allTestsFile), "UTF-8");
            classHolder = null;
            try {
                allTestsWriter.write("prepare = function() {\n");
                allTestsWriter.write("    return new JUnitServer(document.body).readTests([");
                boolean first = true;
                for (String testClass : this.testClasses) {
                    Collection methods = this.groupedMethods.get(testClass);
                    if (methods == null) continue;
                    if (!first) {
                        ((Writer)allTestsWriter).append(",");
                    }
                    first = false;
                    ((Writer)allTestsWriter).append("\n        { name : \"").append(testClass).append("\", methods : [");
                    boolean firstMethod = true;
                    for (MethodReference methodRef : methods) {
                        String scriptName = "tests/" + this.fileNames.size() + ".js";
                        this.fileNames.put(methodRef, scriptName);
                        if (!firstMethod) {
                            ((Writer)allTestsWriter).append(",");
                        }
                        firstMethod = false;
                        ((Writer)allTestsWriter).append("\n            { name : \"" + methodRef.getName() + "\", script : \"" + scriptName + "\", expected : [");
                        MethodHolder methodHolder = classSource.get(testClass).getMethod(methodRef.getDescriptor());
                        boolean firstException = true;
                        for (String exception : this.adapter.getExpectedExceptions(methodHolder)) {
                            if (!firstException) {
                                ((Writer)allTestsWriter).append(", ");
                            }
                            firstException = false;
                            ((Writer)allTestsWriter).append("\"" + exception + "\"");
                        }
                        ((Writer)allTestsWriter).append("], additionalScripts : [");
                        for (int i = 0; i < this.additionalScriptLocalPaths.size(); ++i) {
                            if (i > 0) {
                                ((Writer)allTestsWriter).append(", ");
                            }
                            this.escapeString(this.additionalScriptLocalPaths.get(i), allTestsWriter);
                        }
                        ((Writer)allTestsWriter).append("] }");
                    }
                    ((Writer)allTestsWriter).append("] }");
                }
                allTestsWriter.write("], function() {}); }");
            }
            catch (Throwable first) {
                classHolder = first;
                throw first;
            }
            finally {
                if (allTestsWriter != null) {
                    if (classHolder != null) {
                        try {
                            ((Writer)allTestsWriter).close();
                        }
                        catch (Throwable first) {
                            ((Throwable)classHolder).addSuppressed(first);
                        }
                    } else {
                        ((Writer)allTestsWriter).close();
                    }
                }
            }
            int methodsGenerated = 0;
            this.log.info("Generating test files");
            this.sourceFilesCopier = new SourceFilesCopier(this.sourceFileProviders);
            this.sourceFilesCopier.setLog(this.log);
            FiniteExecutor executor = new SimpleFiniteExecutor();
            if (this.numThreads != 1) {
                int threads = this.numThreads != 0 ? this.numThreads : Runtime.getRuntime().availableProcessors();
                final ThreadPoolFiniteExecutor threadedExecutor = new ThreadPoolFiniteExecutor(threads);
                finalizer = new Runnable(){

                    @Override
                    public void run() {
                        threadedExecutor.stop();
                    }
                };
                executor = threadedExecutor;
            }
            for (final MethodReference method : this.testMethods) {
                final ClassHolderSource builderClassSource = classSource;
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        TeaVMTestTool.this.log.debug("Building test for " + method);
                        try {
                            TeaVMTestTool.this.decompileClassesForTest(TeaVMTestTool.this.classLoader, new CopyClassHolderSource(builderClassSource), method, (String)TeaVMTestTool.this.fileNames.get(method));
                        }
                        catch (IOException e) {
                            TeaVMTestTool.this.log.error("Error generating JavaScript", e);
                        }
                    }
                });
                ++methodsGenerated;
            }
            executor.complete();
            if (this.sourceFilesCopied) {
                this.sourceFilesCopier.copy(new File(new File(this.outputDir, "tests"), "src"));
            }
            this.log.info("Test files successfully generated for " + methodsGenerated + " method(s).");
        }
        catch (IOException e) {
            throw new TeaVMToolException("IO error occured generating JavaScript files", e);
        }
        finally {
            if (finalizer != null) {
                finalizer.run();
            }
        }
    }

    private void resourceToFile(String resource, String fileName) throws IOException {
        try (InputStream input = TeaVMTestTool.class.getClassLoader().getResourceAsStream(resource);
             FileOutputStream output = new FileOutputStream(new File(this.outputDir, fileName));){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    private void findTests(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods()) {
            if (!this.adapter.acceptMethod(method)) continue;
            MethodReference ref = new MethodReference(cls.getName(), method.getDescriptor());
            this.testMethods.add(ref);
            List<MethodReference> group = this.groupedMethods.get(cls.getName());
            if (group == null) {
                group = new ArrayList<MethodReference>();
                this.groupedMethods.put(cls.getName(), group);
            }
            group.add(ref);
        }
    }

    private void includeAdditionalScripts(ClassLoader classLoader) throws TeaVMToolException {
        if (this.additionalScripts == null) {
            return;
        }
        for (String script : this.additionalScripts) {
            String simpleName = script.substring(script.lastIndexOf(47) + 1);
            this.additionalScriptLocalPaths.add("tests/" + simpleName);
            if (classLoader.getResource(script) == null) {
                throw new TeaVMToolException("Additional script " + script + " was not found");
            }
            File file = new File(this.outputDir, "tests/" + simpleName);
            try {
                InputStream in = classLoader.getResourceAsStream(script);
                Throwable throwable = null;
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream out = new FileOutputStream(file);
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                throw new TeaVMToolException("Error copying additional script " + script, e);
            }
        }
    }

    private void decompileClassesForTest(ClassLoader classLoader, ClassHolderSource classSource, MethodReference methodRef, String targetName) throws IOException {
        DebugInformation debugInfo;
        Object cons;
        TeaVM vm = new TeaVMBuilder().setClassLoader(classLoader).setClassSource(classSource).build();
        vm.setIncremental(this.incremental);
        vm.setAstCache(this.astCache);
        vm.setProgramCache(this.programCache);
        vm.setProperties(this.properties);
        vm.setMinifying(this.minifying);
        vm.installPlugins();
        new TestExceptionPlugin().install(vm);
        for (ClassHolderTransformer transformer : this.transformers) {
            vm.add(transformer);
        }
        File file = new File(this.outputDir, targetName);
        DebugInformationBuilder debugInfoBuilder = this.sourceMapsGenerated || this.debugInformationGenerated ? new DebugInformationBuilder() : null;
        try (OutputStreamWriter innerWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            cons = new MethodReference(methodRef.getClassName(), "<init>", ValueType.VOID);
            MethodReference exceptionMsg = new MethodReference(ExceptionHelper.class, "showException", Throwable.class, String.class);
            vm.entryPoint("initInstance", (MethodReference)cons);
            vm.entryPoint("runTest", methodRef).withValue(0, ((MethodReference)cons).getClassName()).async();
            vm.entryPoint("extractException", exceptionMsg);
            vm.exportType("TestClass", ((MethodReference)cons).getClassName());
            vm.setDebugEmitter(debugInfoBuilder);
            vm.build(innerWriter, new DirectoryBuildTarget(this.outputDir));
            ((Writer)innerWriter).append("\n");
            ((Writer)innerWriter).append("\nJUnitClient.run();");
            if (this.sourceMapsGenerated) {
                String sourceMapsFileName = targetName.substring(targetName.lastIndexOf(47) + 1) + ".map";
                ((Writer)innerWriter).append("\n//# sourceMappingURL=").append(sourceMapsFileName);
            }
            if (!vm.getProblemProvider().getProblems().isEmpty()) {
                if (vm.getProblemProvider().getSevereProblems().isEmpty()) {
                    this.log.warning("Test built with warnings: " + methodRef);
                    TeaVMProblemRenderer.describeProblems(vm, this.log);
                } else {
                    this.log.warning("Test built with errors: " + methodRef);
                    TeaVMProblemRenderer.describeProblems(vm, this.log);
                }
            }
        }
        if (this.sourceMapsGenerated) {
            debugInfo = debugInfoBuilder.getDebugInformation();
            FileOutputStream debugInfoOut = new FileOutputStream(new File(this.outputDir, targetName + ".teavmdbg"));
            cons = null;
            try {
                debugInfo.write(debugInfoOut);
            }
            catch (Throwable throwable) {
                cons = throwable;
                throw throwable;
            }
            finally {
                if (debugInfoOut != null) {
                    if (cons != null) {
                        try {
                            ((OutputStream)debugInfoOut).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)cons).addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)debugInfoOut).close();
                    }
                }
            }
        }
        if (this.sourceMapsGenerated) {
            debugInfo = debugInfoBuilder.getDebugInformation();
            String sourceMapsFileName = targetName + ".map";
            try (OutputStreamWriter sourceMapsOut = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputDir, sourceMapsFileName)), "UTF-8");){
                debugInfo.writeAsSourceMaps(sourceMapsOut, "src", targetName);
            }
        }
        if (this.sourceFilesCopied && vm.getWrittenClasses() != null) {
            this.sourceFilesCopier.addClasses(vm.getWrittenClasses());
        }
    }

    private void escapeString(String string, Writer writer) throws IOException {
        writer.append('\"');
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    writer.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    writer.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    writer.append("\\r");
                    continue block7;
                }
                case '\t': {
                    writer.append("\\t");
                    continue block7;
                }
                default: {
                    writer.append(c);
                }
            }
        }
        writer.append('\"');
    }
}

