/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.teavm.callgraph.CallGraph;
import org.teavm.callgraph.DefaultCallGraph;
import org.teavm.callgraph.DefaultCallGraphNode;
import org.teavm.common.CachedMapper;
import org.teavm.common.Mapper;
import org.teavm.common.ServiceRepository;
import org.teavm.dependency.ClassDependency;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyCheckerInterruptor;
import org.teavm.dependency.DependencyClassSource;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyGraphBuilder;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.dependency.PluggableDependency;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.AnnotationReader;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.util.ModelUtils;

public class DependencyChecker
implements DependencyInfo {
    static final boolean shouldLog = System.getProperty("org.teavm.logDependencies", "false").equals("true");
    private int classNameSuffix;
    private DependencyClassSource classSource;
    private ClassLoader classLoader;
    private Mapper<MethodReference, MethodReader> methodReaderCache;
    private Mapper<FieldReference, FieldReader> fieldReaderCache;
    private CachedMapper<MethodReference, MethodDependency> methodCache;
    private CachedMapper<FieldReference, FieldDependency> fieldCache;
    private CachedMapper<String, ClassDependency> classCache;
    private List<DependencyListener> listeners = new ArrayList<DependencyListener>();
    private ServiceRepository services;
    private Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    List<DependencyType> types = new ArrayList<DependencyType>();
    Map<String, DependencyType> typeMap = new HashMap<String, DependencyType>();
    private DependencyCheckerInterruptor interruptor;
    private boolean interrupted;
    private Diagnostics diagnostics;
    DefaultCallGraph callGraph = new DefaultCallGraph();
    private DependencyAgent agent;
    List<DependencyNode> nodes = new ArrayList<DependencyNode>();
    List<BitSet> typeBitSets = new ArrayList<BitSet>();
    private Set<String> classesAddedByRoot = new HashSet<String>();
    private Set<MethodReference> methodsAddedByRoot = new HashSet<MethodReference>();
    private Set<FieldReference> fieldsAddedByRoot = new HashSet<FieldReference>();

    public DependencyChecker(ClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
        this.classSource = new DependencyClassSource(classSource, diagnostics);
        this.classLoader = classLoader;
        this.services = services;
        this.methodReaderCache = new CachedMapper<MethodReference, MethodReader>(new Mapper<MethodReference, MethodReader>(){

            @Override
            public MethodReader map(MethodReference preimage) {
                return DependencyChecker.this.findMethodReader(preimage);
            }
        });
        this.fieldReaderCache = new CachedMapper<FieldReference, FieldReader>(new Mapper<FieldReference, FieldReader>(){

            @Override
            public FieldReader map(FieldReference preimage) {
                return DependencyChecker.this.findFieldReader(preimage);
            }
        });
        this.methodCache = new CachedMapper<MethodReference, MethodDependency>(new Mapper<MethodReference, MethodDependency>(){

            @Override
            public MethodDependency map(MethodReference preimage) {
                MethodReader method = (MethodReader)DependencyChecker.this.methodReaderCache.map(preimage);
                if (method != null && !method.getReference().equals(preimage)) {
                    return (MethodDependency)DependencyChecker.this.methodCache.map(method.getReference());
                }
                return DependencyChecker.this.createMethodDep(preimage, method);
            }
        });
        this.fieldCache = new CachedMapper<FieldReference, FieldDependency>(new Mapper<FieldReference, FieldDependency>(){

            @Override
            public FieldDependency map(FieldReference preimage) {
                FieldReader field = (FieldReader)DependencyChecker.this.fieldReaderCache.map(preimage);
                if (field != null && !field.getReference().equals(preimage)) {
                    return (FieldDependency)DependencyChecker.this.fieldCache.map(field.getReference());
                }
                return DependencyChecker.this.createFieldNode(preimage, field);
            }
        });
        this.classCache = new CachedMapper<String, ClassDependency>(new Mapper<String, ClassDependency>(){

            @Override
            public ClassDependency map(String preimage) {
                return DependencyChecker.this.createClassDependency(preimage);
            }
        });
        this.agent = new DependencyAgent(this);
    }

    public DependencyAgent getAgent() {
        return this.agent;
    }

    public DependencyCheckerInterruptor getInterruptor() {
        return this.interruptor;
    }

    public void setInterruptor(DependencyCheckerInterruptor interruptor) {
        this.interruptor = interruptor;
    }

    public boolean wasInterrupted() {
        return this.interrupted;
    }

    public DependencyType getType(String name) {
        DependencyType type = this.typeMap.get(name);
        if (type == null) {
            type = new DependencyType(this, name, this.types.size());
            this.types.add(type);
            this.typeBitSets.add(new BitSet(this.nodes.size()));
            this.typeMap.put(name, type);
        }
        return type;
    }

    public DependencyNode createNode() {
        DependencyNode node = new DependencyNode(this, this.nodes.size());
        this.nodes.add(node);
        return node;
    }

    @Override
    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String generateClassName() {
        return "$$teavm_generated_class$$" + this.classNameSuffix++;
    }

    public void submitClass(ClassHolder cls) {
        this.classSource.submit(ModelUtils.copyClass(cls));
    }

    public void addDependencyListener(DependencyListener listener) {
        this.listeners.add(listener);
        listener.started(this.agent);
    }

    public void addClassTransformer(ClassHolderTransformer transformer) {
        this.classSource.addTransformer(transformer);
    }

    public void addEntryPoint(MethodReference methodRef, String ... argumentTypes) {
        ValueType[] parameters = methodRef.getDescriptor().getParameterTypes();
        if (parameters.length + 1 != argumentTypes.length) {
            throw new IllegalArgumentException("argumentTypes length does not match the number of method's arguments");
        }
        MethodDependency method = this.linkMethod(methodRef, null);
        method.use();
        DependencyNode[] varNodes = method.getVariables();
        varNodes[0].propagate(this.getType(methodRef.getClassName()));
        for (int i = 0; i < argumentTypes.length; ++i) {
            varNodes[i + 1].propagate(this.getType(argumentTypes[i]));
        }
    }

    void schedulePropagation(final DependencyConsumer consumer, final DependencyType type) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                consumer.consume(type);
            }
        });
    }

    void schedulePropagation(final DependencyConsumer consumer, final DependencyType[] types) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                for (DependencyType type : types) {
                    consumer.consume(type);
                }
            }
        });
    }

    public ClassDependency linkClass(final String className, final CallLocation callLocation) {
        ClassDependency dep = this.classCache.map(className);
        boolean added = true;
        if (callLocation != null && callLocation.getMethod() != null) {
            DefaultCallGraphNode callGraphNode = this.callGraph.getNode(callLocation.getMethod());
            if (!this.addClassAccess(callGraphNode, className, callLocation.getSourceLocation())) {
                added = false;
            }
        } else {
            added = this.classesAddedByRoot.add(className);
        }
        if (!dep.isMissing() && added) {
            this.tasks.add(new Runnable(){

                @Override
                public void run() {
                    for (DependencyListener listener : DependencyChecker.this.listeners) {
                        listener.classReached(DependencyChecker.this.agent, className, callLocation);
                    }
                }
            });
        }
        return dep;
    }

    private boolean addClassAccess(DefaultCallGraphNode node, String className, InstructionLocation loc) {
        if (!node.addClassAccess(className, loc)) {
            return false;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls != null) {
            if (cls.getParent() != null && !cls.getParent().equals(cls.getName())) {
                this.addClassAccess(node, cls.getParent(), loc);
            }
            for (String iface : cls.getInterfaces()) {
                this.addClassAccess(node, iface, loc);
            }
        }
        return true;
    }

    private ClassDependency createClassDependency(String className) {
        ClassReader cls = this.classSource.get(className);
        ClassDependency dependency = new ClassDependency(this, className, cls);
        if (!dependency.isMissing()) {
            if (cls.getParent() != null && !cls.getParent().equals(className)) {
                this.linkClass(cls.getParent(), null);
            }
            for (String ifaceName : cls.getInterfaces()) {
                this.linkClass(ifaceName, null);
            }
        }
        return dependency;
    }

    public MethodDependency linkMethod(MethodReference methodRef, CallLocation callLocation) {
        if (methodRef == null) {
            throw new IllegalArgumentException();
        }
        MethodReader methodReader = this.methodReaderCache.map(methodRef);
        if (methodReader != null) {
            methodRef = methodReader.getReference();
        }
        this.callGraph.getNode(methodRef);
        boolean added = true;
        added = callLocation != null && callLocation.getMethod() != null ? this.callGraph.getNode(callLocation.getMethod()).addCallSite(methodRef, callLocation.getSourceLocation()) : this.methodsAddedByRoot.add(methodRef);
        MethodDependency graph = this.methodCache.map(methodRef);
        if (!graph.isMissing() && added) {
            for (DependencyListener listener : this.listeners) {
                listener.methodReached(this.agent, graph, callLocation);
            }
            this.activateDependencyPlugin(graph, callLocation);
        }
        return graph;
    }

    void initClass(ClassDependency cls, final CallLocation callLocation) {
        ClassReader reader = cls.getClassReader();
        final MethodReader method = reader.getMethod(new MethodDescriptor("<clinit>", Void.TYPE));
        if (method != null) {
            this.tasks.add(new Runnable(){

                @Override
                public void run() {
                    DependencyChecker.this.linkMethod(method.getReference(), callLocation).use();
                }
            });
        }
    }

    private MethodReader findMethodReader(MethodReference methodRef) {
        String clsName = methodRef.getClassName();
        MethodDescriptor desc = methodRef.getDescriptor();
        ClassReader cls = this.classSource.get(clsName);
        if (cls == null) {
            return null;
        }
        MethodReader reader = cls.getMethod(desc);
        if (reader != null) {
            return reader;
        }
        if (cls.getParent() != null && cls.getParent().equals(cls.getParent()) && (reader = this.methodReaderCache.map(new MethodReference(cls.getParent(), desc))) != null) {
            return reader;
        }
        for (String ifaceName : cls.getInterfaces()) {
            reader = this.methodReaderCache.map(new MethodReference(ifaceName, desc));
            if (reader == null) continue;
            return reader;
        }
        return null;
    }

    private FieldReader findFieldReader(FieldReference fieldRef) {
        String clsName = fieldRef.getClassName();
        String name = fieldRef.getFieldName();
        while (clsName != null) {
            ClassReader cls = this.classSource.get(clsName);
            if (cls == null) {
                return null;
            }
            FieldReader field = cls.getField(name);
            if (field != null) {
                return field;
            }
            if (clsName.equals(cls.getParent())) break;
            clsName = cls.getParent();
        }
        return null;
    }

    private MethodDependency createMethodDep(MethodReference methodRef, MethodReader method) {
        DependencyNode resultNode;
        ValueType[] arguments = methodRef.getParameterTypes();
        int paramCount = arguments.length + 1;
        DependencyNode[] parameterNodes = new DependencyNode[arguments.length + 1];
        for (int i = 0; i < parameterNodes.length; ++i) {
            parameterNodes[i] = this.createNode();
            if (!shouldLog) continue;
            parameterNodes[i].setTag(methodRef + ":" + i);
        }
        if (methodRef.getDescriptor().getResultType() == ValueType.VOID) {
            resultNode = null;
        } else {
            resultNode = this.createNode();
            if (shouldLog) {
                resultNode.setTag(methodRef + ":RESULT");
            }
        }
        DependencyNode thrown = this.createNode();
        if (shouldLog) {
            thrown.setTag(methodRef + ":THROWN");
        }
        final MethodDependency dep = new MethodDependency(this, parameterNodes, paramCount, resultNode, thrown, method, methodRef);
        if (method != null) {
            this.tasks.add(new Runnable(){

                @Override
                public void run() {
                    CallLocation caller = new CallLocation(dep.getMethod().getReference());
                    DependencyChecker.this.linkClass(dep.getMethod().getOwnerName(), caller).initClass(caller);
                }
            });
        }
        return dep;
    }

    void scheduleMethodAnalysis(final MethodDependency dep) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                DependencyGraphBuilder graphBuilder = new DependencyGraphBuilder(DependencyChecker.this);
                graphBuilder.buildGraph(dep);
            }
        });
    }

    @Override
    public Collection<MethodReference> getAchievableMethods() {
        return this.methodCache.getCachedPreimages();
    }

    @Override
    public Collection<FieldReference> getAchievableFields() {
        return this.fieldCache.getCachedPreimages();
    }

    @Override
    public Collection<String> getAchievableClasses() {
        return this.classCache.getCachedPreimages();
    }

    public FieldDependency linkField(final FieldReference fieldRef, final CallLocation location) {
        boolean added = true;
        added = location != null ? this.callGraph.getNode(location.getMethod()).addFieldAccess(fieldRef, location.getSourceLocation()) : this.fieldsAddedByRoot.add(fieldRef);
        FieldDependency dep = this.fieldCache.map(fieldRef);
        if (!dep.isMissing()) {
            this.tasks.add(new Runnable(){

                @Override
                public void run() {
                    DependencyChecker.this.linkClass(fieldRef.getClassName(), location).initClass(location);
                }
            });
        }
        if (!dep.isMissing() && added) {
            for (DependencyListener listener : this.listeners) {
                listener.fieldReached(this.agent, dep, location);
            }
        }
        return dep;
    }

    @Override
    public FieldDependency getField(FieldReference fieldRef) {
        return this.fieldCache.getKnown(fieldRef);
    }

    @Override
    public ClassDependency getClass(String className) {
        return this.classCache.getKnown(className);
    }

    private FieldDependency createFieldNode(final FieldReference fieldRef, FieldReader field) {
        FieldDependency dep;
        DependencyNode node = this.createNode();
        if (shouldLog) {
            node.setTag(fieldRef.getClassName() + "#" + fieldRef.getFieldName());
        }
        if (!(dep = new FieldDependency(node, field, fieldRef)).isMissing()) {
            this.tasks.add(new Runnable(){

                @Override
                public void run() {
                    DependencyChecker.this.linkClass(fieldRef.getClassName(), null).initClass(null);
                }
            });
        }
        return dep;
    }

    private void activateDependencyPlugin(MethodDependency methodDep, CallLocation location) {
        this.attachDependencyPlugin(methodDep);
        if (methodDep.dependencyPlugin != null) {
            methodDep.dependencyPlugin.methodAchieved(this.agent, methodDep, location);
        }
    }

    private void attachDependencyPlugin(MethodDependency methodDep) {
        Class<?> depClass;
        if (methodDep.dependencyPluginAttached) {
            return;
        }
        methodDep.dependencyPluginAttached = true;
        AnnotationReader depAnnot = methodDep.getMethod().getAnnotations().get(PluggableDependency.class.getName());
        if (depAnnot == null) {
            return;
        }
        ValueType depType = depAnnot.getValue("value").getJavaClass();
        String depClassName = ((ValueType.Object)depType).getClassName();
        try {
            depClass = Class.forName(depClassName, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Dependency plugin not found: " + depClassName, e);
        }
        try {
            methodDep.dependencyPlugin = (DependencyPlugin)depClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Can't instantiate dependency plugin " + depClassName, e);
        }
    }

    @Override
    public MethodDependency getMethod(MethodReference methodRef) {
        return this.methodCache.getKnown(methodRef);
    }

    @Override
    public MethodDependency getMethodImplementation(MethodReference methodRef) {
        MethodReader method = this.methodReaderCache.map(methodRef);
        return method != null ? this.methodCache.getKnown(method.getReference()) : null;
    }

    public void processDependencies() {
        this.interrupted = false;
        int index = 0;
        while (!this.tasks.isEmpty()) {
            this.tasks.poll().run();
            if (++index != 100) continue;
            if (this.interruptor != null && !this.interruptor.shouldContinue()) {
                this.interrupted = true;
                break;
            }
            index = 0;
        }
    }

    public <T> T getService(Class<T> type) {
        return this.services.getService(type);
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public CallGraph getCallGraph() {
        return this.callGraph;
    }
}

