/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.codegen;

import java.util.HashMap;
import java.util.Map;
import org.teavm.codegen.AliasProvider;
import org.teavm.codegen.NamingException;
import org.teavm.codegen.NamingStrategy;
import org.teavm.model.AccessLevel;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

public class DefaultNamingStrategy
implements NamingStrategy {
    private AliasProvider aliasProvider;
    private ClassReaderSource classSource;
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, String> privateAliases = new HashMap<String, String>();
    private Map<String, String> classAliases = new HashMap<String, String>();
    private Map<String, String> fieldAliases = new HashMap<String, String>();
    private Map<String, String> functionAliases = new HashMap<String, String>();
    private boolean minifying;

    public DefaultNamingStrategy(AliasProvider aliasProvider, ClassReaderSource classSource) {
        this.aliasProvider = aliasProvider;
        this.classSource = classSource;
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    @Override
    public String getNameFor(String cls) {
        String name = this.classAliases.get(cls);
        if (name == null) {
            name = this.aliasProvider.getAlias(cls);
            this.classAliases.put(cls, name);
        }
        return name;
    }

    @Override
    public String getNameFor(MethodDescriptor method) {
        return this.getNameFor(method, 'M');
    }

    private String getNameFor(MethodDescriptor method, char classifier) {
        String key = classifier + method.toString();
        String alias = this.aliases.get(key);
        if (alias == null) {
            alias = this.aliasProvider.getAlias(method);
            this.aliases.put(key, alias);
        }
        return alias;
    }

    @Override
    public String getFullNameFor(MethodReference method) throws NamingException {
        return this.getFullNameFor(method, 'M');
    }

    @Override
    public String getNameForInit(MethodReference method) throws NamingException {
        return this.getFullNameFor(method, 'I');
    }

    private String getFullNameFor(MethodReference method, char classifier) throws NamingException {
        MethodReference originalMethod = method;
        if ((method = this.getRealMethod(method)) == null) {
            throw new NamingException("Can't provide name for method as it was not found: " + originalMethod);
        }
        if (!this.minifying) {
            return this.getNameFor(method.getClassName()) + "_" + this.getNameFor(method.getDescriptor(), classifier);
        }
        String key = classifier + method.toString();
        String alias = this.privateAliases.get(key);
        if (alias == null) {
            alias = this.aliasProvider.getAlias(method);
            this.privateAliases.put(key, alias);
        }
        return alias;
    }

    @Override
    public String getNameFor(FieldReference field) {
        String realCls = this.getRealFieldOwner(field.getClassName(), field.getFieldName());
        if (!realCls.equals(field.getClassName())) {
            String alias = this.getNameFor(new FieldReference(realCls, field.getFieldName()));
            this.fieldAliases.put(field.getClassName() + "#" + field, alias);
            return alias;
        }
        String key = realCls + "#" + field;
        String alias = this.fieldAliases.get(key);
        if (alias == null) {
            alias = this.aliasProvider.getAlias(field);
            this.fieldAliases.put(key, alias);
        }
        return alias;
    }

    @Override
    public String getNameForFunction(String name) throws NamingException {
        if (!this.minifying) {
            return name;
        }
        String alias = this.functionAliases.get(name);
        if (alias == null) {
            alias = this.aliasProvider.getFunctionAlias(name);
            this.functionAliases.put(name, alias);
        }
        return alias;
    }

    private MethodReference getRealMethod(MethodReference methodRef) {
        String className = methodRef.getClassName();
        while (className != null) {
            ClassReader cls = this.classSource.get(className);
            if (cls == null) {
                return null;
            }
            MethodReader method = cls.getMethod(methodRef.getDescriptor());
            if (method != null) {
                if (method.getLevel() == AccessLevel.PRIVATE && !className.equals(methodRef.getClassName())) {
                    return null;
                }
                return new MethodReference(className, method.getDescriptor());
            }
            className = cls.getParent();
        }
        return null;
    }

    private String getRealFieldOwner(String cls, String field) {
        String initialCls = cls;
        while (!this.fieldExists(cls, field)) {
            ClassReader clsHolder = this.classSource.get(cls);
            if ((cls = clsHolder.getParent()) != null) continue;
            throw new NamingException("Can't provide name for field as the field not found: " + initialCls + "." + field);
        }
        return cls;
    }

    private boolean fieldExists(String cls, String field) {
        ClassReader classHolder = this.classSource.get(cls);
        return classHolder.getField(field) != null;
    }
}

