/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.callgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teavm.callgraph.CallGraphNode;
import org.teavm.callgraph.ClassAccessSite;
import org.teavm.callgraph.DefaultCallGraph;
import org.teavm.callgraph.DefaultCallSite;
import org.teavm.callgraph.DefaultClassAccessSite;
import org.teavm.callgraph.DefaultFieldAccessSite;
import org.teavm.model.FieldReference;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodReference;

public class DefaultCallGraphNode
implements CallGraphNode {
    private DefaultCallGraph graph;
    private MethodReference method;
    private Set<DefaultCallSite> callSites = new HashSet<DefaultCallSite>();
    private transient Set<DefaultCallSite> safeCallSites;
    private List<DefaultCallSite> callerCallSites = new ArrayList<DefaultCallSite>();
    private transient List<DefaultCallSite> safeCallersCallSites;
    private Set<DefaultFieldAccessSite> fieldAccessSites = new HashSet<DefaultFieldAccessSite>();
    private transient Set<DefaultFieldAccessSite> safeFieldAccessSites;
    private Set<DefaultClassAccessSite> classAccessSites = new HashSet<DefaultClassAccessSite>();
    private transient Set<DefaultClassAccessSite> safeClassAccessSites;

    DefaultCallGraphNode(DefaultCallGraph graph, MethodReference method) {
        this.graph = graph;
        this.method = method;
    }

    @Override
    public DefaultCallGraph getGraph() {
        return this.graph;
    }

    @Override
    public MethodReference getMethod() {
        return this.method;
    }

    public Collection<DefaultCallSite> getCallSites() {
        if (this.safeCallSites == null) {
            this.safeCallSites = Collections.unmodifiableSet(this.callSites);
        }
        return this.safeCallSites;
    }

    public Collection<DefaultCallSite> getCallerCallSites() {
        if (this.safeCallersCallSites == null) {
            this.safeCallersCallSites = Collections.unmodifiableList(this.callerCallSites);
        }
        return this.safeCallersCallSites;
    }

    public boolean addCallSite(MethodReference method, InstructionLocation location) {
        DefaultCallGraphNode callee = this.graph.getNode(method);
        DefaultCallSite callSite = new DefaultCallSite(location, callee, this);
        if (this.callSites.add(callSite)) {
            callee.callerCallSites.add(callSite);
            return true;
        }
        return false;
    }

    public boolean addCallSite(MethodReference method) {
        return this.addCallSite(method, null);
    }

    public Collection<DefaultFieldAccessSite> getFieldAccessSites() {
        if (this.safeFieldAccessSites == null) {
            this.safeFieldAccessSites = Collections.unmodifiableSet(this.fieldAccessSites);
        }
        return this.safeFieldAccessSites;
    }

    public boolean addFieldAccess(FieldReference field, InstructionLocation location) {
        DefaultFieldAccessSite site = new DefaultFieldAccessSite(location, this, field);
        if (this.fieldAccessSites.add(site)) {
            this.graph.addFieldAccess(site);
            return true;
        }
        return false;
    }

    @Override
    public Collection<? extends ClassAccessSite> getClassAccessSites() {
        if (this.safeClassAccessSites == null) {
            this.safeClassAccessSites = Collections.unmodifiableSet(this.classAccessSites);
        }
        return this.safeClassAccessSites;
    }

    public boolean addClassAccess(String className, InstructionLocation location) {
        DefaultClassAccessSite site = new DefaultClassAccessSite(location, this, className);
        if (this.classAccessSites.add(site)) {
            this.graph.addClassAccess(site);
            return true;
        }
        return false;
    }
}

