/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.callgraph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.callgraph.CallGraph;
import org.teavm.callgraph.DefaultCallGraphNode;
import org.teavm.callgraph.DefaultClassAccessSite;
import org.teavm.callgraph.DefaultFieldAccessSite;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;

public class DefaultCallGraph
implements CallGraph {
    private Map<MethodReference, DefaultCallGraphNode> nodes = new HashMap<MethodReference, DefaultCallGraphNode>();
    private Map<FieldReference, Set<DefaultFieldAccessSite>> fieldAccessSites = new HashMap<FieldReference, Set<DefaultFieldAccessSite>>();
    private Map<String, Set<DefaultClassAccessSite>> classAccessSites = new HashMap<String, Set<DefaultClassAccessSite>>();

    @Override
    public DefaultCallGraphNode getNode(MethodReference method) {
        DefaultCallGraphNode node = this.nodes.get(method);
        if (node == null) {
            node = new DefaultCallGraphNode(this, method);
            this.nodes.put(method, node);
        }
        return this.nodes.get(method);
    }

    public Collection<DefaultFieldAccessSite> getFieldAccess(FieldReference reference) {
        Set<DefaultFieldAccessSite> resultSet = this.fieldAccessSites.get(reference);
        return resultSet != null ? Collections.unmodifiableSet(resultSet) : Collections.emptySet();
    }

    void addFieldAccess(DefaultFieldAccessSite accessSite) {
        Set<DefaultFieldAccessSite> sites = this.fieldAccessSites.get(accessSite.getField());
        if (sites == null) {
            sites = new HashSet<DefaultFieldAccessSite>();
            this.fieldAccessSites.put(accessSite.getField(), sites);
        }
        sites.add(accessSite);
    }

    public Collection<DefaultClassAccessSite> getClassAccess(String className) {
        Set<DefaultClassAccessSite> resultSet = this.classAccessSites.get(className);
        return resultSet != null ? Collections.unmodifiableSet(resultSet) : Collections.emptySet();
    }

    void addClassAccess(DefaultClassAccessSite accessSite) {
        Set<DefaultClassAccessSite> sites = this.classAccessSites.get(accessSite.getClassName());
        if (sites == null) {
            sites = new HashSet<DefaultClassAccessSite>();
            this.classAccessSites.put(accessSite.getClassName(), sites);
        }
        sites.add(accessSite);
    }
}

