/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.optimization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphUtils;
import org.teavm.common.IntegerStack;
import org.teavm.common.Loop;
import org.teavm.common.LoopGraph;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReader;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.model.util.BasicBlockMapper;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.InstructionVariableMapper;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.UsageExtractor;
import org.teavm.optimization.MethodOptimization;

public class LoopInvariantMotion
implements MethodOptimization {
    private int[] preheaders;
    private Instruction[] constantInstructions;
    private LoopGraph graph;
    private DominatorTree dom;
    private Program program;

    @Override
    public void optimize(MethodReader method, Program program) {
        int i;
        this.program = program;
        this.graph = new LoopGraph(ProgramUtils.buildControlFlowGraph(program));
        this.dom = GraphUtils.buildDominatorTree(this.graph);
        Graph domGraph = GraphUtils.buildDominatorGraph(this.dom, this.graph.size());
        this.preheaders = new int[this.graph.size()];
        Arrays.fill(this.preheaders, -1);
        IntegerStack stack = new IntegerStack(this.graph.size());
        int[] defLocation = new int[program.variableCount()];
        Arrays.fill(defLocation, -1);
        this.constantInstructions = new Instruction[program.variableCount()];
        for (i = 0; i <= method.parameterCount(); ++i) {
            defLocation[i] = 0;
        }
        for (i = 0; i < domGraph.size(); ++i) {
            if (this.dom.immediateDominatorOf(i) >= 0) continue;
            stack.push(i);
        }
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        UsageExtractor useExtractor = new UsageExtractor();
        InstructionAnalyzer analyzer = new InstructionAnalyzer();
        CopyConstantVisitor constantCopier = new CopyConstantVisitor();
        while (!stack.isEmpty()) {
            int v = stack.pop();
            BasicBlock block = program.basicBlockAt(v);
            block3: for (int i2 = 0; i2 < block.getInstructions().size(); ++i2) {
                Loop defLoop;
                Variable[] defs;
                Instruction insn = block.getInstructions().get(i2);
                insn.acceptVisitor(defExtractor);
                for (Variable def : defs = defExtractor.getDefinedVariables()) {
                    defLocation[def.getIndex()] = v;
                }
                analyzer.canMove = false;
                analyzer.constant = false;
                insn.acceptVisitor(analyzer);
                if (analyzer.constant) {
                    this.constantInstructions[defs[0].getIndex()] = insn;
                }
                if (!analyzer.canMove || (defLoop = this.graph.loopAt(v)) == null) continue;
                insn.acceptVisitor(useExtractor);
                Loop commonUseLoop = null;
                for (Variable use : useExtractor.getUsedVariables()) {
                    Loop useLoop;
                    if (this.constantInstructions[use.getIndex()] != null) continue;
                    int useLoc = defLocation[use.getIndex()];
                    if (useLoc == -1 || (useLoop = this.graph.loopAt(useLoc)) == defLoop) continue block3;
                    if (useLoop == null || !useLoop.isChildOf(commonUseLoop)) continue;
                    commonUseLoop = useLoop;
                }
                while (defLoop.getParent() != commonUseLoop) {
                    if ((defLoop = defLoop.getParent()) != null) continue;
                    continue block3;
                }
                block.getInstructions().set(i2, new EmptyInstruction());
                int preheader = this.getPreheader(defLoop.getHead());
                List<Instruction> preheaderInstructions = program.basicBlockAt(preheader).getInstructions();
                ArrayList<Instruction> newInstructions = new ArrayList<Instruction>();
                Variable[] variableMap = null;
                for (Variable use : useExtractor.getUsedVariables()) {
                    Instruction constInsn = this.constantInstructions[use.getIndex()];
                    if (constInsn == null) continue;
                    constInsn.acceptVisitor(constantCopier);
                    newInstructions.add(constantCopier.copy);
                    if (variableMap == null) {
                        variableMap = new Variable[program.variableCount()];
                        for (int j = 0; j < variableMap.length; ++j) {
                            variableMap[j] = program.variableAt(j);
                        }
                    }
                    variableMap[use.getIndex()] = constantCopier.var;
                }
                if (variableMap != null) {
                    insn.acceptVisitor(new VariableMapperImpl(variableMap));
                }
                newInstructions.add(insn);
                preheaderInstructions.addAll(preheaderInstructions.size() - 1, newInstructions);
                defLocation[defs[0].getIndex()] = commonUseLoop != null ? commonUseLoop.getHead() : 0;
            }
            for (int succ : domGraph.outgoingEdges(v)) {
                stack.push(succ);
            }
        }
    }

    private int getPreheader(int header) {
        int preheader = this.preheaders[header];
        if (preheader < 0) {
            int[] entries = this.getLoopEntries(header);
            preheader = entries.length == 1 ? entries[0] : this.insertPreheader(header);
            this.preheaders[header] = preheader;
        }
        return preheader;
    }

    private int[] getLoopEntries(int header) {
        int[] predecessors = this.graph.incomingEdges(header);
        int j = 0;
        for (int i = 0; i < predecessors.length; ++i) {
            int pred = predecessors[i];
            if (this.dom.dominates(header, pred)) continue;
            predecessors[j++] = pred;
        }
        return Arrays.copyOf(predecessors, j);
    }

    private int insertPreheader(int headerIndex) {
        final BasicBlock preheader = this.program.createBasicBlock();
        JumpInstruction escapeInsn = new JumpInstruction();
        final BasicBlock header = this.program.basicBlockAt(headerIndex);
        escapeInsn.setTarget(header);
        preheader.getInstructions().add(escapeInsn);
        for (int i = 0; i < header.getPhis().size(); ++i) {
            Phi phi = header.getPhis().get(i);
            Phi preheaderPhi = null;
            for (int j = 0; j < phi.getIncomings().size(); ++j) {
                Incoming incoming = phi.getIncomings().get(j);
                if (this.dom.dominates(headerIndex, incoming.getSource().getIndex())) continue;
                phi.getIncomings().remove(j--);
                if (preheaderPhi == null) {
                    preheaderPhi = new Phi();
                    preheaderPhi.setReceiver(this.program.createVariable());
                    preheader.getPhis().add(preheaderPhi);
                }
                preheaderPhi.getIncomings().add(incoming);
            }
            if (preheaderPhi == null) continue;
            Incoming incoming = new Incoming();
            incoming.setSource(preheader);
            incoming.setValue(preheaderPhi.getReceiver());
            phi.getIncomings().add(incoming);
        }
        for (int predIndex : this.graph.incomingEdges(headerIndex)) {
            if (this.dom.dominates(headerIndex, predIndex)) continue;
            BasicBlock pred = this.program.basicBlockAt(predIndex);
            pred.getLastInstruction().acceptVisitor(new BasicBlockMapper(){

                @Override
                protected BasicBlock map(BasicBlock block) {
                    if (block == header) {
                        block = preheader;
                    }
                    return block;
                }
            });
        }
        return preheader.getIndex();
    }

    private class CopyConstantVisitor
    implements InstructionVisitor {
        Instruction copy;
        Variable var;

        private CopyConstantVisitor() {
        }

        @Override
        public void visit(EmptyInstruction insn) {
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.getDebugNames().addAll(insn.getReceiver().getDebugNames());
            ClassConstantInstruction copy = new ClassConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(NullConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.getDebugNames().addAll(insn.getReceiver().getDebugNames());
            NullConstantInstruction copy = new NullConstantInstruction();
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.getDebugNames().addAll(insn.getReceiver().getDebugNames());
            IntegerConstantInstruction copy = new IntegerConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(LongConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.getDebugNames().addAll(insn.getReceiver().getDebugNames());
            LongConstantInstruction copy = new LongConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.getDebugNames().addAll(insn.getReceiver().getDebugNames());
            FloatConstantInstruction copy = new FloatConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.getDebugNames().addAll(insn.getReceiver().getDebugNames());
            DoubleConstantInstruction copy = new DoubleConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            this.var = LoopInvariantMotion.this.program.createVariable();
            this.var.getDebugNames().addAll(insn.getReceiver().getDebugNames());
            StringConstantInstruction copy = new StringConstantInstruction();
            copy.setConstant(insn.getConstant());
            copy.setReceiver(this.var);
            this.copy = copy;
        }

        @Override
        public void visit(BinaryInstruction insn) {
        }

        @Override
        public void visit(NegateInstruction insn) {
        }

        @Override
        public void visit(AssignInstruction insn) {
        }

        @Override
        public void visit(CastInstruction insn) {
        }

        @Override
        public void visit(CastNumberInstruction insn) {
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
        }

        @Override
        public void visit(BranchingInstruction insn) {
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
        }

        @Override
        public void visit(JumpInstruction insn) {
        }

        @Override
        public void visit(SwitchInstruction insn) {
        }

        @Override
        public void visit(ExitInstruction insn) {
        }

        @Override
        public void visit(RaiseInstruction insn) {
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
        }

        @Override
        public void visit(ConstructInstruction insn) {
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
        }

        @Override
        public void visit(GetFieldInstruction insn) {
        }

        @Override
        public void visit(PutFieldInstruction insn) {
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
        }

        @Override
        public void visit(GetElementInstruction insn) {
        }

        @Override
        public void visit(PutElementInstruction insn) {
        }

        @Override
        public void visit(InvokeInstruction insn) {
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
        }

        @Override
        public void visit(InitClassInstruction insn) {
        }

        @Override
        public void visit(NullCheckInstruction insn) {
        }

        @Override
        public void visit(MonitorEnterInstruction insn) {
        }

        @Override
        public void visit(MonitorExitInstruction insn) {
        }
    }

    private static class InstructionAnalyzer
    implements InstructionVisitor {
        public boolean canMove;
        public boolean constant;

        private InstructionAnalyzer() {
        }

        @Override
        public void visit(EmptyInstruction insn) {
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            this.constant = true;
        }

        @Override
        public void visit(NullConstantInstruction insn) {
            this.constant = true;
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
            this.constant = true;
        }

        @Override
        public void visit(LongConstantInstruction insn) {
            this.constant = true;
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
            this.constant = true;
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
            this.constant = true;
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            this.constant = true;
        }

        @Override
        public void visit(BinaryInstruction insn) {
            this.canMove = true;
        }

        @Override
        public void visit(NegateInstruction insn) {
            this.canMove = true;
        }

        @Override
        public void visit(AssignInstruction insn) {
            this.canMove = true;
        }

        @Override
        public void visit(CastInstruction insn) {
            this.canMove = true;
        }

        @Override
        public void visit(CastNumberInstruction insn) {
            this.canMove = true;
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
            this.canMove = true;
        }

        @Override
        public void visit(BranchingInstruction insn) {
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
        }

        @Override
        public void visit(JumpInstruction insn) {
        }

        @Override
        public void visit(SwitchInstruction insn) {
        }

        @Override
        public void visit(ExitInstruction insn) {
        }

        @Override
        public void visit(RaiseInstruction insn) {
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
        }

        @Override
        public void visit(ConstructInstruction insn) {
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
        }

        @Override
        public void visit(GetFieldInstruction insn) {
        }

        @Override
        public void visit(PutFieldInstruction insn) {
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
        }

        @Override
        public void visit(GetElementInstruction insn) {
        }

        @Override
        public void visit(PutElementInstruction insn) {
        }

        @Override
        public void visit(InvokeInstruction insn) {
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            this.canMove = true;
        }

        @Override
        public void visit(InitClassInstruction insn) {
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            this.canMove = true;
        }

        @Override
        public void visit(MonitorEnterInstruction insn) {
        }

        @Override
        public void visit(MonitorExitInstruction insn) {
        }
    }

    private static class VariableMapperImpl
    extends InstructionVariableMapper {
        private Variable[] map;

        public VariableMapperImpl(Variable[] map) {
            this.map = map;
        }

        @Override
        protected Variable map(Variable var) {
            return this.map[var.getIndex()];
        }
    }
}

