/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript.ast;

import java.util.Collections;
import java.util.List;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.Expr;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.ThrowStatement;

public abstract class Statement {
    public abstract void acceptVisitor(StatementVisitor var1);

    public static Statement empty() {
        return new SequentialStatement();
    }

    public static AssignmentStatement assign(Expr left, Expr right) {
        AssignmentStatement stmt = new AssignmentStatement();
        stmt.setLeftValue(left);
        stmt.setRightValue(right);
        return stmt;
    }

    public static ReturnStatement exitFunction(Expr result) {
        ReturnStatement stmt = new ReturnStatement();
        stmt.setResult(result);
        return stmt;
    }

    public static ThrowStatement raiseException(Expr exception) {
        ThrowStatement stmt = new ThrowStatement();
        stmt.setException(exception);
        return stmt;
    }

    public static Statement cond(Expr predicate, List<Statement> consequent, List<Statement> alternative) {
        ConditionalStatement statement = new ConditionalStatement();
        statement.setCondition(predicate);
        statement.getConsequent().addAll(consequent);
        statement.getAlternative().addAll(alternative);
        return statement;
    }

    public static Statement cond(Expr predicate, List<Statement> consequent) {
        return Statement.cond(predicate, consequent, Collections.emptyList());
    }

    public static InitClassStatement initClass(String className) {
        InitClassStatement stmt = new InitClassStatement();
        stmt.setClassName(className);
        return stmt;
    }
}

