/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.Arrays;
import org.teavm.common.Graph;
import org.teavm.common.GraphUtils;
import org.teavm.common.IntegerStack;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.Variable;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.UsageExtractor;

class ReadWriteStatsBuilder {
    public int[] reads;
    public int[] writes;

    private ReadWriteStatsBuilder() {
    }

    public ReadWriteStatsBuilder(int variableCount) {
        this.reads = new int[variableCount];
        this.writes = new int[variableCount];
    }

    public ReadWriteStatsBuilder copy() {
        ReadWriteStatsBuilder result = new ReadWriteStatsBuilder();
        result.reads = Arrays.copyOf(this.reads, this.reads.length);
        result.writes = Arrays.copyOf(this.writes, this.writes.length);
        return result;
    }

    public void analyze(Program program) {
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        Graph dom = GraphUtils.buildDominatorGraph(GraphUtils.buildDominatorTree(cfg), cfg.size());
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        UsageExtractor useExtractor = new UsageExtractor();
        IntegerStack stack = new IntegerStack(program.basicBlockCount());
        stack.push(0);
        while (!stack.isEmpty()) {
            int node = stack.pop();
            BasicBlock block = program.basicBlockAt(node);
            for (Instruction insn : block.getInstructions()) {
                insn.acceptVisitor(defExtractor);
                insn.acceptVisitor(useExtractor);
                for (Variable variable : defExtractor.getDefinedVariables()) {
                    int n = variable.getIndex();
                    this.writes[n] = this.writes[n] + 1;
                }
                for (Variable variable : useExtractor.getUsedVariables()) {
                    int n = variable.getIndex();
                    this.reads[n] = this.reads[n] + 1;
                }
            }
            for (Phi phi : block.getPhis()) {
                int n = phi.getReceiver().getIndex();
                this.writes[n] = this.writes[n] + phi.getIncomings().size();
                for (Incoming incoming : phi.getIncomings()) {
                    if (this.writes[incoming.getValue().getIndex()] != 0) continue;
                    int n2 = incoming.getValue().getIndex();
                    this.reads[n2] = this.reads[n2] + 1;
                }
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                int n = tryCatch.getExceptionVariable().getIndex();
                this.writes[n] = this.writes[n] + 1;
                int n3 = tryCatch.getExceptionVariable().getIndex();
                this.reads[n3] = this.reads[n3] + 1;
            }
            for (Object succ : (Object)dom.outgoingEdges(node)) {
                stack.push((int)succ);
            }
        }
    }
}

