/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.List;
import org.teavm.javascript.AllBlocksCountVisitor;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.GotoPartStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.MonitorEnterStatement;
import org.teavm.javascript.ast.MonitorExitStatement;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.WhileStatement;

class EscapingStatementFinder
implements StatementVisitor {
    AllBlocksCountVisitor blockCountVisitor;
    public boolean escaping;

    public EscapingStatementFinder(AllBlocksCountVisitor blockCountVisitor) {
        this.blockCountVisitor = blockCountVisitor;
    }

    private boolean isEmpty(Statement statement) {
        if (!(statement instanceof SequentialStatement)) {
            return false;
        }
        SequentialStatement seq = (SequentialStatement)statement;
        for (int i = seq.getSequence().size() - 1; i >= 0; --i) {
            if (this.isEmpty(seq.getSequence().get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean check(List<Statement> statements) {
        if (this.escaping) {
            return true;
        }
        if (statements.isEmpty()) {
            this.escaping = true;
            return true;
        }
        for (int i = statements.size() - 1; i >= 0; --i) {
            Statement stmt = statements.get(i);
            if (this.isEmpty(stmt)) continue;
            stmt.acceptVisitor(this);
            return this.escaping;
        }
        this.escaping = true;
        return true;
    }

    @Override
    public void visit(AssignmentStatement statement) {
        this.escaping |= true;
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.check(statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        if (!this.check(statement.getConsequent())) {
            this.check(statement.getAlternative());
        }
    }

    @Override
    public void visit(SwitchStatement statement) {
        if (this.blockCountVisitor.getCount(statement) > 0) {
            this.escaping = true;
            return;
        }
        for (SwitchClause clause : statement.getClauses()) {
            if (this.check(clause.getBody())) break;
        }
        if (!this.escaping) {
            this.check(statement.getDefaultClause());
        }
    }

    @Override
    public void visit(WhileStatement statement) {
        if (this.blockCountVisitor.getCount(statement) > 0) {
            this.escaping = true;
            return;
        }
        if (statement.getCondition() != null && this.check(statement.getBody())) {
            this.escaping = true;
        }
    }

    @Override
    public void visit(BlockStatement statement) {
        if (this.blockCountVisitor.getCount(statement) > 0) {
            this.escaping = true;
            return;
        }
        this.check(statement.getBody());
    }

    @Override
    public void visit(BreakStatement statement) {
    }

    @Override
    public void visit(ContinueStatement statement) {
    }

    @Override
    public void visit(ReturnStatement statement) {
    }

    @Override
    public void visit(ThrowStatement statement) {
    }

    @Override
    public void visit(InitClassStatement statement) {
        this.escaping = true;
    }

    @Override
    public void visit(TryCatchStatement statement) {
        if (!this.check(statement.getProtectedBody())) {
            this.check(statement.getHandler());
        }
    }

    @Override
    public void visit(GotoPartStatement statement) {
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        this.escaping = true;
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        this.escaping = true;
    }
}

