/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.teavm.common.Mapper;

public class CachedMapper<T, R>
implements Mapper<T, R> {
    private Mapper<T, R> innerMapper;
    private Map<T, Wrapper<R>> cache = new HashMap<T, Wrapper<R>>();
    private List<KeyListener<T>> keyListeners = new ArrayList<KeyListener<T>>();

    public CachedMapper(Mapper<T, R> innerMapper) {
        this.innerMapper = innerMapper;
    }

    public R getKnown(T preimage) {
        Wrapper<R> wrapper = this.cache.get(preimage);
        return wrapper != null ? (R)wrapper.value : null;
    }

    @Override
    public R map(T preimage) {
        Wrapper<Object> wrapper = this.cache.get(preimage);
        if (wrapper == null) {
            wrapper = new Wrapper();
            this.cache.put(preimage, wrapper);
            wrapper.value = this.innerMapper.map(preimage);
            wrapper.computed = true;
            for (KeyListener<T> listener : this.keyListeners) {
                listener.keyAdded(preimage);
            }
        }
        if (!wrapper.computed) {
            throw new IllegalStateException("Recursive calls are not allowed");
        }
        return (R)wrapper.value;
    }

    public void invalidate(T preimage) {
        this.cache.remove(preimage);
    }

    public boolean caches(T preimage) {
        return this.cache.get(preimage) != null;
    }

    public Collection<T> getCachedPreimages() {
        return new HashSet<T>(this.cache.keySet());
    }

    public void addKeyListener(KeyListener<T> listener) {
        this.keyListeners.add(listener);
    }

    public static interface KeyListener<S> {
        public void keyAdded(S var1);
    }

    private static class Wrapper<S> {
        S value;
        boolean computed;

        private Wrapper() {
        }
    }
}

