/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.cache.FileNameEncoder;
import org.teavm.cache.ProgramIO;
import org.teavm.cache.SymbolTable;
import org.teavm.model.BasicBlock;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ProgramCache;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.parsing.ClassDateProvider;

public class DiskProgramCache
implements ProgramCache {
    private File directory;
    private ProgramIO programIO;
    private Map<MethodReference, Item> cache = new HashMap<MethodReference, Item>();
    private Set<MethodReference> newMethods = new HashSet<MethodReference>();
    private ClassDateProvider classDateProvider;

    public DiskProgramCache(File directory, SymbolTable symbolTable, SymbolTable fileTable, ClassDateProvider classDateProvider) {
        this.directory = directory;
        this.programIO = new ProgramIO(symbolTable, fileTable);
        this.classDateProvider = classDateProvider;
    }

    @Override
    public Program get(MethodReference method) {
        Item item = this.cache.get(method);
        if (item == null) {
            item = new Item();
            this.cache.put(method, item);
            File file = this.getMethodFile(method);
            if (file.exists()) {
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    DataInputStream input = new DataInputStream(stream);
                    int depCount = input.readShort();
                    boolean dependenciesChanged = false;
                    for (int i = 0; i < depCount; ++i) {
                        String depClass = input.readUTF();
                        Date depDate = this.classDateProvider.getModificationDate(depClass);
                        if (depDate != null && !depDate.after(new Date(file.lastModified()))) continue;
                        dependenciesChanged = true;
                        break;
                    }
                    if (!dependenciesChanged) {
                        item.program = this.programIO.read(stream);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return item.program;
    }

    @Override
    public void store(MethodReference method, Program program) {
        Item item = new Item();
        this.cache.put(method, item);
        item.program = program;
        this.newMethods.add(method);
    }

    public void flush() throws IOException {
        for (MethodReference method : this.newMethods) {
            File file = this.getMethodFile(method);
            ProgramDependencyAnalyzer analyzer = new ProgramDependencyAnalyzer();
            analyzer.dependencies.add(method.getClassName());
            Program program = this.cache.get((Object)method).program;
            for (int i = 0; i < program.basicBlockCount(); ++i) {
                BasicBlock block = program.basicBlockAt(i);
                for (Instruction insn : block.getInstructions()) {
                    insn.acceptVisitor(analyzer);
                }
            }
            file.getParentFile().mkdirs();
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
            Throwable throwable = null;
            try {
                DataOutputStream output = new DataOutputStream(stream);
                output.writeShort(analyzer.dependencies.size());
                for (String dep : analyzer.dependencies) {
                    output.writeUTF(dep);
                }
                this.programIO.write(program, stream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)stream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((OutputStream)stream).close();
            }
        }
    }

    private File getMethodFile(MethodReference method) {
        File dir = new File(this.directory, method.getClassName().replace('.', '/'));
        return new File(dir, FileNameEncoder.encodeFileName(method.getDescriptor().toString()) + ".teavm-opt");
    }

    static class ProgramDependencyAnalyzer
    implements InstructionVisitor {
        Set<String> dependencies = new HashSet<String>();

        ProgramDependencyAnalyzer() {
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            this.dependencies.add(insn.getField().getClassName());
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            this.dependencies.add(insn.getField().getClassName());
        }

        @Override
        public void visit(InvokeInstruction insn) {
            this.dependencies.add(insn.getMethod().getClassName());
        }

        @Override
        public void visit(EmptyInstruction insn) {
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
        }

        @Override
        public void visit(NullConstantInstruction insn) {
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
        }

        @Override
        public void visit(LongConstantInstruction insn) {
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
        }

        @Override
        public void visit(StringConstantInstruction insn) {
        }

        @Override
        public void visit(BinaryInstruction insn) {
        }

        @Override
        public void visit(NegateInstruction insn) {
        }

        @Override
        public void visit(AssignInstruction insn) {
        }

        @Override
        public void visit(CastInstruction insn) {
        }

        @Override
        public void visit(CastNumberInstruction insn) {
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
        }

        @Override
        public void visit(BranchingInstruction insn) {
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
        }

        @Override
        public void visit(JumpInstruction insn) {
        }

        @Override
        public void visit(SwitchInstruction insn) {
        }

        @Override
        public void visit(ExitInstruction insn) {
        }

        @Override
        public void visit(RaiseInstruction insn) {
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
        }

        @Override
        public void visit(ConstructInstruction insn) {
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
        }

        @Override
        public void visit(GetElementInstruction insn) {
        }

        @Override
        public void visit(PutElementInstruction insn) {
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
        }

        @Override
        public void visit(InitClassInstruction insn) {
        }

        @Override
        public void visit(NullCheckInstruction insn) {
        }

        @Override
        public void visit(MonitorEnterInstruction insn) {
        }

        @Override
        public void visit(MonitorExitInstruction insn) {
        }
    }

    static class Item {
        Program program;

        Item() {
        }
    }
}

