/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.optimization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphUtils;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReader;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.model.util.ProgramUtils;
import org.teavm.optimization.MethodOptimization;

public class GlobalValueNumbering
implements MethodOptimization {
    private Map<String, KnownValue> knownValues = new HashMap<String, KnownValue>();
    private boolean eliminate;
    private int[] map;
    private Program program;
    private int currentBlockIndex;
    private DominatorTree domTree;
    private InstructionVisitor optimizer = new InstructionVisitor(){

        @Override
        public void visit(EmptyInstruction insn) {
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
        }

        @Override
        public void visit(NullConstantInstruction insn) {
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
        }

        @Override
        public void visit(LongConstantInstruction insn) {
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
        }

        @Override
        public void visit(StringConstantInstruction insn) {
        }

        @Override
        public void visit(BinaryInstruction insn) {
            String value;
            int a = GlobalValueNumbering.this.map[insn.getFirstOperand().getIndex()];
            int b = GlobalValueNumbering.this.map[insn.getSecondOperand().getIndex()];
            insn.setFirstOperand(GlobalValueNumbering.this.program.variableAt(a));
            insn.setSecondOperand(GlobalValueNumbering.this.program.variableAt(b));
            boolean commutative = false;
            switch (insn.getOperation()) {
                case ADD: {
                    value = "+";
                    commutative = true;
                    break;
                }
                case SUBTRACT: {
                    value = "-";
                    break;
                }
                case MULTIPLY: {
                    value = "*";
                    commutative = true;
                    break;
                }
                case DIVIDE: {
                    value = "/";
                    break;
                }
                case MODULO: {
                    value = "%";
                    break;
                }
                case COMPARE: {
                    value = "$";
                    break;
                }
                case AND: {
                    value = "&";
                    commutative = true;
                    break;
                }
                case OR: {
                    value = "|";
                    commutative = true;
                    break;
                }
                case XOR: {
                    value = "^";
                    commutative = true;
                    break;
                }
                case SHIFT_LEFT: {
                    value = "<<";
                    break;
                }
                case SHIFT_RIGHT: {
                    value = ">>";
                    break;
                }
                case SHIFT_RIGHT_UNSIGNED: {
                    value = ">>>";
                    break;
                }
                default: {
                    return;
                }
            }
            GlobalValueNumbering.this.bind(insn.getReceiver().getIndex(), "@" + a + value + "@" + b);
            if (commutative) {
                GlobalValueNumbering.this.bind(insn.getReceiver().getIndex(), "@" + b + value + "@" + a);
            }
        }

        @Override
        public void visit(NegateInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getOperand().getIndex()];
            insn.setOperand(GlobalValueNumbering.this.program.variableAt(a));
            GlobalValueNumbering.this.bind(insn.getReceiver().getIndex(), "-@" + a);
        }

        @Override
        public void visit(AssignInstruction insn) {
            ((GlobalValueNumbering)GlobalValueNumbering.this).map[insn.getReceiver().getIndex()] = GlobalValueNumbering.this.map[insn.getAssignee().getIndex()];
            GlobalValueNumbering.this.eliminate = true;
        }

        @Override
        public void visit(CastInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getValue().getIndex()];
            insn.setValue(GlobalValueNumbering.this.program.variableAt(a));
            GlobalValueNumbering.this.bind(insn.getReceiver().getIndex(), "@" + a + "::" + insn.getTargetType());
        }

        @Override
        public void visit(CastNumberInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getValue().getIndex()];
            insn.setValue(GlobalValueNumbering.this.program.variableAt(a));
            GlobalValueNumbering.this.bind(insn.getReceiver().getIndex(), "@" + a + "::" + (Object)((Object)insn.getTargetType()));
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getValue().getIndex()];
            insn.setValue(GlobalValueNumbering.this.program.variableAt(a));
            GlobalValueNumbering.this.bind(insn.getReceiver().getIndex(), "@" + a + "::" + (Object)((Object)insn.getTargetType()) + " " + (Object)((Object)insn.getDirection()));
        }

        @Override
        public void visit(BranchingInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getOperand().getIndex()];
            insn.setOperand(GlobalValueNumbering.this.program.variableAt(a));
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getFirstOperand().getIndex()];
            int b = GlobalValueNumbering.this.map[insn.getSecondOperand().getIndex()];
            insn.setFirstOperand(GlobalValueNumbering.this.program.variableAt(a));
            insn.setSecondOperand(GlobalValueNumbering.this.program.variableAt(b));
        }

        @Override
        public void visit(JumpInstruction insn) {
        }

        @Override
        public void visit(SwitchInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getCondition().getIndex()];
            insn.setCondition(GlobalValueNumbering.this.program.variableAt(a));
        }

        @Override
        public void visit(ExitInstruction insn) {
            if (insn.getValueToReturn() != null) {
                int a = GlobalValueNumbering.this.map[insn.getValueToReturn().getIndex()];
                insn.setValueToReturn(GlobalValueNumbering.this.program.variableAt(a));
            }
        }

        @Override
        public void visit(RaiseInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getException().getIndex()];
            insn.setException(GlobalValueNumbering.this.program.variableAt(a));
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getSize().getIndex()];
            insn.setSize(GlobalValueNumbering.this.program.variableAt(a));
        }

        @Override
        public void visit(ConstructInstruction insn) {
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            for (int i = 0; i < insn.getDimensions().size(); ++i) {
                int a = GlobalValueNumbering.this.map[insn.getDimensions().get(i).getIndex()];
                insn.getDimensions().set(i, GlobalValueNumbering.this.program.variableAt(a));
            }
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            if (insn.getInstance() != null) {
                int instance = GlobalValueNumbering.this.map[insn.getInstance().getIndex()];
                insn.setInstance(GlobalValueNumbering.this.program.variableAt(instance));
            }
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            if (insn.getInstance() != null) {
                int instance = GlobalValueNumbering.this.map[insn.getInstance().getIndex()];
                insn.setInstance(GlobalValueNumbering.this.program.variableAt(instance));
            }
            int val = GlobalValueNumbering.this.map[insn.getValue().getIndex()];
            insn.setValue(GlobalValueNumbering.this.program.variableAt(val));
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getArray().getIndex()];
            insn.setArray(GlobalValueNumbering.this.program.variableAt(a));
            GlobalValueNumbering.this.bind(insn.getReceiver().getIndex(), "@" + a + ".length");
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getArray().getIndex()];
            insn.setArray(GlobalValueNumbering.this.program.variableAt(a));
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getArray().getIndex()];
            insn.setArray(GlobalValueNumbering.this.program.variableAt(a));
            GlobalValueNumbering.this.bind(insn.getReceiver().getIndex(), "@" + a + ".data");
        }

        @Override
        public void visit(GetElementInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getArray().getIndex()];
            insn.setArray(GlobalValueNumbering.this.program.variableAt(a));
            int index = GlobalValueNumbering.this.map[insn.getIndex().getIndex()];
            insn.setIndex(GlobalValueNumbering.this.program.variableAt(index));
        }

        @Override
        public void visit(PutElementInstruction insn) {
            int a = GlobalValueNumbering.this.map[insn.getArray().getIndex()];
            insn.setArray(GlobalValueNumbering.this.program.variableAt(a));
            int index = GlobalValueNumbering.this.map[insn.getIndex().getIndex()];
            insn.setIndex(GlobalValueNumbering.this.program.variableAt(index));
            int val = GlobalValueNumbering.this.map[insn.getValue().getIndex()];
            insn.setValue(GlobalValueNumbering.this.program.variableAt(val));
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (insn.getInstance() != null) {
                int instance = GlobalValueNumbering.this.map[insn.getInstance().getIndex()];
                insn.setInstance(GlobalValueNumbering.this.program.variableAt(instance));
            }
            for (int i = 0; i < insn.getArguments().size(); ++i) {
                int arg = GlobalValueNumbering.this.map[insn.getArguments().get(i).getIndex()];
                insn.getArguments().set(i, GlobalValueNumbering.this.program.variableAt(arg));
            }
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            int val = GlobalValueNumbering.this.map[insn.getValue().getIndex()];
            insn.setValue(GlobalValueNumbering.this.program.variableAt(val));
            GlobalValueNumbering.this.bind(insn.getReceiver().getIndex(), "@" + val + " :? " + insn.getType());
        }

        @Override
        public void visit(InitClassInstruction insn) {
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            int val = GlobalValueNumbering.this.map[insn.getValue().getIndex()];
            insn.setValue(GlobalValueNumbering.this.program.variableAt(val));
            GlobalValueNumbering.this.bind(insn.getReceiver().getIndex(), "nullCheck @" + val);
        }

        @Override
        public void visit(MonitorEnterInstruction insn) {
            int val = GlobalValueNumbering.this.map[insn.getObjectRef().getIndex()];
            insn.setObjectRef(GlobalValueNumbering.this.program.variableAt(val));
        }

        @Override
        public void visit(MonitorExitInstruction insn) {
            int val = GlobalValueNumbering.this.map[insn.getObjectRef().getIndex()];
            insn.setObjectRef(GlobalValueNumbering.this.program.variableAt(val));
        }
    };

    @Override
    public void optimize(MethodReader method, Program program) {
        int i;
        this.program = program;
        this.knownValues.clear();
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        this.domTree = GraphUtils.buildDominatorTree(cfg);
        Graph dom = GraphUtils.buildDominatorGraph(this.domTree, cfg.size());
        this.map = new int[program.variableCount()];
        for (int i2 = 0; i2 < this.map.length; ++i2) {
            this.map[i2] = i2;
        }
        List<List<Incoming>> outgoings = this.findOutgoings(program);
        int[] stack = new int[cfg.size() * 2];
        int top = 0;
        for (i = 0; i < cfg.size(); ++i) {
            if (cfg.incomingEdgesCount(i) != 0) continue;
            stack[top++] = i;
        }
        while (top > 0) {
            int v;
            this.currentBlockIndex = v = stack[--top];
            BasicBlock block = program.basicBlockAt(v);
            for (int i3 = 0; i3 < block.getInstructions().size(); ++i3) {
                Instruction currentInsn = block.getInstructions().get(i3);
                currentInsn.acceptVisitor(this.optimizer);
                if (!this.eliminate) continue;
                block.getInstructions().set(i3, new EmptyInstruction());
                this.eliminate = false;
            }
            for (Incoming incoming : outgoings.get(v)) {
                int value = this.map[incoming.getValue().getIndex()];
                incoming.setValue(program.variableAt(value));
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                int var = this.map[tryCatch.getExceptionVariable().getIndex()];
                tryCatch.setExceptionVariable(program.variableAt(var));
            }
            for (Object succ : (Object)dom.outgoingEdges(v)) {
                stack[top++] = (int)succ;
            }
        }
        for (i = 0; i < this.map.length; ++i) {
            if (this.map[i] == i) continue;
            Variable var = program.variableAt(i);
            Variable mapVar = program.variableAt(this.map[i]);
            mapVar.getDebugNames().addAll(var.getDebugNames());
            program.deleteVariable(i);
        }
        program.pack();
        this.program = null;
    }

    private List<List<Incoming>> findOutgoings(Program program) {
        int i;
        ArrayList<List<Incoming>> outgoings = new ArrayList<List<Incoming>>();
        for (i = 0; i < program.basicBlockCount(); ++i) {
            outgoings.add(new ArrayList());
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            for (Phi phi : program.basicBlockAt(i).getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    ((List)outgoings.get(incoming.getSource().getIndex())).add(incoming);
                }
            }
        }
        return outgoings;
    }

    private void bind(int var, String value) {
        KnownValue known = this.knownValues.get(value);
        if (known != null && this.domTree.dominates(known.location, this.currentBlockIndex) && known.value != var) {
            this.eliminate = true;
            this.map[var] = known.value;
        } else {
            known = new KnownValue();
            known.location = this.currentBlockIndex;
            known.value = var;
            this.knownValues.put(value, known);
        }
    }

    private static class KnownValue {
        int value;
        int location;

        private KnownValue() {
        }
    }
}

