/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayList;
import java.util.Arrays;
import org.teavm.common.DefaultDominatorTree;
import org.teavm.common.DominatorTree;
import org.teavm.common.DominatorTreeBuilder;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.GraphNodeFilter;
import org.teavm.common.GraphSplittingBackend;
import org.teavm.common.IntegerArray;
import org.teavm.common.IntegerStack;
import org.teavm.common.IrreducibleGraphConverter;

public final class GraphUtils {
    static final byte NONE = 0;
    static final byte VISITING = 1;
    static final byte VISITED = 2;

    private GraphUtils() {
    }

    public static int[] findBackEdges(Graph graph) {
        int sz = graph.size();
        int[] stack = new int[sz * 2];
        int stackSize = 0;
        byte[] state = new byte[sz];
        for (int i = 0; i < sz; ++i) {
            if (graph.incomingEdgesCount(i) != 0) continue;
            stack[stackSize++] = i;
        }
        IntegerArray result = new IntegerArray(2);
        block9: while (stackSize > 0) {
            int node = stack[--stackSize];
            switch (state[node]) {
                case 0: {
                    state[node] = 1;
                    stack[stackSize++] = node;
                    block10: for (int next : graph.outgoingEdges(node)) {
                        switch (state[next]) {
                            case 0: {
                                stack[stackSize++] = next;
                                continue block10;
                            }
                            case 1: {
                                result.add(node);
                                result.add(next);
                            }
                        }
                    }
                    continue block9;
                }
                case 1: {
                    state[node] = 2;
                }
            }
        }
        return result.getAll();
    }

    public static boolean isIrreducible(Graph graph) {
        DominatorTree dom = GraphUtils.buildDominatorTree(graph);
        int[] backEdges = GraphUtils.findBackEdges(graph);
        for (int i = 0; i < backEdges.length; i += 2) {
            if (dom.dominates(backEdges[i + 1], backEdges[i])) continue;
            return true;
        }
        return false;
    }

    public static int[][] findStronglyConnectedComponents(Graph graph, int[] start) {
        return GraphUtils.findStronglyConnectedComponents(graph, start, new GraphNodeFilter(){

            @Override
            public boolean match(int node) {
                return true;
            }
        });
    }

    public static int[][] findStronglyConnectedComponents(Graph graph, int[] start, GraphNodeFilter filter) {
        ArrayList<int[]> components = new ArrayList<int[]>();
        int[] visitIndex = new int[graph.size()];
        int[] headerIndex = new int[graph.size()];
        int lastIndex = 0;
        IntegerStack stack = new IntegerStack(graph.size());
        for (int startNode : start) {
            stack.push(startNode);
            IntegerStack currentComponent = new IntegerStack(1);
            while (!stack.isEmpty()) {
                int node = stack.pop();
                if (visitIndex[node] > 0) {
                    if (headerIndex[node] > 0) continue;
                    int hdr = visitIndex[node];
                    int[] nArray = graph.outgoingEdges(node);
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        int successor = nArray[i];
                        if (!filter.match(successor)) continue;
                        hdr = headerIndex[successor] == 0 ? Math.min(hdr, visitIndex[successor]) : Math.min(hdr, headerIndex[successor]);
                    }
                    if (hdr == visitIndex[node]) {
                        int componentMember;
                        IntegerArray componentMembers = new IntegerArray(graph.size());
                        do {
                            componentMember = currentComponent.pop();
                            componentMembers.add(componentMember);
                            headerIndex[componentMember] = graph.size() + 1;
                        } while (visitIndex[componentMember] != hdr);
                        components.add(componentMembers.getAll());
                    }
                    headerIndex[node] = hdr;
                    continue;
                }
                visitIndex[node] = ++lastIndex;
                currentComponent.push(node);
                stack.push(node);
                for (int successor : graph.outgoingEdges(node)) {
                    if (!filter.match(successor) || visitIndex[successor] > 0) continue;
                    stack.push(successor);
                }
            }
            for (int i = 0; i < headerIndex.length; ++i) {
                if (visitIndex[i] <= 0) continue;
                headerIndex[i] = graph.size() + 1;
            }
        }
        return (int[][])components.toArray((T[])new int[0][]);
    }

    public static DominatorTree buildDominatorTree(Graph graph) {
        DominatorTreeBuilder builder = new DominatorTreeBuilder(graph);
        builder.build();
        return new DefaultDominatorTree(builder.dominators, builder.vertices);
    }

    public static Graph buildDominatorGraph(DominatorTree domTree, int sz) {
        GraphBuilder graph = new GraphBuilder(sz);
        for (int i = 0; i < sz; ++i) {
            int idom = domTree.immediateDominatorOf(i);
            if (idom < 0) continue;
            graph.addEdge(idom, i);
        }
        return graph.build();
    }

    public static void splitIrreducibleGraph(Graph graph, int[] weights, GraphSplittingBackend backend) {
        new IrreducibleGraphConverter().convertToReducible(graph, weights, backend);
    }

    public static int[][] findDominanceFrontiers(Graph cfg, DominatorTree domTree) {
        IntegerArray[] tmpFrontiers = new IntegerArray[cfg.size()];
        int[][] domFrontiers = new int[cfg.size()][];
        int[] descCount = new int[cfg.size()];
        for (int i = 0; i < cfg.size(); ++i) {
            int idom = domTree.immediateDominatorOf(i);
            if (idom < 0) continue;
            int n = idom;
            descCount[n] = descCount[n] + 1;
        }
        int[] stack = new int[cfg.size() * 2];
        int head = 0;
        for (int i = 0; i < cfg.size(); ++i) {
            if (descCount[i] != 0) continue;
            stack[head++] = i;
        }
        while (head > 0) {
            int node;
            IntegerArray frontier;
            if ((frontier = tmpFrontiers[node = stack[--head]]) == null) {
                frontier = new IntegerArray(1);
            }
            int idom = domTree.immediateDominatorOf(node);
            for (int successor : cfg.outgoingEdges(node)) {
                if (domTree.immediateDominatorOf(successor) == node) continue;
                frontier.add(successor);
            }
            tmpFrontiers[node] = null;
            int[] frontierSet = GraphUtils.makeSet(frontier);
            domFrontiers[node] = frontierSet;
            if (idom < 0) continue;
            for (int element : frontierSet) {
                if (domTree.immediateDominatorOf(element) == idom) continue;
                IntegerArray idomFrontier = tmpFrontiers[idom];
                if (idomFrontier == null) {
                    tmpFrontiers[idom] = idomFrontier = new IntegerArray(1);
                }
                idomFrontier.add(element);
            }
            int n = idom;
            descCount[n] = descCount[n] - 1;
            if (descCount[n] != 0) continue;
            stack[head++] = idom;
        }
        return domFrontiers;
    }

    private static int[] makeSet(IntegerArray array) {
        int[] items = array.getAll();
        int[] set = new int[items.length];
        int sz = 0;
        int last = -1;
        for (int i = 0; i < items.length; ++i) {
            int item = items[i];
            if (item == last) continue;
            set[sz++] = item;
            last = item;
        }
        if (sz != set.length) {
            set = Arrays.copyOf(set, sz);
        }
        return set;
    }
}

