/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.Arrays;
import org.teavm.common.DefaultDominatorTree;
import org.teavm.common.DominatorTree;
import org.teavm.common.DominatorTreeBuilder;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.IntegerArray;

public final class GraphUtils {
    static final byte NONE = 0;
    static final byte VISITING = 1;
    static final byte VISITED = 2;

    private GraphUtils() {
    }

    public static Graph invert(Graph graph) {
        int sz = graph.size();
        GraphBuilder result = new GraphBuilder();
        int[] sourceEdges = new int[sz];
        for (int node = 0; node < sz; ++node) {
            int sourceCount = graph.copyIncomingEdges(node, sourceEdges);
            for (int i = 0; i < sourceCount; ++i) {
                int source = sourceEdges[i];
                result.addEdge(node, source);
            }
        }
        return result.build();
    }

    public static Graph close(Graph graph) {
        GraphBuilder result = new GraphBuilder();
        for (int node = 0; node < graph.size(); ++node) {
            int[] next;
            for (int target : next = graph.outgoingEdges(node)) {
                result.addEdge(node, target);
            }
            if (next.length != 0) continue;
            result.addEdge(node, graph.size());
        }
        return result.build();
    }

    public static Graph removeLoops(Graph graph) {
        int sz = graph.size();
        GraphBuilder result = new GraphBuilder();
        int[] stack = new int[sz * 2];
        int stackSize = 0;
        byte[] state = new byte[sz];
        for (int i = 0; i < sz; ++i) {
            if (graph.incomingEdgesCount(i) != 0) continue;
            stack[stackSize++] = i;
        }
        block9: while (stackSize > 0) {
            int node = stack[--stackSize];
            switch (state[node]) {
                case 0: {
                    state[node] = 1;
                    stack[stackSize++] = node;
                    block10: for (int next : graph.outgoingEdges(node)) {
                        switch (state[next]) {
                            case 0: {
                                result.addEdge(node, next);
                                stack[stackSize++] = next;
                                continue block10;
                            }
                            case 2: {
                                result.addEdge(node, next);
                            }
                        }
                    }
                    continue block9;
                }
                case 1: {
                    state[node] = 2;
                }
            }
        }
        return result.build();
    }

    public static int edgeCount(Graph graph) {
        int cnt = 0;
        int sz = graph.size();
        for (int node = 0; node < sz; ++node) {
            cnt += graph.outgoingEdgesCount(node);
        }
        return cnt;
    }

    public static DominatorTree buildDominatorTree(Graph graph) {
        DominatorTreeBuilder builder = new DominatorTreeBuilder(graph);
        builder.build();
        return new DefaultDominatorTree(builder.dominators, builder.vertices);
    }

    public static Graph buildDominatorGraph(DominatorTree domTree, int sz) {
        GraphBuilder graph = new GraphBuilder(sz);
        for (int i = 0; i < sz; ++i) {
            int idom = domTree.immediateDominatorOf(i);
            if (idom < 0) continue;
            graph.addEdge(idom, i);
        }
        return graph.build();
    }

    public static int[][] findDominanceFrontiers(Graph cfg, DominatorTree domTree) {
        IntegerArray[] tmpFrontiers = new IntegerArray[cfg.size()];
        int[][] domFrontiers = new int[cfg.size()][];
        int[] descCount = new int[cfg.size()];
        for (int i = 0; i < cfg.size(); ++i) {
            int idom = domTree.immediateDominatorOf(i);
            if (idom < 0) continue;
            int n = idom;
            descCount[n] = descCount[n] + 1;
        }
        int[] stack = new int[cfg.size() * 2];
        int head = 0;
        for (int i = 0; i < cfg.size(); ++i) {
            if (descCount[i] != 0) continue;
            stack[head++] = i;
        }
        while (head > 0) {
            int node;
            IntegerArray frontier;
            if ((frontier = tmpFrontiers[node = stack[--head]]) == null) {
                frontier = new IntegerArray(1);
            }
            int idom = domTree.immediateDominatorOf(node);
            for (int successor : cfg.outgoingEdges(node)) {
                if (domTree.immediateDominatorOf(successor) == node) continue;
                frontier.add(successor);
            }
            tmpFrontiers[node] = null;
            int[] frontierSet = GraphUtils.makeSet(frontier);
            domFrontiers[node] = frontierSet;
            if (idom < 0) continue;
            for (int element : frontierSet) {
                if (domTree.immediateDominatorOf(element) == idom) continue;
                IntegerArray idomFrontier = tmpFrontiers[idom];
                if (idomFrontier == null) {
                    tmpFrontiers[idom] = idomFrontier = new IntegerArray(1);
                }
                idomFrontier.add(element);
            }
            int n = idom;
            descCount[n] = descCount[n] - 1;
            if (descCount[n] != 0) continue;
            stack[head++] = idom;
        }
        return domFrontiers;
    }

    private static int[] makeSet(IntegerArray array) {
        int[] items = array.getAll();
        int[] set = new int[items.length];
        int sz = 0;
        int last = -1;
        for (int i = 0; i < items.length; ++i) {
            int item = items[i];
            if (item == last) continue;
            set[sz++] = item;
            last = item;
        }
        if (sz != set.length) {
            set = Arrays.copyOf(set, sz);
        }
        return set;
    }
}

