/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.cache.ProgramIO;
import org.teavm.cache.SymbolTable;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.ValueType;
import org.teavm.parsing.ClassDateProvider;

public class DiskCachedClassHolderSource
implements ClassHolderSource {
    private static AccessLevel[] accessLevels = AccessLevel.values();
    private static ElementModifier[] elementModifiers = ElementModifier.values();
    private File directory;
    private SymbolTable symbolTable;
    private ClassHolderSource innerSource;
    private ClassDateProvider classDateProvider;
    private Map<String, Item> cache = new HashMap<String, Item>();
    private Set<String> newClasses = new HashSet<String>();
    private ProgramIO programIO;

    public DiskCachedClassHolderSource(File directory, SymbolTable symbolTable, SymbolTable fileTable, ClassHolderSource innerSource, ClassDateProvider classDateProvider) {
        this.directory = directory;
        this.symbolTable = symbolTable;
        this.innerSource = innerSource;
        this.classDateProvider = classDateProvider;
        this.programIO = new ProgramIO(symbolTable, fileTable);
    }

    @Override
    public ClassHolder get(String name) {
        Item item = this.cache.get(name);
        if (item == null) {
            Date classDate;
            item = new Item();
            this.cache.put(name, item);
            File classFile = new File(this.directory, name.replace('.', '/') + ".teavm-cls");
            if (classFile.exists() && (classDate = this.classDateProvider.getModificationDate(name)) != null && classDate.before(new Date(classFile.lastModified()))) {
                try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(classFile));){
                    item.cls = this.readClass(input, name);
                }
                catch (IOException e) {
                    item.cls = null;
                }
            }
            if (item.cls == null) {
                item.cls = this.innerSource.get(name);
                this.newClasses.add(name);
            }
        }
        return item.cls;
    }

    public void flush() throws IOException {
        for (String className : this.newClasses) {
            Item item = this.cache.get(className);
            if (item.cls == null) continue;
            File classFile = new File(this.directory, className.replace('.', '/') + ".teavm-cls");
            classFile.getParentFile().mkdirs();
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(classFile));
            Throwable throwable = null;
            try {
                this.writeClass(output, item.cls);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (output == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)output).close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                ((OutputStream)output).close();
            }
        }
    }

    private void writeClass(OutputStream stream, ClassHolder cls) throws IOException {
        DataOutputStream output = new DataOutputStream(stream);
        output.writeByte(cls.getLevel().ordinal());
        output.writeInt(this.packModifiers(cls.getModifiers()));
        output.writeInt(cls.getParent() != null ? this.symbolTable.lookup(cls.getParent()) : -1);
        output.writeInt(cls.getOwnerName() != null ? this.symbolTable.lookup(cls.getOwnerName()) : -1);
        output.writeByte(cls.getInterfaces().size());
        for (String iface : cls.getInterfaces()) {
            output.writeInt(this.symbolTable.lookup(iface));
        }
        this.writeAnnotations(output, cls.getAnnotations());
        output.writeShort(cls.getFields().size());
        for (FieldHolder field : cls.getFields()) {
            this.writeField(output, field);
        }
        output.writeShort(cls.getMethods().size());
        for (MethodHolder method : cls.getMethods()) {
            this.writeMethod(stream, method);
        }
    }

    private ClassHolder readClass(InputStream stream, String name) throws IOException {
        DataInputStream input = new DataInputStream(stream);
        ClassHolder cls = new ClassHolder(name);
        cls.setLevel(accessLevels[input.readByte()]);
        cls.getModifiers().addAll(this.unpackModifiers(input.readInt()));
        int parentIndex = input.readInt();
        cls.setParent(parentIndex >= 0 ? this.symbolTable.at(parentIndex) : null);
        int ownerIndex = input.readInt();
        cls.setOwnerName(ownerIndex >= 0 ? this.symbolTable.at(ownerIndex) : null);
        int ifaceCount = input.readByte();
        for (int i = 0; i < ifaceCount; ++i) {
            cls.getInterfaces().add(this.symbolTable.at(input.readInt()));
        }
        this.readAnnotations(input, cls.getAnnotations());
        int fieldCount = input.readShort();
        for (int i = 0; i < fieldCount; ++i) {
            cls.addField(this.readField(input));
        }
        int methodCount = input.readShort();
        for (int i = 0; i < methodCount; ++i) {
            cls.addMethod(this.readMethod(stream));
        }
        return cls;
    }

    private void writeField(DataOutput output, FieldHolder field) throws IOException {
        output.writeInt(this.symbolTable.lookup(field.getName()));
        output.writeInt(this.symbolTable.lookup(field.getType().toString()));
        output.writeByte(field.getLevel().ordinal());
        output.writeInt(this.packModifiers(field.getModifiers()));
        this.writeFieldValue(output, field.getInitialValue());
        this.writeAnnotations(output, field.getAnnotations());
    }

    private FieldHolder readField(DataInput input) throws IOException {
        FieldHolder field = new FieldHolder(this.symbolTable.at(input.readInt()));
        field.setType(ValueType.parse(this.symbolTable.at(input.readInt())));
        field.setLevel(accessLevels[input.readByte()]);
        field.getModifiers().addAll(this.unpackModifiers(input.readInt()));
        field.setInitialValue(this.readFieldValue(input));
        this.readAnnotations(input, field.getAnnotations());
        return field;
    }

    private void writeFieldValue(DataOutput output, Object value) throws IOException {
        if (value == null) {
            output.writeByte(0);
        } else if (value instanceof Integer) {
            output.writeByte(1);
            output.writeInt((Integer)value);
        } else if (value instanceof Long) {
            output.writeByte(2);
            output.writeLong((Long)value);
        } else if (value instanceof Float) {
            output.writeByte(3);
            output.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            output.writeByte(4);
            output.writeDouble((Double)value);
        } else if (value instanceof String) {
            output.writeByte(5);
            output.writeUTF((String)value);
        }
    }

    private Object readFieldValue(DataInput input) throws IOException {
        byte type = input.readByte();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return input.readInt();
            }
            case 2: {
                return input.readLong();
            }
            case 3: {
                return Float.valueOf(input.readFloat());
            }
            case 4: {
                return input.readDouble();
            }
            case 5: {
                return input.readUTF();
            }
        }
        throw new RuntimeException("Unexpected field value type: " + type);
    }

    private void writeMethod(OutputStream stream, MethodHolder method) throws IOException {
        DataOutputStream output = new DataOutputStream(stream);
        output.writeInt(this.symbolTable.lookup(method.getDescriptor().toString()));
        output.writeByte(method.getLevel().ordinal());
        output.writeInt(this.packModifiers(method.getModifiers()));
        this.writeAnnotations(output, method.getAnnotations());
        if (method.getProgram() != null) {
            output.writeBoolean(true);
            this.programIO.write(method.getProgram(), output);
        } else {
            output.writeBoolean(false);
        }
    }

    private MethodHolder readMethod(InputStream stream) throws IOException {
        DataInputStream input = new DataInputStream(stream);
        MethodHolder method = new MethodHolder(MethodDescriptor.parse(this.symbolTable.at(input.readInt())));
        method.setLevel(accessLevels[input.readByte()]);
        method.getModifiers().addAll(this.unpackModifiers(input.readInt()));
        this.readAnnotations(input, method.getAnnotations());
        boolean hasProgram = input.readBoolean();
        if (hasProgram) {
            method.setProgram(this.programIO.read(input));
        }
        return method;
    }

    private void writeAnnotations(DataOutput output, AnnotationContainer annotations) throws IOException {
        ArrayList<AnnotationHolder> annotationList = new ArrayList<AnnotationHolder>();
        for (AnnotationHolder annot : annotations.all()) {
            annotationList.add(annot);
        }
        output.writeShort(annotationList.size());
        for (AnnotationHolder annot : annotationList) {
            this.writeAnnotation(output, annot);
        }
    }

    private void readAnnotations(DataInput input, AnnotationContainer annotations) throws IOException {
        int annotCount = input.readShort();
        for (int i = 0; i < annotCount; ++i) {
            AnnotationHolder annot = this.readAnnotation(input);
            annotations.add(annot);
        }
    }

    private void writeAnnotation(DataOutput output, AnnotationHolder annotation) throws IOException {
        output.writeInt(this.symbolTable.lookup(annotation.getType()));
        output.writeShort(annotation.getValues().size());
        for (Map.Entry<String, AnnotationValue> entry : annotation.getValues().entrySet()) {
            output.writeInt(this.symbolTable.lookup(entry.getKey()));
            this.writeAnnotationValue(output, entry.getValue());
        }
    }

    private AnnotationHolder readAnnotation(DataInput input) throws IOException {
        AnnotationHolder annotation = new AnnotationHolder(this.symbolTable.at(input.readInt()));
        int valueCount = input.readShort();
        for (int i = 0; i < valueCount; ++i) {
            String name = this.symbolTable.at(input.readInt());
            AnnotationValue value = this.readAnnotationValue(input);
            annotation.getValues().put(name, value);
        }
        return annotation;
    }

    private void writeAnnotationValue(DataOutput output, AnnotationValue value) throws IOException {
        output.writeByte(value.getType());
        switch (value.getType()) {
            case 11: {
                this.writeAnnotation(output, value.getAnnotation());
                break;
            }
            case 0: {
                output.writeBoolean(value.getBoolean());
                break;
            }
            case 1: {
                output.writeByte(value.getByte());
                break;
            }
            case 8: {
                output.writeInt(this.symbolTable.lookup(value.getJavaClass().toString()));
                break;
            }
            case 6: {
                output.writeDouble(value.getDouble());
                break;
            }
            case 10: {
                output.writeInt(this.symbolTable.lookup(value.getEnumValue().getClassName()));
                output.writeInt(this.symbolTable.lookup(value.getEnumValue().getFieldName()));
                break;
            }
            case 5: {
                output.writeDouble(value.getFloat());
                break;
            }
            case 3: {
                output.writeInt(value.getInt());
                break;
            }
            case 9: {
                List<AnnotationValue> list = value.getList();
                output.writeShort(list.size());
                for (AnnotationValue item : list) {
                    this.writeAnnotationValue(output, item);
                }
                break;
            }
            case 4: {
                output.writeLong(value.getLong());
                break;
            }
            case 2: {
                output.writeShort(value.getShort());
                break;
            }
            case 7: {
                output.writeUTF(value.getString());
            }
        }
    }

    private AnnotationValue readAnnotationValue(DataInput input) throws IOException {
        byte type = input.readByte();
        switch (type) {
            case 11: {
                return new AnnotationValue(this.readAnnotation(input));
            }
            case 0: {
                return new AnnotationValue(input.readBoolean());
            }
            case 1: {
                return new AnnotationValue(input.readByte());
            }
            case 8: {
                return new AnnotationValue(ValueType.parse(this.symbolTable.at(input.readInt())));
            }
            case 6: {
                return new AnnotationValue(input.readDouble());
            }
            case 10: {
                String className = this.symbolTable.at(input.readInt());
                String fieldName = this.symbolTable.at(input.readInt());
                return new AnnotationValue(new FieldReference(className, fieldName));
            }
            case 5: {
                return new AnnotationValue(input.readFloat());
            }
            case 3: {
                return new AnnotationValue(input.readInt());
            }
            case 9: {
                ArrayList<AnnotationValue> list = new ArrayList<AnnotationValue>();
                int sz = input.readShort();
                for (int i = 0; i < sz; ++i) {
                    list.add(this.readAnnotationValue(input));
                }
                return new AnnotationValue(list);
            }
            case 4: {
                return new AnnotationValue(input.readLong());
            }
            case 2: {
                return new AnnotationValue(input.readShort());
            }
            case 7: {
                return new AnnotationValue(input.readUTF());
            }
        }
        throw new RuntimeException("Unexpected annotation value type: " + type);
    }

    private int packModifiers(Set<ElementModifier> modifiers) {
        int result = 0;
        for (ElementModifier modifier : modifiers) {
            result |= 1 << modifier.ordinal();
        }
        return result;
    }

    private Set<ElementModifier> unpackModifiers(int packed) {
        EnumSet<ElementModifier> modifiers = EnumSet.noneOf(ElementModifier.class);
        while (packed != 0) {
            int n = Integer.numberOfTrailingZeros(packed);
            packed ^= 1 << n;
            modifiers.add(elementModifiers[n]);
        }
        return modifiers;
    }

    private static class Item {
        ClassHolder cls;

        private Item() {
        }
    }
}

