/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphUtils;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.Phi;
import org.teavm.model.PrimitiveType;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.ProgramUtils;
import org.teavm.parsing.VariableDebugInformation;

public class SSATransformer {
    private Program program;
    private Graph cfg;
    private DominatorTree domTree;
    private int[][] domFrontiers;
    private Variable[] variableMap;
    private BasicBlock currentBlock;
    private Phi[][] phiMap;
    private int[][] phiIndexMap;
    private ValueType[] arguments;
    private VariableDebugInformation variableDebugInfo;
    private Map<Integer, String> variableDebugMap = new HashMap<Integer, String>();
    private InstructionVisitor consumer = new InstructionVisitor(){

        @Override
        public void visit(EmptyInstruction insn) {
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(NullConstantInstruction insn) {
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(LongConstantInstruction insn) {
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(BinaryInstruction insn) {
            insn.setFirstOperand(SSATransformer.this.use(insn.getFirstOperand()));
            insn.setSecondOperand(SSATransformer.this.use(insn.getSecondOperand()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(NegateInstruction insn) {
            insn.setOperand(SSATransformer.this.use(insn.getOperand()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(AssignInstruction insn) {
            insn.setAssignee(SSATransformer.this.use(insn.getAssignee()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(BranchingInstruction insn) {
            insn.setOperand(SSATransformer.this.use(insn.getOperand()));
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
            insn.setFirstOperand(SSATransformer.this.use(insn.getFirstOperand()));
            insn.setSecondOperand(SSATransformer.this.use(insn.getSecondOperand()));
        }

        @Override
        public void visit(JumpInstruction insn) {
        }

        @Override
        public void visit(SwitchInstruction insn) {
            insn.setCondition(SSATransformer.this.use(insn.getCondition()));
        }

        @Override
        public void visit(ExitInstruction insn) {
            if (insn.getValueToReturn() != null) {
                insn.setValueToReturn(SSATransformer.this.use(insn.getValueToReturn()));
            }
        }

        @Override
        public void visit(RaiseInstruction insn) {
            insn.setException(SSATransformer.this.use(insn.getException()));
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            insn.setSize(SSATransformer.this.use(insn.getSize()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(ConstructInstruction insn) {
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            List<Variable> dimensions = insn.getDimensions();
            for (int i = 0; i < dimensions.size(); ++i) {
                dimensions.set(i, SSATransformer.this.use(dimensions.get(i)));
            }
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            if (insn.getInstance() != null) {
                insn.setInstance(SSATransformer.this.use(insn.getInstance()));
            }
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            if (insn.getInstance() != null) {
                insn.setInstance(SSATransformer.this.use(insn.getInstance()));
            }
            insn.setValue(SSATransformer.this.use(insn.getValue()));
        }

        @Override
        public void visit(GetElementInstruction insn) {
            insn.setArray(SSATransformer.this.use(insn.getArray()));
            insn.setIndex(SSATransformer.this.use(insn.getIndex()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(PutElementInstruction insn) {
            insn.setArray(SSATransformer.this.use(insn.getArray()));
            insn.setIndex(SSATransformer.this.use(insn.getIndex()));
            insn.setValue(SSATransformer.this.use(insn.getValue()));
        }

        @Override
        public void visit(InvokeInstruction insn) {
            List<Variable> args = insn.getArguments();
            for (int i = 0; i < args.size(); ++i) {
                args.set(i, SSATransformer.this.use(args.get(i)));
            }
            if (insn.getInstance() != null) {
                insn.setInstance(SSATransformer.this.use(insn.getInstance()));
            }
            if (insn.getReceiver() != null) {
                insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
            }
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            insn.setValue(SSATransformer.this.use(insn.getValue()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(CastInstruction insn) {
            insn.setValue(SSATransformer.this.use(insn.getValue()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(CastNumberInstruction insn) {
            insn.setValue(SSATransformer.this.use(insn.getValue()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
            insn.setValue(SSATransformer.this.use(insn.getValue()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
            insn.setArray(SSATransformer.this.use(insn.getArray()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            insn.setArray(SSATransformer.this.use(insn.getArray()));
            for (String debugName : insn.getArray().getDebugNames()) {
                SSATransformer.this.variableDebugMap.put(insn.getReceiver().getIndex(), debugName + ".data");
            }
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            insn.setArray(SSATransformer.this.use(insn.getArray()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }

        @Override
        public void visit(InitClassInstruction insn) {
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            insn.setValue(SSATransformer.this.use(insn.getValue()));
            insn.setReceiver(SSATransformer.this.define(insn.getReceiver()));
        }
    };

    public void transformToSSA(Program program, VariableDebugInformation variableDebugInfo, ValueType[] arguments) {
        if (program.basicBlockCount() == 0) {
            return;
        }
        this.program = program;
        this.variableDebugInfo = variableDebugInfo;
        this.arguments = arguments;
        this.variableDebugMap.clear();
        this.cfg = ProgramUtils.buildControlFlowGraphWithoutTryCatch(program);
        this.domTree = GraphUtils.buildDominatorTree(this.cfg);
        this.domFrontiers = new int[this.cfg.size()][];
        this.variableMap = new Variable[program.variableCount()];
        this.phiMap = new Phi[program.basicBlockCount()][];
        this.phiIndexMap = new int[program.basicBlockCount()][];
        for (int i = 0; i < this.phiMap.length; ++i) {
            this.phiMap[i] = new Phi[program.variableCount()];
            this.phiIndexMap[i] = new int[program.variableCount()];
        }
        this.applySignature();
        this.domFrontiers = GraphUtils.findDominanceFrontiers(this.cfg, this.domTree);
        this.estimatePhis();
        this.renameVariables();
    }

    private void applySignature() {
        if (this.program.variableCount() == 0) {
            return;
        }
        int index = 0;
        this.variableMap[index] = this.program.variableAt(index);
        ++index;
        for (int i = 0; i < this.arguments.length; ++i) {
            PrimitiveType kind;
            this.variableMap[index] = this.program.variableAt(i + 1);
            ++index;
            ValueType arg = this.arguments[i];
            if (!(arg instanceof ValueType.Primitive) || (kind = ((ValueType.Primitive)arg).getKind()) != PrimitiveType.LONG && kind != PrimitiveType.DOUBLE) continue;
            this.variableMap[index] = this.variableMap[index - 1];
            ++index;
        }
        this.arguments = null;
    }

    private void estimatePhis() {
        DefinitionExtractor definitionExtractor = new DefinitionExtractor();
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            this.currentBlock = this.program.basicBlockAt(i);
            for (Instruction insn : this.currentBlock.getInstructions()) {
                insn.acceptVisitor(definitionExtractor);
                for (Variable var : definitionExtractor.getDefinedVariables()) {
                    this.markAssignment(var);
                }
            }
        }
    }

    private void renameVariables() {
        int i;
        DominatorTree domTree = GraphUtils.buildDominatorTree(ProgramUtils.buildControlFlowGraph(this.program));
        Graph domGraph = GraphUtils.buildDominatorGraph(domTree, this.program.basicBlockCount());
        Task[] stack = new Task[this.cfg.size() * 2];
        int head = 0;
        for (int i2 = 0; i2 < this.program.basicBlockCount(); ++i2) {
            if (domGraph.incomingEdgesCount(i2) != 0) continue;
            Task task = new Task();
            task.block = this.program.basicBlockAt(i2);
            task.variables = Arrays.copyOf(this.variableMap, this.variableMap.length);
            stack[head++] = task;
        }
        ArrayList caughtBlocks = new ArrayList();
        ArrayList specialPhis = new ArrayList();
        for (i = 0; i < this.program.basicBlockCount(); ++i) {
            caughtBlocks.add(new ArrayList());
            specialPhis.add(new ArrayList());
        }
        for (i = 0; i < this.program.basicBlockCount(); ++i) {
            for (TryCatchBlock tryCatch : this.program.basicBlockAt(i).getTryCatchBlocks()) {
                ((List)caughtBlocks.get(tryCatch.getHandler().getIndex())).add(tryCatch);
            }
        }
        boolean[] processed = new boolean[this.program.basicBlockCount()];
        while (head > 0) {
            int i3;
            Task task = stack[--head];
            this.currentBlock = task.block;
            if (processed[this.currentBlock.getIndex()]) continue;
            processed[this.currentBlock.getIndex()] = true;
            this.variableMap = Arrays.copyOf(task.variables, task.variables.length);
            for (Phi phi : this.currentBlock.getPhis()) {
                Variable var = this.program.createVariable();
                var.getDebugNames().addAll(phi.getReceiver().getDebugNames());
                this.variableMap[phi.getReceiver().getIndex()] = var;
                phi.setReceiver(var);
            }
            if (!((List)caughtBlocks.get(this.currentBlock.getIndex())).isEmpty()) {
                Phi phi = new Phi();
                phi.setReceiver(this.program.createVariable());
                for (TryCatchBlock tryCatch : (List)caughtBlocks.get(this.currentBlock.getIndex())) {
                    this.variableMap[tryCatch.getExceptionVariable().getIndex()] = phi.getReceiver();
                    Set<String> debugNames = tryCatch.getExceptionVariable().getDebugNames();
                    tryCatch.setExceptionVariable(this.program.createVariable());
                    tryCatch.getExceptionVariable().getDebugNames().addAll(debugNames);
                    Incoming incoming = new Incoming();
                    incoming.setSource(tryCatch.getProtectedBlock());
                    incoming.setValue(tryCatch.getExceptionVariable());
                    phi.getIncomings().add(incoming);
                }
                ((List)specialPhis.get(this.currentBlock.getIndex())).add(phi);
            }
            for (Instruction insn : this.currentBlock.getInstructions()) {
                this.variableDebugMap.putAll(this.variableDebugInfo.getDebugNames(insn));
                insn.acceptVisitor(this.consumer);
            }
            int[] successors = domGraph.outgoingEdges(this.currentBlock.getIndex());
            for (i3 = 0; i3 < successors.length; ++i3) {
                Task next = new Task();
                next.variables = Arrays.copyOf(this.variableMap, this.variableMap.length);
                next.block = this.program.basicBlockAt(successors[i3]);
                stack[head++] = next;
            }
            successors = this.cfg.outgoingEdges(this.currentBlock.getIndex());
            for (i3 = 0; i3 < successors.length; ++i3) {
                int successor = successors[i3];
                int[] phiIndexes = this.phiIndexMap[successor];
                List<Phi> phis = this.program.basicBlockAt(successor).getPhis();
                for (int j = 0; j < phis.size(); ++j) {
                    Phi phi = phis.get(j);
                    Variable var = this.variableMap[phiIndexes[j]];
                    if (var == null) continue;
                    Incoming incoming = new Incoming();
                    incoming.setSource(this.currentBlock);
                    incoming.setValue(var);
                    phi.getIncomings().add(incoming);
                    phi.getReceiver().getDebugNames().addAll(var.getDebugNames());
                }
            }
        }
        for (int i4 = 0; i4 < specialPhis.size(); ++i4) {
            this.program.basicBlockAt(i4).getPhis().addAll((Collection)specialPhis.get(i4));
        }
    }

    private void markAssignment(Variable var) {
        BasicBlock[] worklist = new BasicBlock[this.program.basicBlockCount() * 4];
        int head = 0;
        worklist[head++] = this.currentBlock;
        while (head > 0) {
            BasicBlock block;
            int[] frontiers;
            if ((frontiers = this.domFrontiers[(block = worklist[--head]).getIndex()]) == null) continue;
            for (int frontier : frontiers) {
                BasicBlock frontierBlock = this.program.basicBlockAt(frontier);
                frontierBlock.getPhis();
                Phi phi = this.phiMap[frontier][var.getIndex()];
                if (phi != null) continue;
                phi = new Phi();
                phi.setReceiver(var);
                this.phiIndexMap[frontier][frontierBlock.getPhis().size()] = var.getIndex();
                frontierBlock.getPhis().add(phi);
                this.phiMap[frontier][var.getIndex()] = phi;
                worklist[head++] = frontierBlock;
            }
        }
    }

    private Variable define(Variable var) {
        Variable result;
        this.variableMap[var.getIndex()] = result = this.program.createVariable();
        return result;
    }

    private Variable use(Variable var) {
        Variable mappedVar = this.variableMap[var.getIndex()];
        if (mappedVar == null) {
            throw new AssertionError();
        }
        String debugName = this.variableDebugMap.get(var.getIndex());
        if (debugName != null) {
            mappedVar.getDebugNames().add(debugName);
        }
        return mappedVar;
    }

    static class Task {
        Variable[] variables;
        BasicBlock block;

        Task() {
        }
    }
}

