/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.common.Graph;
import org.teavm.common.GraphIndexer;
import org.teavm.common.Loop;
import org.teavm.common.LoopGraph;
import org.teavm.common.RangeTree;
import org.teavm.javascript.DecompilationException;
import org.teavm.javascript.Optimizer;
import org.teavm.javascript.RegularMethodNodeCache;
import org.teavm.javascript.StatementGenerator;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.ClassNode;
import org.teavm.javascript.ast.FieldNode;
import org.teavm.javascript.ast.IdentifiedStatement;
import org.teavm.javascript.ast.MethodNode;
import org.teavm.javascript.ast.NativeMethodNode;
import org.teavm.javascript.ast.NodeLocation;
import org.teavm.javascript.ast.NodeModifier;
import org.teavm.javascript.ast.RegularMethodNode;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.WhileStatement;
import org.teavm.javascript.ni.GeneratedBy;
import org.teavm.javascript.ni.Generator;
import org.teavm.javascript.ni.InjectedBy;
import org.teavm.javascript.ni.PreserveOriginalName;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.Instruction;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.util.ProgramUtils;

public class Decompiler {
    private ClassHolderSource classSource;
    private ClassLoader classLoader;
    private Graph graph;
    private LoopGraph loopGraph;
    private GraphIndexer indexer;
    private int[] loops;
    private int[] loopSuccessors;
    private Block[] blockMap;
    private int lastBlockId;
    private RangeTree codeTree;
    private RangeTree.Node currentNode;
    private RangeTree.Node parentNode;
    private Map<MethodReference, Generator> generators = new HashMap<MethodReference, Generator>();
    private Set<MethodReference> methodsToPass = new HashSet<MethodReference>();
    private RegularMethodNodeCache regularMethodCache;

    public Decompiler(ClassHolderSource classSource, ClassLoader classLoader) {
        this.classSource = classSource;
        this.classLoader = classLoader;
    }

    public RegularMethodNodeCache getRegularMethodCache() {
        return this.regularMethodCache;
    }

    public void setRegularMethodCache(RegularMethodNodeCache regularMethodCache) {
        this.regularMethodCache = regularMethodCache;
    }

    public int getGraphSize() {
        return this.graph.size();
    }

    public List<ClassNode> decompile(Collection<String> classNames) {
        ArrayList<String> sequence = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        for (String className : classNames) {
            this.orderClasses(className, visited, sequence);
        }
        ArrayList<ClassNode> result = new ArrayList<ClassNode>();
        for (int i = 0; i < sequence.size(); ++i) {
            String className = (String)sequence.get(i);
            result.add(this.decompile(this.classSource.get(className)));
        }
        return result;
    }

    public List<String> getClassOrdering(Collection<String> classNames) {
        ArrayList<String> sequence = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        for (String className : classNames) {
            this.orderClasses(className, visited, sequence);
        }
        return sequence;
    }

    public void addGenerator(MethodReference method, Generator generator) {
        this.generators.put(method, generator);
    }

    public void addMethodToPass(MethodReference method) {
        this.methodsToPass.add(method);
    }

    private void orderClasses(String className, Set<String> visited, List<String> order) {
        if (!visited.add(className)) {
            return;
        }
        ClassHolder cls = this.classSource.get(className);
        if (cls == null) {
            throw new IllegalArgumentException("Class not found: " + className);
        }
        if (cls.getParent() != null) {
            this.orderClasses(cls.getParent(), visited, order);
        }
        for (String iface : cls.getInterfaces()) {
            this.orderClasses(iface, visited, order);
        }
        order.add(className);
    }

    public ClassNode decompile(ClassHolder cls) {
        ClassNode clsNode = new ClassNode(cls.getName(), cls.getParent());
        for (FieldHolder field : cls.getFields()) {
            FieldNode fieldNode = new FieldNode(field.getName(), field.getType());
            fieldNode.getModifiers().addAll(this.mapModifiers(field.getModifiers()));
            fieldNode.setInitialValue(field.getInitialValue());
            clsNode.getFields().add(fieldNode);
        }
        for (MethodHolder method : cls.getMethods()) {
            if (method.getModifiers().contains((Object)ElementModifier.ABSTRACT) || method.getAnnotations().get(InjectedBy.class.getName()) != null || this.methodsToPass.contains(method.getReference())) continue;
            MethodNode methodNode = this.decompile(method);
            clsNode.getMethods().add(methodNode);
            if (method.getAnnotations().get(PreserveOriginalName.class.getName()) == null) continue;
            methodNode.setOriginalNamePreserved(true);
        }
        clsNode.getInterfaces().addAll(cls.getInterfaces());
        clsNode.getModifiers().addAll(this.mapModifiers(cls.getModifiers()));
        return clsNode;
    }

    public MethodNode decompile(MethodHolder method) {
        return method.getModifiers().contains((Object)ElementModifier.NATIVE) ? this.decompileNative(method) : this.decompileRegular(method);
    }

    public NativeMethodNode decompileNative(MethodHolder method) {
        Generator generator = this.generators.get(method.getReference());
        if (generator == null) {
            AnnotationHolder annotHolder = method.getAnnotations().get(GeneratedBy.class.getName());
            if (annotHolder == null) {
                throw new DecompilationException("Method " + method.getOwnerName() + "." + method.getDescriptor() + " is native, but no " + GeneratedBy.class.getName() + " annotation found");
            }
            ValueType annotValue = annotHolder.getValues().get("value").getJavaClass();
            String generatorClassName = ((ValueType.Object)annotValue).getClassName();
            try {
                Class<?> generatorClass = Class.forName(generatorClassName, true, this.classLoader);
                generator = (Generator)generatorClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new DecompilationException("Error instantiating generator " + generatorClassName + " for native method " + method.getOwnerName() + "." + method.getDescriptor());
            }
        }
        NativeMethodNode methodNode = new NativeMethodNode(new MethodReference(method.getOwnerName(), method.getDescriptor()));
        methodNode.getModifiers().addAll(this.mapModifiers(method.getModifiers()));
        methodNode.setGenerator(generator);
        return methodNode;
    }

    public RegularMethodNode decompileRegular(MethodHolder method) {
        if (this.regularMethodCache == null) {
            return this.decompileRegularCacheMiss(method);
        }
        RegularMethodNode node = this.regularMethodCache.get(method.getReference());
        if (node == null) {
            node = this.decompileRegularCacheMiss(method);
            this.regularMethodCache.store(method.getReference(), node);
        }
        return node;
    }

    public RegularMethodNode decompileRegularCacheMiss(MethodHolder method) {
        this.lastBlockId = 1;
        this.graph = ProgramUtils.buildControlFlowGraph(method.getProgram());
        this.indexer = new GraphIndexer(this.graph);
        this.graph = this.indexer.getGraph();
        this.loopGraph = new LoopGraph(this.graph);
        this.unflatCode();
        Program program = method.getProgram();
        this.blockMap = new Block[program.basicBlockCount() * 2 + 1];
        ArrayDeque<Block> stack = new ArrayDeque<Block>();
        BlockStatement rootStmt = new BlockStatement();
        rootStmt.setId("root");
        stack.push(new Block(rootStmt, rootStmt.getBody(), -1, -1));
        StatementGenerator generator = new StatementGenerator();
        generator.classSource = this.classSource;
        generator.program = program;
        generator.blockMap = this.blockMap;
        generator.indexer = this.indexer;
        this.parentNode = this.codeTree.getRoot();
        this.currentNode = this.parentNode.getFirstChild();
        for (int i = 0; i < this.graph.size(); ++i) {
            Block block = (Block)stack.peek();
            while (block.end == i) {
                int mappedStart;
                Block oldBlock = block;
                stack.pop();
                block = (Block)stack.peek();
                if (block.start < 0 || this.blockMap[mappedStart = this.indexer.nodeAt(block.start)] != oldBlock) continue;
                this.blockMap[mappedStart] = block;
            }
            while (this.parentNode.getEnd() == i) {
                this.currentNode = this.parentNode.getNext();
                this.parentNode = this.parentNode.getParent();
            }
            for (Block newBlock : this.createBlocks(i)) {
                block.body.add(newBlock.statement);
                stack.push(newBlock);
                block = newBlock;
            }
            int node = i < this.indexer.size() ? this.indexer.nodeAt(i) : -1;
            int next = i + 1;
            int head = this.loops[i];
            if (head != -1 && this.loopSuccessors[head] == next) {
                next = head;
            }
            if (node < 0) continue;
            generator.currentBlock = program.basicBlockAt(node);
            int tmp = this.indexer.nodeAt(next);
            generator.nextBlock = next < this.indexer.size() ? program.basicBlockAt(tmp) : null;
            generator.statements.clear();
            InstructionLocation lastLocation = null;
            NodeLocation nodeLocation = null;
            for (Instruction insn : generator.currentBlock.getInstructions()) {
                if (insn.getLocation() != null && lastLocation != insn.getLocation()) {
                    lastLocation = insn.getLocation();
                    nodeLocation = new NodeLocation(lastLocation.getFileName(), lastLocation.getLine());
                }
                if (insn.getLocation() != null) {
                    generator.setCurrentLocation(nodeLocation);
                }
                insn.acceptVisitor(generator);
            }
            for (TryCatchBlock tryCatch : generator.currentBlock.getTryCatchBlocks()) {
                TryCatchStatement tryCatchStmt = new TryCatchStatement();
                tryCatchStmt.setExceptionType(tryCatch.getExceptionType());
                tryCatchStmt.setExceptionVariable(tryCatch.getExceptionVariable().getIndex());
                tryCatchStmt.getProtectedBody().addAll(generator.statements);
                generator.statements.clear();
                generator.statements.add(tryCatchStmt);
                Statement handlerStmt = generator.generateJumpStatement(tryCatch.getHandler());
                if (handlerStmt == null) continue;
                tryCatchStmt.getHandler().add(handlerStmt);
            }
            block.body.addAll(generator.statements);
        }
        SequentialStatement result = new SequentialStatement();
        result.getSequence().addAll(rootStmt.getBody());
        MethodReference reference = new MethodReference(method.getOwnerName(), method.getDescriptor());
        RegularMethodNode methodNode = new RegularMethodNode(reference);
        methodNode.getModifiers().addAll(this.mapModifiers(method.getModifiers()));
        methodNode.setBody(result);
        for (int i = 0; i < program.variableCount(); ++i) {
            methodNode.getVariables().add(program.variableAt(i).getRegister());
        }
        Optimizer optimizer = new Optimizer();
        optimizer.optimize(methodNode, method.getProgram());
        methodNode.getModifiers().addAll(this.mapModifiers(method.getModifiers()));
        int paramCount = method.getSignature().length;
        for (int i = 0; i < paramCount; ++i) {
            Variable var = program.variableAt(i);
            methodNode.getParameterDebugNames().add(new HashSet<String>(var.getDebugNames()));
        }
        return methodNode;
    }

    private Set<NodeModifier> mapModifiers(Set<ElementModifier> modifiers) {
        EnumSet<NodeModifier> result = EnumSet.noneOf(NodeModifier.class);
        if (modifiers.contains((Object)ElementModifier.STATIC)) {
            result.add(NodeModifier.STATIC);
        }
        if (modifiers.contains((Object)ElementModifier.INTERFACE)) {
            result.add(NodeModifier.INTERFACE);
        }
        if (modifiers.contains((Object)ElementModifier.ENUM)) {
            result.add(NodeModifier.ENUM);
        }
        return result;
    }

    private List<Block> createBlocks(int start) {
        ArrayList<Block> result = new ArrayList<Block>();
        while (this.currentNode != null && this.currentNode.getStart() == start) {
            Block block;
            IdentifiedStatement statement;
            boolean loop = false;
            if (this.loopSuccessors[start] == this.currentNode.getEnd() || this.isSingleBlockLoop(start)) {
                WhileStatement whileStatement;
                statement = whileStatement = new WhileStatement();
                block = new Block(statement, whileStatement.getBody(), start, this.currentNode.getEnd());
                loop = true;
            } else {
                BlockStatement blockStatement = new BlockStatement();
                statement = blockStatement;
                block = new Block(statement, blockStatement.getBody(), start, this.currentNode.getEnd());
            }
            result.add(block);
            int mappedIndex = this.indexer.nodeAt(this.currentNode.getEnd());
            if (!(mappedIndex < 0 || this.blockMap[mappedIndex] != null && this.blockMap[mappedIndex].statement instanceof WhileStatement)) {
                this.blockMap[mappedIndex] = block;
            }
            if (loop) {
                this.blockMap[this.indexer.nodeAt((int)start)] = block;
            }
            this.parentNode = this.currentNode;
            this.currentNode = this.currentNode.getFirstChild();
        }
        for (Block block : result) {
            block.statement.setId("block" + this.lastBlockId++);
        }
        return result;
    }

    private boolean isSingleBlockLoop(int index) {
        for (int succ : this.graph.outgoingEdges(index)) {
            if (succ != index) continue;
            return true;
        }
        return false;
    }

    private void unflatCode() {
        int node;
        Graph graph = this.graph;
        int sz = graph.size();
        int[] loopSuccessors = new int[sz];
        Arrays.fill(loopSuccessors, sz + 1);
        for (int node2 = 0; node2 < sz; ++node2) {
            for (Loop loop = this.loopGraph.loopAt(node2); loop != null; loop = loop.getParent()) {
                loopSuccessors[loop.getHead()] = node2 + 1;
            }
        }
        int[] loops = new int[sz];
        Arrays.fill(loops, -1);
        for (int head = 0; head < sz; ++head) {
            int end = loopSuccessors[head];
            if (end > sz) continue;
            for (int node3 = head + 1; node3 < end; ++node3) {
                loops[node3] = head;
            }
        }
        ArrayList<RangeTree.Range> ranges = new ArrayList<RangeTree.Range>();
        for (node = 0; node < sz; ++node) {
            if (loopSuccessors[node] <= sz) {
                ranges.add(new RangeTree.Range(node, loopSuccessors[node]));
            }
            int start = sz;
            for (int prev : graph.incomingEdges(node)) {
                start = Math.min(start, prev);
            }
            if (start >= node - 1) continue;
            ranges.add(new RangeTree.Range(start, node));
        }
        for (node = 0; node < sz; ++node) {
            if (!this.isSingleBlockLoop(node)) continue;
            ranges.add(new RangeTree.Range(node, node + 1));
        }
        this.codeTree = new RangeTree(sz + 1, ranges);
        this.loopSuccessors = loopSuccessors;
        this.loops = loops;
    }

    static class Block {
        public final IdentifiedStatement statement;
        public final List<Statement> body;
        public final int end;
        public final int start;

        public Block(IdentifiedStatement statement, List<Statement> body, int start, int end) {
            this.statement = statement;
            this.body = body;
            this.start = start;
            this.end = end;
        }
    }
}

