/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.dependency.DependencyAgentType;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyNodeToNodeTransition;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.DependencyTypeFilter;
import org.teavm.dependency.ValueDependencyInfo;

public class DependencyNode
implements ValueDependencyInfo {
    private DependencyChecker dependencyChecker;
    private Set<DependencyConsumer> followers = new HashSet<DependencyConsumer>();
    private BitSet types = new BitSet();
    private Map<DependencyNode, DependencyNodeToNodeTransition> transitions = new HashMap<DependencyNode, DependencyNodeToNodeTransition>();
    private volatile String tag;
    private DependencyNode arrayItemNode;
    private int degree;

    DependencyNode(DependencyChecker dependencyChecker) {
        this(dependencyChecker, 0);
    }

    DependencyNode(DependencyChecker dependencyChecker, int degree) {
        this.dependencyChecker = dependencyChecker;
        this.degree = degree;
    }

    public void propagate(DependencyAgentType agentType) {
        if (!(agentType instanceof DependencyType)) {
            throw new IllegalArgumentException("The given type does not belong to the same dependency checker");
        }
        DependencyType type = (DependencyType)agentType;
        if (type.getDependencyChecker() != this.dependencyChecker) {
            throw new IllegalArgumentException("The given type does not belong to the same dependency checker");
        }
        if (this.degree > 2) {
            return;
        }
        if (!this.types.get(type.index)) {
            this.types.set(type.index);
            if (DependencyChecker.shouldLog) {
                System.out.println(this.tag + " -> " + type.getName());
            }
            for (DependencyConsumer consumer : this.followers.toArray(new DependencyConsumer[this.followers.size()])) {
                this.dependencyChecker.schedulePropagation(consumer, type);
            }
        }
    }

    public void propagate(DependencyAgentType[] agentTypes) {
        int i;
        DependencyType[] types = new DependencyType[agentTypes.length];
        int j = 0;
        for (i = 0; i < agentTypes.length; ++i) {
            DependencyAgentType agentType = agentTypes[i];
            if (!(agentType instanceof DependencyType)) {
                throw new IllegalArgumentException("The given type does not belong to the same dependency checker");
            }
            DependencyType type = (DependencyType)agentType;
            if (type.getDependencyChecker() != this.dependencyChecker) {
                throw new IllegalArgumentException("The given type does not belong to the same dependency checker");
            }
            if (this.types.get(type.index)) continue;
            types[j++] = type;
        }
        for (i = 0; i < j; ++i) {
            this.types.set(types[i].index);
            if (!DependencyChecker.shouldLog) continue;
            System.out.println(this.tag + " -> " + types[i].getName());
        }
        for (DependencyConsumer consumer : this.followers.toArray(new DependencyConsumer[this.followers.size()])) {
            this.dependencyChecker.schedulePropagation(consumer, Arrays.copyOf(types, j));
        }
    }

    public void addConsumer(DependencyConsumer consumer) {
        if (this.followers.add(consumer)) {
            ArrayList<DependencyType> types = new ArrayList<DependencyType>();
            int index = this.types.nextSetBit(0);
            while (index >= 0) {
                types.add(this.dependencyChecker.types.get(index));
                index = this.types.nextSetBit(index + 1);
            }
            this.dependencyChecker.schedulePropagation(consumer, types.toArray(new DependencyType[types.size()]));
        }
    }

    public void connect(DependencyNode node, DependencyTypeFilter filter) {
        DependencyNodeToNodeTransition transition = new DependencyNodeToNodeTransition(this, node, filter);
        if (!this.transitions.containsKey(node)) {
            this.transitions.put(node, transition);
            if (DependencyChecker.shouldLog) {
                System.out.println("Connecting " + this.tag + " to " + node.tag);
            }
            this.addConsumer(transition);
        }
    }

    public void connect(DependencyNode node) {
        this.connect(node, null);
    }

    @Override
    public DependencyNode getArrayItem() {
        if (this.arrayItemNode == null) {
            this.arrayItemNode = new DependencyNode(this.dependencyChecker, this.degree + 1);
            if (DependencyChecker.shouldLog) {
                this.arrayItemNode.tag = this.tag + "[";
            }
        }
        return this.arrayItemNode;
    }

    @Override
    public boolean hasArrayType() {
        return this.arrayItemNode != null && this.arrayItemNode.types.isEmpty();
    }

    public boolean hasType(DependencyAgentType type) {
        if (!(type instanceof DependencyType)) {
            return false;
        }
        DependencyType typeImpl = (DependencyType)type;
        return typeImpl.getDependencyChecker() == this.dependencyChecker && this.types.get(typeImpl.index);
    }

    @Override
    public boolean hasType(String type) {
        return this.hasType(this.dependencyChecker.getType(type));
    }

    @Override
    public String[] getTypes() {
        ArrayList<String> result = new ArrayList<String>();
        int index = this.types.nextSetBit(0);
        while (index >= 0) {
            result.add(this.dependencyChecker.types.get(index).getName());
            index = this.types.nextSetBit(index + 1);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

