/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teavm.dependency.DependencyAgentType;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.DependencyTypeFilter;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReference;
import org.teavm.model.IncomingReader;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.PhiReader;
import org.teavm.model.ProgramReader;
import org.teavm.model.TryCatchBlockReader;
import org.teavm.model.ValueType;
import org.teavm.model.VariableReader;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.BinaryBranchingCondition;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.CastIntegerDirection;
import org.teavm.model.instructions.InstructionReader;
import org.teavm.model.instructions.IntegerSubtype;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.instructions.SwitchTableEntryReader;
import org.teavm.model.util.ListingBuilder;

class DependencyGraphBuilder {
    private DependencyChecker dependencyChecker;
    private DependencyNode[] nodes;
    private DependencyNode resultNode;
    private ProgramReader program;
    private DependencyStack callerStack;
    private ExceptionConsumer currentExceptionConsumer;
    private InstructionReader reader = new InstructionReader(){

        @Override
        public void location(InstructionLocation location) {
            DependencyGraphBuilder.this.callerStack = new DependencyStack(DependencyGraphBuilder.this.callerStack.getMethod(), location, DependencyGraphBuilder.this.callerStack.getCause());
        }

        @Override
        public void nop() {
        }

        @Override
        public void classConstant(VariableReader receiver, ValueType cst) {
            DependencyGraphBuilder.this.nodes[receiver.getIndex()].propagate(DependencyGraphBuilder.this.dependencyChecker.getType("java.lang.Class"));
            while (cst instanceof ValueType.Array) {
                cst = ((ValueType.Array)cst).getItemType();
            }
            if (cst instanceof ValueType.Object) {
                String className = ((ValueType.Object)cst).getClassName();
                DependencyGraphBuilder.this.dependencyChecker.linkClass(className, DependencyGraphBuilder.this.callerStack);
            }
        }

        @Override
        public void nullConstant(VariableReader receiver) {
        }

        @Override
        public void integerConstant(VariableReader receiver, int cst) {
        }

        @Override
        public void longConstant(VariableReader receiver, long cst) {
        }

        @Override
        public void floatConstant(VariableReader receiver, float cst) {
        }

        @Override
        public void doubleConstant(VariableReader receiver, double cst) {
        }

        @Override
        public void stringConstant(VariableReader receiver, String cst) {
            DependencyGraphBuilder.this.nodes[receiver.getIndex()].propagate(DependencyGraphBuilder.this.dependencyChecker.getType("java.lang.String"));
            MethodDependency method = DependencyGraphBuilder.this.dependencyChecker.linkMethod(new MethodReference(String.class, "<init>", char[].class, Void.TYPE), DependencyGraphBuilder.this.callerStack);
            method.use();
        }

        @Override
        public void binary(BinaryOperation op, VariableReader receiver, VariableReader first, VariableReader second, NumericOperandType type) {
        }

        @Override
        public void negate(VariableReader receiver, VariableReader operand, NumericOperandType type) {
        }

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[assignee.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            valueNode.connect(receiverNode);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, ValueType targetType) {
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            if (targetType instanceof ValueType.Object) {
                String targetClsName = ((ValueType.Object)targetType).getClassName();
                final ClassReader targetClass = DependencyGraphBuilder.this.dependencyChecker.getClassSource().get(targetClsName);
                if (targetClass != null) {
                    valueNode.connect(receiverNode, new DependencyTypeFilter(){

                        @Override
                        public boolean match(DependencyAgentType type) {
                            if (targetClass.getName().equals("java.lang.Object")) {
                                return true;
                            }
                            return DependencyGraphBuilder.isAssignableFrom(DependencyGraphBuilder.this.dependencyChecker.getClassSource(), targetClass, type.getName());
                        }
                    });
                    return;
                }
            }
            valueNode.connect(receiverNode);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, NumericOperandType sourceType, NumericOperandType targetType) {
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, IntegerSubtype type, CastIntegerDirection targetType) {
        }

        @Override
        public void jumpIf(BranchingCondition cond, VariableReader operand, BasicBlockReader consequent, BasicBlockReader alternative) {
        }

        @Override
        public void jumpIf(BinaryBranchingCondition cond, VariableReader first, VariableReader second, BasicBlockReader consequent, BasicBlockReader alternative) {
        }

        @Override
        public void jump(BasicBlockReader target) {
        }

        @Override
        public void choose(VariableReader condition, List<? extends SwitchTableEntryReader> table, BasicBlockReader defaultTarget) {
        }

        @Override
        public void exit(VariableReader valueToReturn) {
            if (valueToReturn != null) {
                DependencyGraphBuilder.this.nodes[valueToReturn.getIndex()].connect(DependencyGraphBuilder.this.resultNode);
            }
        }

        @Override
        public void raise(VariableReader exception) {
            DependencyGraphBuilder.this.nodes[exception.getIndex()].addConsumer(DependencyGraphBuilder.this.currentExceptionConsumer);
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, VariableReader size) {
            DependencyGraphBuilder.this.nodes[receiver.getIndex()].propagate(DependencyGraphBuilder.this.dependencyChecker.getType("[" + itemType));
            String className = this.extractClassName(itemType);
            if (className != null) {
                DependencyGraphBuilder.this.dependencyChecker.linkClass(className, DependencyGraphBuilder.this.callerStack);
            }
        }

        private String extractClassName(ValueType itemType) {
            while (itemType instanceof ValueType.Array) {
                itemType = ((ValueType.Array)itemType).getItemType();
            }
            return itemType instanceof ValueType.Object ? ((ValueType.Object)itemType).getClassName() : null;
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, List<? extends VariableReader> dimensions) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < dimensions.size(); ++i) {
                sb.append('[');
            }
            sb.append(itemType);
            DependencyGraphBuilder.this.nodes[receiver.getIndex()].propagate(DependencyGraphBuilder.this.dependencyChecker.getType(sb.toString()));
            String className = this.extractClassName(itemType);
            if (className != null) {
                DependencyGraphBuilder.this.dependencyChecker.linkClass(className, DependencyGraphBuilder.this.callerStack);
            }
        }

        @Override
        public void create(VariableReader receiver, String type) {
            DependencyGraphBuilder.this.nodes[receiver.getIndex()].propagate(DependencyGraphBuilder.this.dependencyChecker.getType(type));
        }

        @Override
        public void getField(VariableReader receiver, VariableReader instance, FieldReference field, ValueType fieldType) {
            FieldDependency fieldDep = DependencyGraphBuilder.this.dependencyChecker.linkField(field, DependencyGraphBuilder.this.callerStack);
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            fieldDep.getValue().connect(receiverNode);
            this.initClass(field.getClassName());
        }

        @Override
        public void putField(VariableReader instance, FieldReference field, VariableReader value) {
            FieldDependency fieldDep = DependencyGraphBuilder.this.dependencyChecker.linkField(field, DependencyGraphBuilder.this.callerStack);
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()];
            valueNode.connect(fieldDep.getValue());
            this.initClass(field.getClassName());
        }

        @Override
        public void arrayLength(VariableReader receiver, VariableReader array) {
        }

        @Override
        public void cloneArray(VariableReader receiver, VariableReader array) {
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            final DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            arrayNode.addConsumer(new DependencyConsumer(){

                @Override
                public void consume(DependencyAgentType type) {
                    receiverNode.propagate(type);
                }
            });
            arrayNode.getArrayItem().connect(receiverNode.getArrayItem());
        }

        @Override
        public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            arrayNode.connect(receiverNode);
        }

        @Override
        public void getElement(VariableReader receiver, VariableReader array, VariableReader index) {
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            arrayNode.getArrayItem().connect(receiverNode);
        }

        @Override
        public void putElement(VariableReader array, VariableReader index, VariableReader value) {
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()];
            DependencyNode arrayNode = DependencyGraphBuilder.this.nodes[array.getIndex()];
            valueNode.connect(arrayNode.getArrayItem());
        }

        @Override
        public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
            if (instance == null) {
                this.invokeSpecial(receiver, null, method, arguments);
            } else {
                switch (type) {
                    case SPECIAL: {
                        this.invokeSpecial(receiver, instance, method, arguments);
                        break;
                    }
                    case VIRTUAL: {
                        this.invokeVirtual(receiver, instance, method, arguments);
                    }
                }
            }
        }

        private void invokeSpecial(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
            MethodDependency methodDep = DependencyGraphBuilder.this.dependencyChecker.linkMethod(method, DependencyGraphBuilder.this.callerStack);
            if (methodDep.isMissing()) {
                return;
            }
            methodDep.use();
            DependencyNode[] targetParams = methodDep.getVariables();
            for (int i = 0; i < arguments.size(); ++i) {
                DependencyGraphBuilder.this.nodes[arguments.get(i).getIndex()].connect(targetParams[i + 1]);
            }
            if (instance != null) {
                DependencyGraphBuilder.this.nodes[instance.getIndex()].connect(targetParams[0]);
            }
            if (methodDep.getResult() != null && receiver != null) {
                methodDep.getResult().connect(DependencyGraphBuilder.this.nodes[receiver.getIndex()]);
            }
            methodDep.getThrown().addConsumer(DependencyGraphBuilder.this.currentExceptionConsumer);
            this.initClass(method.getClassName());
        }

        private void invokeVirtual(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
            MethodDependency methodDep = DependencyGraphBuilder.this.dependencyChecker.linkMethod(method, DependencyGraphBuilder.this.callerStack);
            if (methodDep.isMissing()) {
                return;
            }
            DependencyNode[] actualArgs = new DependencyNode[arguments.size() + 1];
            for (int i = 0; i < arguments.size(); ++i) {
                actualArgs[i + 1] = DependencyGraphBuilder.this.nodes[arguments.get(i).getIndex()];
            }
            actualArgs[0] = DependencyGraphBuilder.this.nodes[instance.getIndex()];
            VirtualCallConsumer listener = new VirtualCallConsumer(DependencyGraphBuilder.this.nodes[instance.getIndex()], DependencyGraphBuilder.this.dependencyChecker.getClassSource().get(methodDep.getMethod().getOwnerName()), method.getDescriptor(), DependencyGraphBuilder.this.dependencyChecker, actualArgs, receiver != null ? DependencyGraphBuilder.this.nodes[receiver.getIndex()] : null, DependencyGraphBuilder.this.callerStack, DependencyGraphBuilder.this.currentExceptionConsumer);
            DependencyGraphBuilder.this.nodes[instance.getIndex()].addConsumer(listener);
        }

        @Override
        public void isInstance(VariableReader receiver, VariableReader value, ValueType type) {
            String className = this.extractClassName(type);
            if (className != null) {
                DependencyGraphBuilder.this.dependencyChecker.linkClass(className, DependencyGraphBuilder.this.callerStack);
            }
        }

        @Override
        public void initClass(String className) {
            DependencyGraphBuilder.this.dependencyChecker.linkClass(className, DependencyGraphBuilder.this.callerStack).initClass(DependencyGraphBuilder.this.callerStack);
        }

        @Override
        public void nullCheck(VariableReader receiver, VariableReader value) {
            DependencyNode valueNode = DependencyGraphBuilder.this.nodes[value.getIndex()];
            DependencyNode receiverNode = DependencyGraphBuilder.this.nodes[receiver.getIndex()];
            valueNode.connect(receiverNode);
            DependencyGraphBuilder.this.dependencyChecker.linkMethod(new MethodReference("java.lang.NullPointerException", "<init>", ValueType.VOID), DependencyGraphBuilder.this.callerStack).use();
            DependencyGraphBuilder.this.currentExceptionConsumer.consume(DependencyGraphBuilder.this.dependencyChecker.getType("java.lang.NullPointerException"));
        }
    };

    public DependencyGraphBuilder(DependencyChecker dependencyChecker) {
        this.dependencyChecker = dependencyChecker;
    }

    public void buildGraph(MethodDependency dep) {
        MethodReader method = dep.getMethod();
        if (method.getProgram() == null || method.getProgram().basicBlockCount() == 0) {
            return;
        }
        this.program = method.getProgram();
        if (DependencyChecker.shouldLog) {
            System.out.println("Method achieved: " + method.getReference());
            System.out.println(new ListingBuilder().buildListing(this.program, "    "));
        }
        this.resultNode = dep.getResult();
        this.nodes = dep.getVariables();
        this.callerStack = new DependencyStack(method.getReference(), dep.getStack());
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            BasicBlockReader block = this.program.basicBlockAt(i);
            this.currentExceptionConsumer = this.createExceptionConsumer(dep, block);
            block.readAllInstructions(this.reader);
            for (PhiReader phiReader : block.readPhis()) {
                for (IncomingReader incomingReader : phiReader.readIncomings()) {
                    this.nodes[incomingReader.getValue().getIndex()].connect(this.nodes[phiReader.getReceiver().getIndex()]);
                }
            }
            for (TryCatchBlockReader tryCatchBlockReader : block.readTryCatchBlocks()) {
                if (tryCatchBlockReader.getExceptionType() == null) continue;
                this.dependencyChecker.linkClass(tryCatchBlockReader.getExceptionType(), this.callerStack);
            }
        }
    }

    private ExceptionConsumer createExceptionConsumer(MethodDependency methodDep, BasicBlockReader block) {
        List<? extends TryCatchBlockReader> tryCatchBlocks = block.readTryCatchBlocks();
        ClassReader[] exceptions = new ClassReader[tryCatchBlocks.size()];
        DependencyNode[] vars = new DependencyNode[tryCatchBlocks.size()];
        for (int i = 0; i < tryCatchBlocks.size(); ++i) {
            TryCatchBlockReader tryCatch = tryCatchBlocks.get(i);
            if (tryCatch.getExceptionType() != null) {
                exceptions[i] = this.dependencyChecker.getClassSource().get(tryCatch.getExceptionType());
            }
            vars[i] = methodDep.getVariable(tryCatch.getExceptionVariable().getIndex());
        }
        return new ExceptionConsumer(this.dependencyChecker, exceptions, vars, methodDep);
    }

    private static boolean isAssignableFrom(ClassReaderSource classSource, ClassReader supertype, String subtypeName) {
        if (supertype.getName().equals(subtypeName)) {
            return true;
        }
        ClassReader subtype = classSource.get(subtypeName);
        if (subtype == null) {
            return false;
        }
        if (subtype.getParent() != null && DependencyGraphBuilder.isAssignableFrom(classSource, supertype, subtype.getParent())) {
            return true;
        }
        for (String iface : subtype.getInterfaces()) {
            if (!DependencyGraphBuilder.isAssignableFrom(classSource, supertype, iface)) continue;
            return true;
        }
        return false;
    }

    private static class VirtualCallConsumer
    implements DependencyConsumer {
        private final DependencyNode node;
        private final ClassReader filterClass;
        private final MethodDescriptor methodDesc;
        private final DependencyChecker checker;
        private final DependencyNode[] parameters;
        private final DependencyNode result;
        private final DependencyStack stack;
        private final Set<MethodReference> knownMethods = new HashSet<MethodReference>();
        private ExceptionConsumer exceptionConsumer;

        public VirtualCallConsumer(DependencyNode node, ClassReader filterClass, MethodDescriptor methodDesc, DependencyChecker checker, DependencyNode[] parameters, DependencyNode result, DependencyStack stack, ExceptionConsumer exceptionConsumer) {
            this.node = node;
            this.filterClass = filterClass;
            this.methodDesc = methodDesc;
            this.checker = checker;
            this.parameters = parameters;
            this.result = result;
            this.stack = stack;
            this.exceptionConsumer = exceptionConsumer;
        }

        @Override
        public void consume(DependencyAgentType type) {
            String className = type.getName();
            if (DependencyChecker.shouldLog) {
                System.out.println("Virtual call of " + this.methodDesc + " detected on " + this.node.getTag() + ". " + "Target class is " + className);
            }
            if (className.startsWith("[")) {
                className = "java.lang.Object";
            }
            if (!DependencyGraphBuilder.isAssignableFrom(this.checker.getClassSource(), this.filterClass, className)) {
                return;
            }
            MethodReference methodRef = new MethodReference(className, this.methodDesc);
            MethodDependency methodDep = this.checker.linkMethod(methodRef, this.stack);
            if (!methodDep.isMissing() && this.knownMethods.add(methodRef)) {
                methodDep.use();
                DependencyNode[] targetParams = methodDep.getVariables();
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.parameters[i].connect(targetParams[i]);
                }
                if (this.result != null && methodDep.getResult() != null) {
                    methodDep.getResult().connect(this.result);
                }
                methodDep.getThrown().addConsumer(this.exceptionConsumer);
            }
        }
    }

    private static class ExceptionConsumer
    implements DependencyConsumer {
        private DependencyChecker checker;
        private ClassReader[] exceptions;
        private DependencyNode[] vars;
        private MethodDependency method;

        public ExceptionConsumer(DependencyChecker checker, ClassReader[] exceptions, DependencyNode[] vars, MethodDependency method) {
            this.checker = checker;
            this.exceptions = exceptions;
            this.vars = vars;
            this.method = method;
        }

        @Override
        public void consume(DependencyAgentType type) {
            for (int i = 0; i < this.exceptions.length; ++i) {
                if (this.exceptions[i] != null && !DependencyGraphBuilder.isAssignableFrom(this.checker.getClassSource(), this.exceptions[i], type.getName())) continue;
                this.vars[i].propagate(type);
                return;
            }
            this.method.getThrown().propagate(type);
        }
    }
}

