/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import org.teavm.common.DominatorTree;
import org.teavm.common.LCATree;

class DefaultDominatorTree
implements DominatorTree {
    private LCATree lcaTree;
    private int[] nodes;
    private int[] unodes;

    public DefaultDominatorTree(int[] dominators, int[] vertices) {
        this.lcaTree = new LCATree(dominators.length + 1);
        this.nodes = new int[dominators.length + 1];
        this.unodes = new int[dominators.length + 1];
        this.nodes[0] = -1;
        for (int i = 0; i < dominators.length; ++i) {
            int node;
            int v = vertices[i];
            if (v < 0) continue;
            int dom = this.nodes[dominators[v] + 1];
            this.nodes[v + 1] = node = this.lcaTree.addNode(dom);
            this.unodes[node] = v;
        }
    }

    @Override
    public boolean directlyDominates(int a, int b) {
        return this.lcaTree.lcaOf(a = this.nodes[a + 1], b = this.nodes[b + 1]) == a;
    }

    @Override
    public int commonDominatorOf(int a, int b) {
        return this.unodes[this.lcaTree.lcaOf(this.nodes[a + 1], this.nodes[b + 1])];
    }

    @Override
    public boolean dominates(int a, int b) {
        return this.lcaTree.lcaOf(a = this.nodes[a + 1], b = this.nodes[b + 1]) == a;
    }

    @Override
    public int immediateDominatorOf(int a) {
        if (a == 0) {
            return -1;
        }
        int result = this.lcaTree.parentOf(this.nodes[a + 1]);
        return result >= 0 ? this.unodes[result] : -1;
    }
}

