/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing.resource;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.teavm.parsing.resource.Resource;
import org.teavm.parsing.resource.ResourceProvider;

public class CompositeResourceProvider
implements ResourceProvider {
    private ResourceProvider[] providers;

    public CompositeResourceProvider(ResourceProvider ... providers) {
        this.providers = providers;
    }

    @Override
    public Iterator<Resource> getResources(String name) {
        final List iterators = Stream.of(this.providers).map(provider -> provider.getResources(name)).collect(Collectors.toList());
        return new Iterator<Resource>(){
            Iterator<Resource> current;
            int currentIndex;

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    return this.following();
                }
                return this.current.hasNext();
            }

            @Override
            public Resource next() {
                if (!(this.current != null && this.current.hasNext() || this.following())) {
                    throw new NoSuchElementException();
                }
                Resource result = this.current.next();
                if (!this.current.hasNext()) {
                    this.current = null;
                }
                return result;
            }

            private boolean following() {
                do {
                    if (this.currentIndex >= iterators.size()) {
                        return false;
                    }
                    this.current = (Iterator)iterators.get(this.currentIndex++);
                } while (!this.current.hasNext());
                return true;
            }
        };
    }

    @Override
    public void close() {
        for (ResourceProvider provider : this.providers) {
            provider.close();
        }
    }
}

