/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.teavm.common.CachedFunction;
import org.teavm.model.ClassHolder;
import org.teavm.model.FieldHolder;
import org.teavm.model.MemberHolder;
import org.teavm.model.MethodHolder;
import org.teavm.model.ReferenceCache;
import org.teavm.parsing.ClassDateProvider;
import org.teavm.parsing.ClassRefsRenamer;
import org.teavm.parsing.resource.Resource;
import org.teavm.parsing.resource.ResourceProvider;
import org.teavm.parsing.substitution.ClassExclusions;
import org.teavm.parsing.substitution.ClassMappings;
import org.teavm.parsing.substitution.OrderedProperties;
import org.teavm.parsing.substitution.PrefixMapping;
import org.teavm.vm.spi.ElementFilter;

public class RenamingResourceMapper
implements Function<String, ClassHolder>,
ClassDateProvider {
    private static final String STRIP_PREFIX_FROM_PREFIX = "stripPrefixFrom";
    private static final String STRIP_PREFIX_FROM_PACKAGE_HIERARCHY_PREFIX = "stripPrefixFromPackageHierarchyClasses";
    private static final String STRIP_PREFIX_FROM_PACKAGE_PREFIX = "stripPrefixFromPackageClasses";
    private static final String MAP_PREFIX = "map";
    private static final String MAP_PACKAGE_HIERARCHY_PREFIX = "mapPackageHierarchy";
    private static final String MAP_PACKAGE_PREFIX = "mapPackage";
    private static final String MAP_CLASS_PREFIX = "mapClass";
    private static final String INCLUDE_PREFIX = "include";
    private static final String INCLUDE_PACKAGE_HIERARCHY_PREFIX = "includePackageHierarchy";
    private static final String INCLUDE_PACKAGE_PREFIX = "includePackage";
    private static final String INCLUDE_CLASS_PREFIX = "includeClass";
    private static final Date VOID_DATE = new Date(0L);
    private Function<String, ClassHolder> innerMapper;
    private ClassRefsRenamer renamer;
    private ResourceProvider resourceProvider;
    private Map<String, Date> modificationDates = new HashMap<String, Date>();
    private List<ElementFilter> elementFilters = new ArrayList<ElementFilter>();
    private ClassMappings classMappings = new ClassMappings();
    private PrefixMapping prefixMapping = new PrefixMapping();
    private ClassMappings packageMappings = new ClassMappings();
    private ClassExclusions classExclusions = new ClassExclusions();
    private ClassMappings reverseClassMappings = new ClassMappings();
    private ClassMappings reversePackageMappings = new ClassMappings();

    public RenamingResourceMapper(ResourceProvider resourceProvider, ReferenceCache referenceCache, Function<String, ClassHolder> provider) {
        this.innerMapper = provider;
        try {
            Iterator<Resource> iter = resourceProvider.getResources("META-INF/teavm.properties");
            while (iter.hasNext()) {
                Resource resource = iter.next();
                OrderedProperties properties = new OrderedProperties();
                try (InputStream input = resource.open();){
                    properties.load(input);
                }
                this.loadProperties(properties);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading resources", e);
        }
        this.renamer = new ClassRefsRenamer(referenceCache, new CachedFunction<String, String>(this::toUnmappedClassName));
        for (ElementFilter elementFilter : ServiceLoader.load(ElementFilter.class)) {
            this.elementFilters.add(elementFilter);
        }
        this.resourceProvider = resourceProvider;
    }

    public RenamingResourceMapper(Properties properties, ReferenceCache referenceCache, Function<String, ClassHolder> innerMapper) {
        this.innerMapper = innerMapper;
        this.loadProperties(properties);
        this.renamer = new ClassRefsRenamer(referenceCache, new CachedFunction<String, String>(this::toUnmappedClassName));
    }

    @Override
    public ClassHolder apply(String name) {
        ClassHolder classHolder;
        ClassHolder cls = null;
        for (String mappedClassName : this.classMappings.apply(name)) {
            if (this.classExclusions.apply(mappedClassName).booleanValue() || (classHolder = this.innerMapper.apply(mappedClassName)) == null) continue;
            cls = this.renamer.rename(classHolder);
            break;
        }
        if (cls == null) {
            for (String mappedClassName : this.packageMappings.apply(name)) {
                if (this.classExclusions.apply(mappedClassName = this.prefixMapping.apply(mappedClassName)).booleanValue() || (classHolder = this.innerMapper.apply(mappedClassName)) == null) continue;
                cls = this.renamer.rename(classHolder);
                break;
            }
        }
        if (cls == null && !this.classExclusions.apply(name).booleanValue()) {
            cls = this.innerMapper.apply(name);
        }
        if (cls != null && !this.elementFilters.isEmpty()) {
            for (ElementFilter filter : this.elementFilters) {
                if (filter.acceptClass(name)) continue;
                return null;
            }
            MethodHolder[] methodHolders = cls.getMethods().toArray(new MethodHolder[0]);
            FieldHolder[] fieldHolders = cls.getFields().toArray(new FieldHolder[0]);
            block3: for (ElementFilter filter : this.elementFilters) {
                for (MethodHolder methodHolder : methodHolders) {
                    if (filter.acceptMethod(methodHolder.getReference())) continue;
                    cls.removeMethod(methodHolder);
                    break;
                }
                for (MemberHolder memberHolder : fieldHolders) {
                    if (filter.acceptField(((FieldHolder)memberHolder).getReference())) continue;
                    cls.removeField((FieldHolder)memberHolder);
                    continue block3;
                }
            }
        }
        return cls;
    }

    @Override
    public Date getModificationDate(String className) {
        Date mdate = this.modificationDates.get(className);
        if (mdate == null) {
            mdate = this.getOriginalModificationDate(this.toUnmappedClassName(className));
            this.modificationDates.put(className, mdate);
        }
        return mdate == VOID_DATE ? null : mdate;
    }

    private String toUnmappedClassName(String name) {
        if (this.classExclusions.apply(name).booleanValue()) {
            return name;
        }
        Iterator<String> iterator = this.reverseClassMappings.apply(name = this.prefixMapping.revert(name)).iterator();
        if (iterator.hasNext()) {
            String originalClassName = iterator.next();
            return originalClassName;
        }
        iterator = this.reversePackageMappings.apply(name).iterator();
        if (iterator.hasNext()) {
            String originalClassName = iterator.next();
            return originalClassName;
        }
        return name;
    }

    private Date getOriginalModificationDate(String className) {
        if (this.resourceProvider == null) {
            return null;
        }
        Resource res = this.resourceProvider.getResource(className.replace('.', '/') + ".class");
        return res == null ? null : res.getModificationDate();
    }

    private void loadProperties(Properties properties) {
        for (String propertyName : properties.stringPropertyNames()) {
            String[] instruction = propertyName.split("\\|", 2);
            switch (instruction[0]) {
                case "stripPrefixFromPackageHierarchyClasses": {
                    this.prefixMapping.setPackageHierarchyClassPrefixRule(instruction[1].split("\\."), properties.getProperty(propertyName));
                    break;
                }
                case "stripPrefixFromPackageClasses": {
                    this.prefixMapping.setPackageClassPrefixRule(instruction[1].split("\\."), properties.getProperty(propertyName));
                    break;
                }
                case "mapPackageHierarchy": {
                    this.packageMappings.addPackageHierarchyMappingRule(properties.getProperty(propertyName).split("\\."), instruction[1]);
                    this.reversePackageMappings.addPackageHierarchyMappingRule(instruction[1].split("\\."), properties.getProperty(propertyName));
                    break;
                }
                case "mapPackage": {
                    this.packageMappings.addPackageMappingRule(properties.getProperty(propertyName).split("\\."), instruction[1]);
                    this.reversePackageMappings.addPackageMappingRule(instruction[1].split("\\."), properties.getProperty(propertyName));
                    break;
                }
                case "mapClass": {
                    this.classMappings.addClassMappingRule(properties.getProperty(propertyName).split("\\."), instruction[1]);
                    this.reverseClassMappings.addClassMappingRule(instruction[1].split("\\."), properties.getProperty(propertyName));
                    break;
                }
                case "includePackageHierarchy": {
                    this.classExclusions.setPackageHierarchyExclusion(instruction[1].split("\\."), !Boolean.parseBoolean(properties.getProperty(propertyName)));
                    break;
                }
                case "includePackage": {
                    this.classExclusions.setPackageExclusion(instruction[1].split("\\."), !Boolean.parseBoolean(properties.getProperty(propertyName)));
                    break;
                }
                case "includeClass": {
                    this.classExclusions.setClassExclusion(instruction[1].split("\\."), !Boolean.parseBoolean(properties.getProperty(propertyName)));
                }
            }
        }
    }
}

