/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.optimization;

import java.util.Objects;
import org.teavm.model.BasicBlock;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.BaseTypeInference;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.optimization.MethodOptimization;
import org.teavm.model.optimization.MethodOptimizationContext;

public class SystemArrayCopyOptimization
implements MethodOptimization {
    private static final MethodReference ARRAY_COPY_METHOD = new MethodReference(System.class, "arraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Void.TYPE);
    private static final MethodReference FAST_ARRAY_COPY_METHOD = new MethodReference(System.class, "fastArraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Void.TYPE);
    private static final ValueType DEFAULT_TYPE = ValueType.object("java.lang.Object");

    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        TypeInference typeInference = new TypeInference(program, context.getMethod().getReference());
        boolean somethingChanged = false;
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                InvokeInstruction invoke;
                MethodReference method;
                if (!(instruction instanceof InvokeInstruction) || !(method = (invoke = (InvokeInstruction)instruction).getMethod()).equals(ARRAY_COPY_METHOD)) continue;
                ValueType sourceType = (ValueType)typeInference.typeOf(invoke.getArguments().get(0));
                ValueType destType = (ValueType)typeInference.typeOf(invoke.getArguments().get(2));
                if (!(sourceType instanceof ValueType.Array) || !(destType instanceof ValueType.Array) || !sourceType.equals(destType) && !context.getHierarchy().isSuperType(destType, sourceType, false)) continue;
                invoke.setMethod(FAST_ARRAY_COPY_METHOD);
                somethingChanged = true;
            }
        }
        return somethingChanged;
    }

    private static class TypeInference
    extends BaseTypeInference<ValueType> {
        TypeInference(Program program, MethodReference reference) {
            super(program, reference);
        }

        @Override
        public ValueType merge(ValueType a, ValueType b) {
            if (!Objects.equals(a, b)) {
                return DEFAULT_TYPE;
            }
            return a;
        }

        @Override
        public ValueType elementType(ValueType valueType) {
            return valueType instanceof ValueType.Array ? ((ValueType.Array)valueType).getItemType() : DEFAULT_TYPE;
        }

        @Override
        public ValueType nullType() {
            return DEFAULT_TYPE;
        }

        @Override
        public ValueType mapType(ValueType type) {
            return type instanceof ValueType.Array ? type : DEFAULT_TYPE;
        }
    }
}

