/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.teavm.backend.wasm.debug.info.ArrayLayout;
import org.teavm.backend.wasm.debug.info.ClassLayout;
import org.teavm.backend.wasm.debug.info.ClassLayoutInfo;
import org.teavm.backend.wasm.debug.info.DebugInfo;
import org.teavm.backend.wasm.debug.info.FieldInfo;
import org.teavm.backend.wasm.debug.info.FieldType;
import org.teavm.backend.wasm.debug.info.InterfaceLayout;
import org.teavm.backend.wasm.debug.info.PrimitiveLayout;
import org.teavm.backend.wasm.debug.info.TypeLayout;
import org.teavm.common.Promise;
import org.teavm.debugging.Debugger;
import org.teavm.debugging.Value;
import org.teavm.debugging.Variable;
import org.teavm.debugging.javascript.JavaScriptCallFrame;
import org.teavm.debugging.javascript.JavaScriptValue;
import org.teavm.model.PrimitiveType;

class WasmValueImpl
extends Value {
    private static final String CLASS_PROP = "__class";
    private static final String ADDRESS_PROP = "__address";
    private DebugInfo debugInfo;
    private FieldType type;
    private JavaScriptCallFrame callFrame;
    private long longValue;
    private Promise<TypeLayout> calculatedType;

    WasmValueImpl(Debugger debugger, DebugInfo debugInfo, FieldType type, JavaScriptCallFrame callFrame, long longValue) {
        super(debugger);
        this.debugInfo = debugInfo;
        this.type = type;
        this.callFrame = callFrame;
        this.longValue = longValue;
    }

    @Override
    public Promise<String> getRepresentation() {
        switch (this.type) {
            case BOOLEAN: {
                return Promise.of(this.longValue != 0L ? "true" : "false");
            }
            case BYTE: {
                return Promise.of(Byte.toString((byte)this.longValue));
            }
            case SHORT: {
                return Promise.of(Short.toString((short)this.longValue));
            }
            case CHAR: {
                StringBuilder sb = new StringBuilder("'");
                this.appendChar(sb, (char)this.longValue);
                sb.append("'");
                return Promise.of(sb.toString());
            }
            case INT: {
                return Promise.of(Integer.toString((int)this.longValue));
            }
            case LONG: {
                return Promise.of(Long.toString(this.longValue));
            }
            case FLOAT: {
                return Promise.of(Float.toString(Float.intBitsToFloat((int)this.longValue)));
            }
            case DOUBLE: {
                return Promise.of(Double.toString(Double.longBitsToDouble(this.longValue)));
            }
            case OBJECT: {
                return this.buildObjectRepresentation();
            }
            case ADDRESS: {
                return Promise.of("0x" + Integer.toHexString((int)this.longValue));
            }
        }
        return Promise.of("undefined");
    }

    private void appendChar(StringBuilder sb, char c) {
        switch (c) {
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            case '\b': {
                sb.append("\\b");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\'': {
                sb.append("\\'");
                break;
            }
            case '\"': {
                sb.append("\\\"");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            default: {
                if (c < ' ') {
                    sb.append("\\u00").append(Character.forDigit(c / 16, 16)).append(Character.forDigit(c % 16, 16));
                    break;
                }
                sb.append(c);
            }
        }
    }

    private Promise<String> buildObjectRepresentation() {
        if (this.longValue == 0L) {
            return Promise.of("null");
        }
        return this.getCalculatedType().thenAsync(cls -> {
            if (cls == null) {
                return Promise.of("error");
            }
            return this.typeRepresentation((TypeLayout)cls, (int)this.longValue);
        });
    }

    private Promise<String> typeRepresentation(TypeLayout type, int address) {
        switch (type.kind()) {
            case CLASS: {
                return this.objectRepresentation((ClassLayout)type, address);
            }
            case ARRAY: {
                return this.arrayRepresentation((ArrayLayout)type, address);
            }
        }
        return Promise.of(this.classToString(type));
    }

    private Promise<String> objectRepresentation(ClassLayout cls, int address) {
        String stringRepr;
        if (cls.classRef().fullName().equals("java.lang.String")) {
            Promise<String> stringRepr2 = this.decodeString(cls, address);
            if (stringRepr2 != null) {
                return stringRepr2.then(result -> result != null ? result : this.classToString(cls));
            }
        } else if (cls.classRef().fullName().equals("java.lang.Class") && (stringRepr = this.decodeClass(address)) != null) {
            return Promise.of(stringRepr);
        }
        return Promise.of(this.classToString(cls));
    }

    private Promise<String> arrayRepresentation(ArrayLayout arrayType, int address) {
        return this.callFrame.getMemory(address + 8, 4).then(data -> {
            if (data == null) {
                return this.classToString(arrayType);
            }
            int length = this.readInt((byte[])data, 0);
            return this.classToString(arrayType.elementType()) + "[" + length + "]";
        });
    }

    private Promise<String> decodeString(ClassLayout cls, int address) {
        for (FieldInfo fieldInfo : cls.instanceFields()) {
            if (!fieldInfo.name().equals("characters") || fieldInfo.type() != FieldType.OBJECT) continue;
            return this.callFrame.getMemory(address + fieldInfo.address(), 4).thenAsync(data -> {
                int charsAddress = this.readInt((byte[])data, 0);
                return this.decodeChars(charsAddress);
            });
        }
        return null;
    }

    private Promise<String> decodeChars(int address) {
        return this.callFrame.getMemory(address, 12).thenAsync(data -> {
            if (data == null) {
                return null;
            }
            int classPtr = this.readInt((byte[])data, 0) << 3;
            TypeLayout type = this.debugInfo.classLayoutInfo().find(classPtr);
            if (!(type instanceof ArrayLayout)) {
                return null;
            }
            TypeLayout elementType = ((ArrayLayout)type).elementType();
            if (!(elementType instanceof PrimitiveLayout)) {
                return null;
            }
            PrimitiveType primitiveType = ((PrimitiveLayout)elementType).primitiveType();
            if (primitiveType != PrimitiveType.CHARACTER) {
                return null;
            }
            int length = this.readInt((byte[])data, 8);
            return this.callFrame.getMemory(address + 12, length * 2).then(charsData -> {
                if (charsData == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder("\"");
                for (int i = 0; i < length; ++i) {
                    this.appendChar(sb, (char)this.readShort((byte[])charsData, i * 2));
                }
                sb.append("\"");
                return sb.toString();
            });
        });
    }

    private String decodeClass(int address) {
        TypeLayout type = this.debugInfo.classLayoutInfo().find(address);
        return type != null ? this.classToString(type) : null;
    }

    @Override
    Promise<String> prepareType() {
        switch (this.type) {
            case BOOLEAN: {
                return Promise.of("boolean");
            }
            case BYTE: {
                return Promise.of("byte");
            }
            case SHORT: {
                return Promise.of("short");
            }
            case CHAR: {
                return Promise.of("char");
            }
            case INT: {
                return Promise.of("int");
            }
            case LONG: {
                return Promise.of("long");
            }
            case FLOAT: {
                return Promise.of("float");
            }
            case DOUBLE: {
                return Promise.of("double");
            }
            case ADDRESS: {
                return Promise.of("address");
            }
            case OBJECT: {
                return this.fetchObjectType();
            }
        }
        return Promise.of("undefined");
    }

    private Promise<TypeLayout> getCalculatedType() {
        if (this.calculatedType == null) {
            this.calculatedType = this.callFrame.getMemory((int)this.longValue, 4).then(data -> {
                if (data == null) {
                    return null;
                }
                int header = this.readInt((byte[])data, 0);
                int classPtr = header << 3;
                ClassLayoutInfo classes = this.debugInfo.classLayoutInfo();
                if (classes == null) {
                    return null;
                }
                return classes.find(classPtr);
            });
        }
        return this.calculatedType;
    }

    private Promise<String> fetchObjectType() {
        if (this.longValue == 0L) {
            return Promise.of("null");
        }
        return this.getCalculatedType().then(cls -> {
            if (cls == null) {
                return "error";
            }
            return this.classToString((TypeLayout)cls);
        });
    }

    private String classToString(TypeLayout type) {
        switch (type.kind()) {
            case PRIMITIVE: {
                switch (((PrimitiveLayout)type).primitiveType()) {
                    case BOOLEAN: {
                        return "boolean";
                    }
                    case BYTE: {
                        return "byte";
                    }
                    case SHORT: {
                        return "short";
                    }
                    case CHARACTER: {
                        return "char";
                    }
                    case INTEGER: {
                        return "int";
                    }
                    case LONG: {
                        return "long";
                    }
                    case FLOAT: {
                        return "float";
                    }
                    case DOUBLE: {
                        return "double";
                    }
                }
                break;
            }
            case CLASS: {
                return ((ClassLayout)type).classRef().fullName();
            }
            case INTERFACE: {
                return ((InterfaceLayout)type).classRef().fullName();
            }
            case ARRAY: {
                return this.classToString(((ArrayLayout)type).elementType()) + "[]";
            }
        }
        return "unknown";
    }

    @Override
    Promise<Map<String, Variable>> prepareProperties() {
        return this.getCalculatedType().thenAsync(cls -> {
            if (cls != null) {
                switch (cls.kind()) {
                    case CLASS: {
                        return this.fetchObjectProperties((ClassLayout)cls);
                    }
                    case ARRAY: {
                        return this.fetchArrayProperties((ArrayLayout)cls);
                    }
                }
            }
            return Promise.of(Collections.emptyMap());
        });
    }

    private Promise<Map<String, Variable>> fetchObjectProperties(ClassLayout cls) {
        if (this.longValue == 0L) {
            return Promise.of(Collections.emptyMap());
        }
        return this.callFrame.getMemory((int)this.longValue, cls.size()).then(data -> {
            if (data == null) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Variable> properties = new LinkedHashMap<String, Variable>();
            for (ClassLayout ancestorCls = cls; ancestorCls != null; ancestorCls = ancestorCls.superclass()) {
                for (FieldInfo fieldInfo : ancestorCls.instanceFields()) {
                    long longValue;
                    switch (fieldInfo.type()) {
                        case BOOLEAN: 
                        case BYTE: {
                            longValue = data[fieldInfo.address()];
                            break;
                        }
                        case SHORT: 
                        case CHAR: {
                            longValue = this.readShort((byte[])data, fieldInfo.address());
                            break;
                        }
                        case INT: 
                        case FLOAT: 
                        case OBJECT: 
                        case ADDRESS: {
                            longValue = this.readInt((byte[])data, fieldInfo.address());
                            break;
                        }
                        case LONG: 
                        case DOUBLE: {
                            longValue = this.readLong((byte[])data, fieldInfo.address());
                            break;
                        }
                        default: {
                            longValue = 0L;
                        }
                    }
                    WasmValueImpl value = new WasmValueImpl(this.debugger, this.debugInfo, fieldInfo.type(), this.callFrame, longValue);
                    properties.put(fieldInfo.name(), new Variable(fieldInfo.name(), value));
                }
            }
            this.addCommonProperties(properties, cls);
            return properties;
        });
    }

    private Promise<Map<String, Variable>> fetchArrayProperties(ArrayLayout type) {
        if (this.longValue == 0L) {
            return Promise.of(Collections.emptyMap());
        }
        return this.callFrame.getMemory((int)this.longValue + 8, 4).thenAsync(data -> {
            int itemSize;
            FieldType elementType;
            if (data == null) {
                return Promise.of(Collections.emptyMap());
            }
            int length = this.readInt((byte[])data, 0);
            int offset = 12;
            if (type.elementType() instanceof PrimitiveLayout) {
                switch (((PrimitiveLayout)type.elementType()).primitiveType()) {
                    case BOOLEAN: {
                        elementType = FieldType.BOOLEAN;
                        itemSize = 0;
                        break;
                    }
                    case BYTE: {
                        elementType = FieldType.BYTE;
                        itemSize = 0;
                        break;
                    }
                    case SHORT: {
                        elementType = FieldType.SHORT;
                        itemSize = 1;
                        break;
                    }
                    case CHARACTER: {
                        elementType = FieldType.CHAR;
                        itemSize = 1;
                        break;
                    }
                    case INTEGER: {
                        elementType = FieldType.INT;
                        itemSize = 2;
                        break;
                    }
                    case LONG: {
                        elementType = FieldType.LONG;
                        itemSize = 3;
                        break;
                    }
                    case FLOAT: {
                        elementType = FieldType.FLOAT;
                        itemSize = 2;
                        break;
                    }
                    case DOUBLE: {
                        elementType = FieldType.DOUBLE;
                        offset = 16;
                        itemSize = 3;
                        break;
                    }
                    default: {
                        itemSize = 1;
                        elementType = FieldType.UNDEFINED;
                        break;
                    }
                }
            } else {
                elementType = FieldType.OBJECT;
                itemSize = 2;
            }
            return this.callFrame.getMemory((int)this.longValue + offset, length << itemSize).then(arrayData -> {
                LinkedHashMap<String, Variable> properties = new LinkedHashMap<String, Variable>();
                for (int i = 0; i < length; ++i) {
                    long longValue;
                    String name = String.valueOf(i);
                    switch (itemSize) {
                        case 0: {
                            longValue = arrayData[i];
                            break;
                        }
                        case 1: {
                            longValue = this.readShort((byte[])arrayData, i * 2);
                            break;
                        }
                        case 2: {
                            longValue = this.readInt((byte[])arrayData, i * 4);
                            break;
                        }
                        default: {
                            longValue = this.readLong((byte[])arrayData, i * 8);
                        }
                    }
                    WasmValueImpl value = new WasmValueImpl(this.debugger, this.debugInfo, elementType, this.callFrame, longValue);
                    properties.put(name, new Variable(name, value));
                }
                properties.put("length", new Variable("length", new WasmValueImpl(this.debugger, this.debugInfo, FieldType.INT, this.callFrame, length)));
                this.addCommonProperties(properties, type);
                return properties;
            });
        });
    }

    private void addCommonProperties(Map<String, Variable> properties, TypeLayout cls) {
        properties.put(CLASS_PROP, new Variable(CLASS_PROP, new WasmValueImpl(this.debugger, this.debugInfo, FieldType.OBJECT, this.callFrame, cls.address())));
        properties.put(ADDRESS_PROP, new Variable(ADDRESS_PROP, new WasmValueImpl(this.debugger, this.debugInfo, FieldType.ADDRESS, this.callFrame, this.longValue)));
    }

    private int readInt(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 24;
    }

    private int readShort(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8;
    }

    private long readLong(byte[] data, int offset) {
        return (long)(data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 24) | ((long)data[offset + 4] & 0xFFL) << 32 | (long)((data[offset + 5] & 0xFF) << 40) | ((long)data[offset + 6] & 0xFFL) << 48 | (long)((data[offset + 7] & 0xFF) << 56);
    }

    @Override
    public Promise<Boolean> hasInnerStructure() {
        return Promise.of(this.type == FieldType.OBJECT && this.longValue != 0L);
    }

    @Override
    public Promise<String> getInstanceId() {
        return Promise.of(null);
    }

    @Override
    public JavaScriptValue getOriginalValue() {
        return null;
    }
}

