/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common.binary;

import java.nio.charset.StandardCharsets;

public class BinaryParser {
    public byte[] data;
    public int ptr;

    public int readLEB() {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = this.data[this.ptr++];
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    public int readSignedLEB() {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = this.data[this.ptr++];
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) == 0) {
                if ((b & 0x40) == 0) break;
                result |= -1 << shift + 7;
                break;
            }
            shift += 7;
        }
        return result;
    }

    public String readString() {
        int length = this.readLEB();
        String result = new String(this.data, this.ptr, length, StandardCharsets.UTF_8);
        this.ptr += length;
        return result;
    }
}

