/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.transformation.gc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.model.WasmBlockType;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmCastBranch;
import org.teavm.backend.wasm.model.expression.WasmCatch;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmCopy;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmExternConversion;
import org.teavm.backend.wasm.model.expression.WasmFill;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatUnary;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt31Get;
import org.teavm.backend.wasm.model.expression.WasmInt31Reference;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIsNull;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmMemoryGrow;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmPop;
import org.teavm.backend.wasm.model.expression.WasmPush;
import org.teavm.backend.wasm.model.expression.WasmReferencesEqual;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmTest;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmTry;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.backend.wasm.render.WasmSignature;
import org.teavm.backend.wasm.render.WasmTypeInference;
import org.teavm.backend.wasm.transformation.SuspensionPointCollector;
import org.teavm.backend.wasm.transformation.gc.CoroutineFunctions;

class CoroutineTransformationVisitor
implements WasmExpressionVisitor {
    SuspensionPointCollector collector;
    Set<WasmBlock> nonOptimizableBlocks;
    private WasmFunctionTypes functionTypes;
    private CoroutineFunctions functions;
    private SwitchContainer currentSwitchContainer;
    WasmLocal stateLocal;
    WasmLocal fiberLocal;
    Supplier<WasmLocal> tmpValueLocalSupplier;
    private int currentStateOffset;
    List<WasmExpression> resultList = new ArrayList<WasmExpression>();
    WasmBlock mainBlock;
    private WasmBlock suspendBlock;
    private WasmTypeInference typeInference;
    private List<WasmType> stackTypes = new ArrayList<WasmType>();

    CoroutineTransformationVisitor(WasmFunctionTypes functionTypes, CoroutineFunctions functions) {
        this.functionTypes = functionTypes;
        this.functions = functions;
        this.typeInference = new WasmTypeInference();
    }

    void init() {
        this.currentSwitchContainer = this.createSwitchContainer();
        this.suspendBlock = this.mainBlock = new WasmBlock(false);
    }

    void complete() {
        this.resultList.clear();
        this.currentStateOffset = 0;
        this.stateLocal = null;
        this.fiberLocal = null;
        this.collector = null;
        this.currentSwitchContainer = null;
        this.stackTypes.clear();
    }

    private SwitchContainer createSwitchContainer() {
        WasmBlock block = new WasmBlock(false);
        SwitchContainer container = new SwitchContainer();
        WasmExpression expr = new WasmGetLocal(this.stateLocal);
        if (this.currentStateOffset > 0) {
            expr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, expr, new WasmInt32Constant(this.currentStateOffset));
        }
        WasmSwitch switchExpr = new WasmSwitch(expr, block);
        block.getBody().add(switchExpr);
        WasmBlock outerBlock = new WasmBlock(false);
        outerBlock.getBody().add(block);
        outerBlock.getBody().add(new WasmUnreachable());
        switchExpr.getTargets().add(outerBlock);
        ++this.currentStateOffset;
        container.switchExpr = switchExpr;
        this.resultList.add(outerBlock);
        container.parent = this.currentSwitchContainer;
        return container;
    }

    @Override
    public void visit(WasmBlock expression) {
        if (expression.isLoop()) {
            this.splitLoopBlock(expression);
        } else {
            this.splitRegularBlock(expression);
        }
    }

    private void splitLoopBlock(WasmBlock block) {
        List<WasmExpression> oldResultList = this.resultList;
        List<WasmType> oldStackTypes = this.stackTypes;
        block.setLoop(false);
        this.resultList.add(new WasmSetLocal(this.stateLocal, new WasmInt32Constant(this.currentStateOffset)));
        WasmBlock jumpInsideBlock = new WasmBlock(false);
        jumpInsideBlock.getBody().addAll(this.resultList);
        this.resultList.clear();
        this.resultList.add(jumpInsideBlock);
        this.stackTypes = new ArrayList<WasmType>();
        WasmBlock containingBlock = new WasmBlock(true);
        containingBlock.getBody().add(block);
        containingBlock.getBody().add(new WasmSetLocal(this.stateLocal, new WasmInt32Constant(this.currentStateOffset)));
        containingBlock.getBody().add(new WasmBreak(containingBlock));
        this.resultList.add(containingBlock);
        this.resultList = new ArrayList<WasmExpression>();
        SwitchContainer oldSwitchContainer = this.currentSwitchContainer;
        this.currentSwitchContainer = this.createSwitchContainer();
        oldSwitchContainer.jumpInsideBlock = jumpInsideBlock;
        this.addJumpsToOuterSwitches(this.currentSwitchContainer);
        this.visitMany(block.getBody());
        block.getBody().clear();
        block.getBody().addAll(this.resultList);
        this.resultList = oldResultList;
        this.currentSwitchContainer = oldSwitchContainer;
        oldSwitchContainer.jumpInsideBlock = null;
        this.stackTypes = oldStackTypes;
    }

    private void splitRegularBlock(WasmBlock block) {
        if (block.getBody().isEmpty()) {
            return;
        }
        if (this.nonOptimizableBlocks.contains(block)) {
            this.splitRegularBlockFallback(block);
        } else {
            this.splitRegularBlockOptimized(block);
        }
    }

    private void splitRegularBlockFallback(WasmBlock block) {
        int i;
        List<WasmExpression> oldResultList = this.resultList;
        List<WasmType> oldStackTypes = this.stackTypes;
        WasmBlock oldSuspendBlock = this.suspendBlock;
        this.resultList.add(new WasmSetLocal(this.stateLocal, new WasmInt32Constant(this.currentStateOffset)));
        WasmBlock restoreBlock = new WasmBlock(false);
        WasmBlock jumpInsideBlock = new WasmBlock(false);
        jumpInsideBlock.getBody().addAll(this.resultList);
        restoreBlock.setType(this.functionTypes.blockType(this.stackTypes));
        restoreBlock.getBody().add(jumpInsideBlock);
        jumpInsideBlock.getBody().add(new WasmBreak(restoreBlock));
        for (WasmType type : this.stackTypes) {
            this.restore(restoreBlock.getBody(), type);
        }
        this.resultList.clear();
        this.resultList.add(restoreBlock);
        this.stackTypes = new ArrayList<WasmType>();
        this.resultList.add(block);
        this.resultList = new ArrayList<WasmExpression>();
        SwitchContainer oldSwitchContainer = this.currentSwitchContainer;
        this.currentSwitchContainer = this.createSwitchContainer();
        oldSwitchContainer.jumpInsideBlock = jumpInsideBlock;
        this.addJumpsToOuterSwitches(this.currentSwitchContainer);
        this.suspendBlock = block;
        this.visitMany(block.getBody());
        block.getBody().clear();
        block.getBody().addAll(this.resultList);
        this.resultList = oldResultList;
        this.currentSwitchContainer = oldSwitchContainer;
        this.suspendBlock = oldSuspendBlock;
        oldSwitchContainer.jumpInsideBlock = null;
        this.stackTypes = oldStackTypes;
        WasmConditional suspendCheck = new WasmConditional(this.isSuspending());
        ArrayList<WasmType> allTypes = new ArrayList<WasmType>(this.stackTypes);
        allTypes.addAll(block.getResultTypes());
        if (!allTypes.isEmpty()) {
            suspendCheck.setType(this.functionTypes.get(new WasmSignature(allTypes, allTypes)).asBlock());
        }
        List<? extends WasmType> resultTypes = block.getResultTypes();
        for (i = resultTypes.size() - 1; i >= 0; --i) {
            suspendCheck.getThenBlock().getBody().add(new WasmDrop(new WasmPop(resultTypes.get(i))));
        }
        for (i = this.stackTypes.size() - 1; i >= 0; --i) {
            this.save(suspendCheck.getThenBlock().getBody(), this.stackTypes.get(i));
        }
        for (WasmType wasmType : this.suspendBlock.getResultTypes()) {
            this.pushDefault(suspendCheck.getThenBlock().getBody(), wasmType);
        }
        suspendCheck.getThenBlock().getBody().add(new WasmBreak(this.suspendBlock));
        this.resultList.add(suspendCheck);
        this.stackTypes.addAll(block.getResultTypes());
    }

    private void splitRegularBlockOptimized(WasmBlock block) {
        int typesOnStack = this.stackTypes.size();
        this.visitMany(block.getBody());
        if (typesOnStack < this.stackTypes.size()) {
            this.stackTypes.subList(typesOnStack, this.stackTypes.size()).clear();
        }
        this.stackTypes.addAll(block.getResultTypes());
        block.getBody().clear();
        block.getBody().addAll(this.resultList);
        this.resultList.clear();
        this.resultList.add(block);
        block.setType(this.functionTypes.blockType(this.stackTypes));
    }

    private void visitMany(Iterable<? extends WasmExpression> expressions) {
        for (WasmExpression wasmExpression : expressions) {
            if (this.collector.isSuspending(wasmExpression)) {
                wasmExpression.acceptVisitor(this);
                continue;
            }
            this.addExpr(wasmExpression);
        }
    }

    @Override
    public void visit(WasmBranch expression) {
        this.visitBinary(expression, WasmBranch::getResult, WasmBranch::setResult, WasmBranch::getCondition, WasmBranch::setCondition);
    }

    @Override
    public void visit(WasmNullBranch expression) {
        this.visitBinary(expression, WasmNullBranch::getResult, WasmNullBranch::setResult, WasmNullBranch::getValue, WasmNullBranch::setValue);
    }

    @Override
    public void visit(WasmCastBranch expression) {
        this.visitBinary(expression, WasmCastBranch::getResult, WasmCastBranch::setResult, WasmCastBranch::getValue, WasmCastBranch::setValue);
    }

    @Override
    public void visit(WasmBreak expression) {
        this.visitUnary(expression, WasmBreak::getResult, WasmBreak::setResult);
    }

    @Override
    public void visit(WasmSwitch expression) {
        expression.getSelector().acceptVisitor(this);
        expression.setSelector(new WasmPop(this.peekType(0)));
        this.popTypes(0);
        this.resultList.add(expression);
    }

    @Override
    public void visit(WasmConditional expression) {
        if (this.collector.isSuspending(expression.getCondition())) {
            expression.getCondition().acceptVisitor(this);
            expression.setCondition(new WasmPop(this.peekType(0)));
            this.popTypes(1);
        }
        if (!this.isSuspending(expression.getThenBlock().getBody()) && !this.isSuspending(expression.getElseBlock().getBody())) {
            this.addExpr(expression);
            return;
        }
        List<WasmType> oldStackTypes = this.stackTypes;
        WasmBlock elseBlock = new WasmBlock(false);
        WasmBlock thenBlock = new WasmBlock(false);
        ArrayList<WasmType> outputTypes = new ArrayList<WasmType>(this.stackTypes);
        if (expression.getType() != null) {
            outputTypes.addAll(expression.getType().getOutputTypes());
        }
        thenBlock.setType(this.functionTypes.blockType(outputTypes));
        elseBlock.setType(this.functionTypes.blockType(this.stackTypes));
        WasmBranch br = new WasmBranch(expression.getCondition(), elseBlock);
        this.resultList.add(br);
        this.stackTypes = new ArrayList<WasmType>(oldStackTypes);
        this.visitMany(expression.getElseBlock().getBody());
        elseBlock.getBody().addAll(this.resultList);
        this.resultList.clear();
        this.resultList.add(elseBlock);
        if (!elseBlock.isTerminating()) {
            elseBlock.getBody().add(new WasmBreak(thenBlock));
        }
        this.stackTypes = new ArrayList<WasmType>(oldStackTypes);
        this.visitMany(expression.getThenBlock().getBody());
        thenBlock.getBody().addAll(this.resultList);
        this.resultList.clear();
        this.resultList.add(thenBlock);
        this.stackTypes = oldStackTypes;
        if (expression.getType() != null) {
            this.stackTypes.addAll(expression.getType().getOutputTypes());
        }
    }

    @Override
    public void visit(WasmReturn expression) {
        this.visitUnary(expression, WasmReturn::getValue, WasmReturn::setValue);
    }

    @Override
    public void visit(WasmUnreachable expression) {
        this.addExpr(expression);
    }

    @Override
    public void visit(WasmInt32Constant expression) {
        this.addExpr(expression);
    }

    @Override
    public void visit(WasmInt64Constant expression) {
        this.addExpr(expression);
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
        this.addExpr(expression);
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
        this.addExpr(expression);
    }

    @Override
    public void visit(WasmNullConstant expression) {
        this.addExpr(expression);
    }

    @Override
    public void visit(WasmIsNull expression) {
        this.visitUnary(expression, WasmIsNull::getValue, WasmIsNull::setValue);
    }

    @Override
    public void visit(WasmGetLocal expression) {
        this.addExpr(expression);
    }

    @Override
    public void visit(WasmSetLocal expression) {
        this.visitUnary(expression, WasmSetLocal::getValue, WasmSetLocal::setValue);
    }

    @Override
    public void visit(WasmGetGlobal expression) {
        this.addExpr(expression);
    }

    @Override
    public void visit(WasmSetGlobal expression) {
        this.visitUnary(expression, WasmSetGlobal::getValue, WasmSetGlobal::setValue);
    }

    @Override
    public void visit(WasmIntBinary expression) {
        this.visitBinary(expression, WasmIntBinary::getFirst, WasmIntBinary::setFirst, WasmIntBinary::getSecond, WasmIntBinary::setSecond);
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        this.visitBinary(expression, WasmFloatBinary::getFirst, WasmFloatBinary::setFirst, WasmFloatBinary::getSecond, WasmFloatBinary::setSecond);
    }

    @Override
    public void visit(WasmIntUnary expression) {
        this.visitUnary(expression, WasmIntUnary::getOperand, WasmIntUnary::setOperand);
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        this.visitUnary(expression, WasmFloatUnary::getOperand, WasmFloatUnary::setOperand);
    }

    @Override
    public void visit(WasmConversion expression) {
        this.visitUnary(expression, WasmConversion::getOperand, WasmConversion::setOperand);
    }

    @Override
    public void visit(WasmCall expression) {
        this.visitCall(expression, expression.isSuspensionPoint(), e -> new ArrayList<WasmExpression>(e.getArguments()), (e, args) -> {
            e.getArguments().clear();
            e.getArguments().addAll((Collection<WasmExpression>)args);
        }, false, expression.getFunction().getType().getParameterTypes(), expression.getFunction().getType().getReturnTypes());
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        ArrayList<? extends WasmType> argTypes = new ArrayList<WasmType>();
        argTypes.add(WasmType.INT32);
        argTypes.addAll(expression.getType().getParameterTypes());
        this.visitCall(expression, expression.isSuspensionPoint(), e -> {
            ArrayList<WasmExpression> result = new ArrayList<WasmExpression>();
            result.add(e.getSelector());
            result.addAll(e.getArguments());
            return result;
        }, (e, args) -> {
            e.setSelector((WasmExpression)args.get(0));
            e.getArguments().clear();
            e.getArguments().addAll(args.subList(1, args.size()));
        }, false, argTypes, expression.getType().getReturnTypes());
    }

    @Override
    public void visit(WasmCallReference expression) {
        ArrayList<? extends WasmType> argTypes = new ArrayList<WasmType>(expression.getType().getParameterTypes());
        argTypes.add(expression.getType().getReference());
        this.visitCall(expression, expression.isSuspensionPoint(), e -> {
            ArrayList<WasmExpression> result = new ArrayList<WasmExpression>();
            result.addAll(e.getArguments());
            result.add(e.getFunctionReference());
            return result;
        }, (e, args) -> {
            e.setFunctionReference((WasmExpression)args.get(0));
            e.getArguments().clear();
            e.getArguments().addAll(args.subList(1, args.size()));
        }, true, argTypes, expression.getType().getReturnTypes());
    }

    private <T extends WasmExpression> void visitCall(T expression, boolean suspending, Function<T, List<WasmExpression>> argsGetter, BiConsumer<T, List<? extends WasmExpression>> argsSetter, boolean saveLastArg, List<? extends WasmType> argTypes, List<? extends WasmType> returnTypes) {
        Object type;
        if (!this.collector.isSuspending(expression)) {
            this.addExpr(expression);
            return;
        }
        if (!suspending) {
            this.visitNAry(expression, argsGetter, argsSetter);
            return;
        }
        List<WasmExpression> arguments = argsGetter.apply(expression);
        for (int i = 0; i < arguments.size(); ++i) {
            WasmExpression arg = arguments.get(i);
            arg.acceptVisitor(this.typeInference);
            WasmType type2 = this.typeInference.getSingleResult();
            if (this.collector.isSuspending(arg)) {
                arg.acceptVisitor(this);
            } else {
                this.resultList.add(arg);
                this.stackTypes.add(type2);
            }
            arguments.set(i, new WasmPop(type2));
        }
        this.stackTypes.subList(this.stackTypes.size() - argTypes.size(), this.stackTypes.size()).clear();
        this.stackTypes.addAll(argTypes);
        argsSetter.accept(expression, arguments);
        WasmBlockType argsBlockType = this.functionTypes.blockType(this.stackTypes);
        WasmBlock innerBlock = new WasmBlock(false);
        WasmBlock outerBlock = new WasmBlock(false);
        outerBlock.setType(argsBlockType);
        innerBlock.getBody().addAll(this.resultList);
        this.resultList.clear();
        innerBlock.getBody().add(new WasmBreak(outerBlock));
        outerBlock.getBody().add(innerBlock);
        for (WasmType wasmType : this.stackTypes.subList(0, this.stackTypes.size() - arguments.size())) {
            this.restore(outerBlock.getBody(), wasmType);
        }
        if (saveLastArg) {
            for (int i = 0; i < argTypes.size() - 1; ++i) {
                this.pushDefault(outerBlock.getBody(), argTypes.get(i));
            }
            type = argTypes.get(argTypes.size() - 1);
            this.restore(outerBlock.getBody(), (WasmType)type);
        } else {
            for (WasmType wasmType : argTypes) {
                this.pushDefault(outerBlock.getBody(), wasmType);
            }
        }
        this.resultList.add(outerBlock);
        if (saveLastArg) {
            type = argTypes.get(argTypes.size() - 1);
            this.resultList.add(new WasmSetLocal(this.tmpValueLocalSupplier.get(), new WasmPop((WasmType)type)));
            this.resultList.add(new WasmCast(new WasmGetLocal(this.tmpValueLocalSupplier.get()), (WasmType.Reference)type));
        }
        int state = this.currentStateOffset++;
        this.resultList.add(new WasmSetLocal(this.stateLocal, new WasmInt32Constant(state)));
        this.resultList.add(expression);
        this.popTypes(arguments.size());
        WasmConditional wasmConditional = new WasmConditional(this.isSuspending());
        this.stackTypes.addAll(returnTypes);
        if (!this.stackTypes.isEmpty()) {
            List<WasmType> types = List.copyOf(this.stackTypes);
            wasmConditional.setType(this.functionTypes.get(new WasmSignature(types, types)).asBlock());
        }
        for (int i = returnTypes.size() - 1; i >= 0; --i) {
            wasmConditional.getThenBlock().getBody().add(new WasmDrop(new WasmPop(returnTypes.get(i))));
        }
        if (saveLastArg) {
            WasmType.Reference type4 = (WasmType.Reference)argTypes.get(argTypes.size() - 1);
            wasmConditional.getThenBlock().getBody().add(new WasmCast(new WasmGetLocal(this.tmpValueLocalSupplier.get()), type4));
            this.save(wasmConditional.getThenBlock().getBody(), type4);
        }
        for (int i = this.stackTypes.size() - 1 - returnTypes.size(); i >= 0; --i) {
            this.save(wasmConditional.getThenBlock().getBody(), this.stackTypes.get(i));
        }
        for (WasmType wasmType : this.suspendBlock.getResultTypes()) {
            this.pushDefault(wasmConditional.getThenBlock().getBody(), wasmType);
        }
        wasmConditional.getThenBlock().getBody().add(new WasmBreak(this.suspendBlock));
        this.resultList.add(wasmConditional);
        SwitchContainer sc = this.currentSwitchContainer;
        sc.switchExpr.getTargets().add(innerBlock);
        this.addJumpsToOuterSwitches(sc);
    }

    private void addJumpsToOuterSwitches(SwitchContainer sc) {
        while ((sc = sc.parent) != null) {
            sc.switchExpr.getTargets().add(sc.jumpInsideBlock);
        }
    }

    @Override
    public void visit(WasmDrop expression) {
        expression.getOperand().acceptVisitor(this);
        WasmType type = this.stackTypes.remove(this.stackTypes.size() - 1);
        this.resultList.add(new WasmDrop(new WasmPop(type)));
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        this.visitUnary(expression, WasmLoadInt32::getIndex, WasmLoadInt32::setIndex);
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        this.visitUnary(expression, WasmLoadInt64::getIndex, WasmLoadInt64::setIndex);
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        this.visitUnary(expression, WasmLoadFloat32::getIndex, WasmLoadFloat32::setIndex);
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        this.visitUnary(expression, WasmLoadFloat64::getIndex, WasmLoadFloat64::setIndex);
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        this.visitBinary(expression, WasmStoreInt32::getIndex, WasmStoreInt32::setIndex, WasmStoreInt32::getValue, WasmStoreInt32::setValue);
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        this.visitBinary(expression, WasmStoreInt64::getIndex, WasmStoreInt64::setIndex, WasmStoreInt64::getValue, WasmStoreInt64::setValue);
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        this.visitBinary(expression, WasmStoreFloat32::getIndex, WasmStoreFloat32::setIndex, WasmStoreFloat32::getValue, WasmStoreFloat32::setValue);
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        this.visitBinary(expression, WasmStoreFloat64::getIndex, WasmStoreFloat64::setIndex, WasmStoreFloat64::getValue, WasmStoreFloat64::setValue);
    }

    @Override
    public void visit(WasmMemoryGrow expression) {
        this.visitUnary(expression, WasmMemoryGrow::getAmount, WasmMemoryGrow::setAmount);
    }

    @Override
    public void visit(WasmFill expression) {
        this.visitNAry(expression, fill -> new ArrayList<WasmExpression>(List.of(fill.getIndex(), fill.getValue(), fill.getCount())), (fill, args) -> {
            fill.setIndex((WasmExpression)args.get(0));
            fill.setValue((WasmExpression)args.get(1));
            fill.setCount((WasmExpression)args.get(2));
        });
    }

    @Override
    public void visit(WasmCopy expression) {
        this.visitNAry(expression, copy -> new ArrayList<WasmExpression>(List.of(copy.getDestinationIndex(), copy.getSourceIndex(), copy.getCount())), (copy, args) -> {
            copy.setDestinationIndex((WasmExpression)args.get(0));
            copy.setSourceIndex((WasmExpression)args.get(1));
            copy.setCount((WasmExpression)args.get(2));
        });
    }

    @Override
    public void visit(WasmTry expression) {
        if (this.isSuspending(expression.getBody())) {
            this.splitTryBody(expression);
        }
        boolean hasSplitCatches = false;
        for (WasmCatch catchClause : expression.getCatches()) {
            if (!this.isSuspending(catchClause.getBody())) continue;
            hasSplitCatches = true;
            break;
        }
        if (hasSplitCatches) {
            List<WasmType> oldStackTypes = this.stackTypes;
            WasmBlock current = new WasmBlock(false);
            current.getBody().addAll(this.resultList);
            this.resultList.clear();
            this.resultList.add(current);
            for (WasmCatch catchClause : expression.getCatches()) {
                if (!this.isSuspending(catchClause.getBody())) continue;
                this.stackTypes = new ArrayList<WasmType>();
                this.stackTypes.addAll(catchClause.getTag().getType().getReturnTypes());
                WasmBlock wrapper = new WasmBlock(false);
                this.visitMany(catchClause.getBody());
                catchClause.getBody().clear();
                catchClause.getBody().add(new WasmBreak(wrapper));
                wrapper.getBody().addAll(this.resultList);
                this.resultList.clear();
                this.resultList.add(wrapper);
                current = wrapper;
            }
            current.setType(expression.getType() != null ? expression.getType().asBlock() : null);
            if (!expression.getBody().isEmpty()) {
                int lastBodyIndex = expression.getBody().size() - 1;
                WasmExpression lastBodyPart = expression.getBody().get(lastBodyIndex);
                if (!lastBodyPart.isTerminating()) {
                    expression.getBody().add(new WasmBreak(current));
                }
            }
            this.stackTypes = oldStackTypes;
        }
    }

    private boolean isSuspending(List<? extends WasmExpression> expressions) {
        for (WasmExpression wasmExpression : expressions) {
            if (!this.collector.isSuspending(wasmExpression)) continue;
            return true;
        }
        return false;
    }

    private void splitTryBody(WasmTry expression) {
        List<WasmExpression> oldResultList = this.resultList;
        List<WasmType> oldStackTypes = this.stackTypes;
        this.stackTypes = new ArrayList<WasmType>();
        this.resultList.add(new WasmSetLocal(this.stateLocal, new WasmInt32Constant(this.currentStateOffset)));
        WasmBlock jumpInsideBlock = new WasmBlock(false);
        jumpInsideBlock.getBody().addAll(this.resultList);
        this.resultList.clear();
        this.resultList.add(jumpInsideBlock);
        this.resultList.add(expression);
        this.resultList = new ArrayList<WasmExpression>();
        SwitchContainer oldSwitchContainer = this.currentSwitchContainer;
        this.currentSwitchContainer = this.createSwitchContainer();
        oldSwitchContainer.jumpInsideBlock = jumpInsideBlock;
        this.addJumpsToOuterSwitches(this.currentSwitchContainer);
        this.visitMany(expression.getBody());
        expression.getBody().clear();
        expression.getBody().addAll(this.resultList);
        this.resultList = oldResultList;
        this.currentSwitchContainer = oldSwitchContainer;
        this.stackTypes = oldStackTypes;
        oldSwitchContainer.jumpInsideBlock = null;
        if (expression.getType() != null) {
            this.stackTypes.add(expression.getType());
        }
    }

    @Override
    public void visit(WasmThrow expression) {
        this.visitNAry(expression, e -> new ArrayList<WasmExpression>(e.getArguments()), (e, args) -> {
            e.getArguments().clear();
            e.getArguments().addAll((Collection<WasmExpression>)args);
        });
    }

    @Override
    public void visit(WasmReferencesEqual expression) {
        this.visitBinary(expression, WasmReferencesEqual::getFirst, WasmReferencesEqual::setFirst, WasmReferencesEqual::getSecond, WasmReferencesEqual::setSecond);
    }

    @Override
    public void visit(WasmCast expression) {
        this.visitUnary(expression, WasmCast::getValue, WasmCast::setValue);
    }

    @Override
    public void visit(WasmExternConversion expression) {
        this.visitUnary(expression, WasmExternConversion::getValue, WasmExternConversion::setValue);
    }

    @Override
    public void visit(WasmTest expression) {
        this.visitUnary(expression, WasmTest::getValue, WasmTest::setValue);
    }

    @Override
    public void visit(WasmStructNew expression) {
        this.visitNAry(expression, e -> new ArrayList<WasmExpression>(e.getInitializers()), (e, args) -> {
            e.getInitializers().clear();
            e.getInitializers().addAll((Collection<WasmExpression>)args);
        });
    }

    @Override
    public void visit(WasmStructNewDefault expression) {
        this.addExpr(expression);
    }

    @Override
    public void visit(WasmStructGet expression) {
        this.visitUnary(expression, WasmStructGet::getInstance, WasmStructGet::setInstance);
    }

    @Override
    public void visit(WasmStructSet expression) {
        this.visitBinary(expression, WasmStructSet::getInstance, WasmStructSet::setInstance, WasmStructSet::getValue, WasmStructSet::setValue);
    }

    @Override
    public void visit(WasmArrayNewDefault expression) {
        this.addExpr(expression);
    }

    @Override
    public void visit(WasmArrayNewFixed expression) {
        this.visitNAry(expression, e -> new ArrayList<WasmExpression>(e.getElements()), (e, args) -> {
            e.getElements().clear();
            e.getElements().addAll((Collection<WasmExpression>)args);
        });
    }

    @Override
    public void visit(WasmArrayGet expression) {
        this.visitBinary(expression, WasmArrayGet::getInstance, WasmArrayGet::setInstance, WasmArrayGet::getIndex, WasmArrayGet::setIndex);
    }

    @Override
    public void visit(WasmArraySet expression) {
        this.visitNAry(expression, e -> {
            ArrayList<WasmExpression> result = new ArrayList<WasmExpression>();
            result.add(e.getInstance());
            result.add(e.getIndex());
            result.add(e.getValue());
            return result;
        }, (e, args) -> {
            e.setInstance((WasmExpression)args.get(0));
            e.setIndex((WasmExpression)args.get(1));
            e.setValue((WasmExpression)args.get(2));
        });
    }

    @Override
    public void visit(WasmArrayLength expression) {
        this.visitUnary(expression, WasmArrayLength::getInstance, WasmArrayLength::setInstance);
    }

    @Override
    public void visit(WasmArrayCopy expression) {
        this.visitNAry(expression, e -> {
            ArrayList<WasmExpression> result = new ArrayList<WasmExpression>();
            result.add(e.getTargetArray());
            result.add(e.getTargetIndex());
            result.add(e.getSourceArray());
            result.add(e.getSourceIndex());
            result.add(e.getSize());
            return result;
        }, (e, args) -> {
            e.setTargetArray((WasmExpression)args.get(0));
            e.setTargetIndex((WasmExpression)args.get(1));
            e.setSourceArray((WasmExpression)args.get(2));
            e.setSourceIndex((WasmExpression)args.get(3));
            e.setSize((WasmExpression)args.get(4));
        });
    }

    @Override
    public void visit(WasmFunctionReference expression) {
        this.addExpr(expression);
    }

    @Override
    public void visit(WasmInt31Reference expression) {
        this.visitUnary(expression, WasmInt31Reference::getValue, WasmInt31Reference::setValue);
    }

    @Override
    public void visit(WasmInt31Get expression) {
        this.visitUnary(expression, WasmInt31Get::getValue, WasmInt31Get::setValue);
    }

    @Override
    public void visit(WasmPush expression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(WasmPop expression) {
        throw new UnsupportedOperationException();
    }

    private <T extends WasmExpression> void visitUnary(T expression, Function<T, WasmExpression> getter, BiConsumer<T, WasmExpression> setter) {
        WasmExpression arg = getter.apply(expression);
        if (arg != null && this.collector.isSuspending(arg)) {
            arg.acceptVisitor(this);
            setter.accept(expression, new WasmPop(this.peekType(0)));
            this.popTypes(1);
        }
        this.addExpr(expression);
    }

    private <T extends WasmExpression> void visitBinary(T expression, Function<T, WasmExpression> getter1, BiConsumer<T, WasmExpression> setter1, Function<T, WasmExpression> getter2, BiConsumer<T, WasmExpression> setter2) {
        WasmExpression first = getter1.apply(expression);
        WasmExpression second = getter2.apply(expression);
        if (first == null) {
            if (this.collector.isSuspending(second)) {
                second.acceptVisitor(this);
                setter2.accept(expression, new WasmPop(this.peekType(0)));
                this.popTypes(1);
            }
        } else if (this.collector.isSuspending(second)) {
            first.acceptVisitor(this);
            second.acceptVisitor(this);
            setter1.accept(expression, new WasmPop(this.peekType(1)));
            setter2.accept(expression, new WasmPop(this.peekType(0)));
            this.popTypes(2);
        } else if (this.collector.isSuspending(first)) {
            first.acceptVisitor(this);
            setter1.accept(expression, new WasmPop(this.peekType(0)));
            this.popTypes(1);
        }
        this.addExpr(expression);
    }

    private <T extends WasmExpression> void visitNAry(T expression, Function<T, List<WasmExpression>> getter, BiConsumer<T, List<? extends WasmExpression>> setter) {
        WasmExpression arg;
        int last;
        List<WasmExpression> args = getter.apply(expression);
        for (last = args.size() - 1; !(last <= 0 || (arg = args.get(last)) != null && this.collector.isSuspending(arg)); --last) {
        }
        int depth = 0;
        for (int i = 0; i <= last; ++i) {
            WasmExpression arg2 = args.get(i);
            if (arg2 == null) continue;
            if (this.collector.isSuspending(arg2)) {
                arg2.acceptVisitor(this);
            } else {
                this.addExpr(arg2);
            }
            ++depth;
        }
        int current = depth;
        for (int i = 0; i <= last; ++i) {
            WasmExpression arg3 = args.get(i);
            if (arg3 == null) continue;
            args.set(i, new WasmPop(this.peekType(--current)));
        }
        setter.accept(expression, args);
        this.popTypes(depth);
        this.addExpr(expression);
    }

    private WasmType addExpr(WasmExpression expr) {
        expr.acceptVisitor(this.typeInference);
        this.resultList.add(expr);
        WasmType type = this.typeInference.getSingleResult();
        if (type != null) {
            this.stackTypes.add(type);
        }
        return type;
    }

    private void popTypes(int count) {
        this.stackTypes.subList(this.stackTypes.size() - count, this.stackTypes.size()).clear();
    }

    private WasmType peekType(int depth) {
        return this.stackTypes.get(this.stackTypes.size() - depth - 1);
    }

    private void pushDefault(List<WasmExpression> into, WasmType type) {
        if (type instanceof WasmType.Number) {
            switch (((WasmType.Number)type).number) {
                case INT32: {
                    into.add(new WasmInt32Constant(0));
                    break;
                }
                case INT64: {
                    into.add(new WasmInt64Constant(0L));
                    break;
                }
                case FLOAT32: {
                    into.add(new WasmFloat32Constant(0.0f));
                    break;
                }
                case FLOAT64: {
                    into.add(new WasmFloat64Constant(0.0));
                }
            }
        } else {
            WasmType.Reference ref = (WasmType.Reference)type;
            into.add(new WasmNullConstant(ref));
        }
    }

    private void save(List<WasmExpression> into, WasmType type) {
        into.add(this.functions.saveValue(type, this.fiberLocal, new WasmPop(type)));
    }

    private void restore(List<WasmExpression> into, WasmType type) {
        into.add(this.functions.restoreValue(type, this.fiberLocal));
    }

    private WasmExpression isSuspending() {
        return new WasmCall(this.functions.isSuspending(), new WasmGetLocal(this.fiberLocal));
    }

    private static class SwitchContainer {
        SwitchContainer parent;
        WasmSwitch switchExpr;
        WasmBlock jumpInsideBlock;

        private SwitchContainer() {
        }
    }
}

