/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.runtime.fs;

import java.io.IOException;
import org.teavm.backend.wasm.runtime.WasiBuffer;
import org.teavm.backend.wasm.runtime.fs.WasiVirtualFile;
import org.teavm.backend.wasm.wasi.IOVec;
import org.teavm.backend.wasm.wasi.SizeResult;
import org.teavm.backend.wasm.wasi.Wasi;
import org.teavm.interop.Address;
import org.teavm.interop.Structure;
import org.teavm.runtime.fs.VirtualFileAccessor;

public class WasiVirtualFileAccessor
implements VirtualFileAccessor {
    private WasiVirtualFile file;
    private int fd;

    WasiVirtualFileAccessor(WasiVirtualFile file, int fd) {
        this.file = file;
        this.fd = fd;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        Address buf = WasiBuffer.getBuffer();
        IOVec vec = (IOVec)buf.toStructure();
        vec.buffer = Address.ofData((byte[])buffer).add(offset);
        vec.bufferLength = length;
        SizeResult sizeResult = (SizeResult)Address.align((Address)buf.add(Structure.sizeOf(IOVec.class)), (int)16).toStructure();
        short errno = Wasi.fdRead(this.fd, vec, 1, sizeResult);
        if (errno == 0) {
            return (int)sizeResult.value;
        }
        throw new IOException("fd_read: " + errno);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        short errno;
        block1: {
            int size;
            Address buf = WasiBuffer.getBuffer();
            IOVec vec = (IOVec)buf.toStructure();
            SizeResult sizeResult = (SizeResult)Address.align((Address)buf.add(Structure.sizeOf(IOVec.class)), (int)16).toStructure();
            do {
                vec.buffer = Address.ofData((byte[])buffer).add(offset);
                vec.bufferLength = length;
                errno = Wasi.fdWrite(this.fd, vec, 1, sizeResult);
                if (errno != 0) break block1;
                size = (int)sizeResult.value;
                offset += size;
            } while ((length -= size) > 0);
            return;
        }
        throw new IOException("fd_write: " + errno);
    }

    @Override
    public int tell() throws IOException {
        SizeResult filesize = (SizeResult)WasiBuffer.getBuffer().toStructure();
        short errno = Wasi.fdTell(this.fd, filesize);
        if (errno == 0) {
            return (int)filesize.value;
        }
        throw new IOException("fd_tell: " + errno);
    }

    private long seek(long offset, byte whence) throws IOException {
        SizeResult filesize = (SizeResult)WasiBuffer.getBuffer().toStructure();
        short errno = Wasi.fdSeek(this.fd, offset, whence, filesize);
        if (errno == 0) {
            return filesize.value;
        }
        throw new IOException("fd_seek: " + errno);
    }

    @Override
    public void skip(int amount) throws IOException {
        this.seek(amount, (byte)1);
    }

    @Override
    public void seek(int target) throws IOException {
        this.seek(target, (byte)0);
    }

    @Override
    public int size() throws IOException {
        return (int)this.file.stat().filesize;
    }

    @Override
    public void resize(int size) throws IOException {
        short errno = Wasi.fdFilestatSetSize(this.fd, size);
        if (errno != 0) {
            throw new IOException("fd_filestat_set_size" + errno);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fd >= 0) {
            int fd = this.fd;
            this.fd = -1;
            short errno = Wasi.fdClose(fd);
            if (errno != 0) {
                throw new IOException("fd_close: " + errno);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        short errno = Wasi.fdSync(this.fd);
        if (errno != 0) {
            throw new IOException("fd_sync: " + errno);
        }
    }
}

