/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.optimization;

import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmBlockType;
import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmCompositeTypeVisitor;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmCastBranch;
import org.teavm.backend.wasm.model.expression.WasmDefaultExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmTest;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;

public class WasmUsageCounter
extends WasmDefaultExpressionVisitor
implements WasmCompositeTypeVisitor {
    private ObjectIntMap<WasmFunction> usagesByFunction = new ObjectIntHashMap();
    private ObjectIntMap<WasmGlobal> usagesByGlobals = new ObjectIntHashMap();
    private ObjectIntMap<WasmCompositeType> usagesByTypes = new ObjectIntHashMap();

    public void applyToModule(WasmModule module) {
        for (WasmCompositeType type : module.types) {
            type.acceptVisitor(this);
        }
        for (WasmFunction function : module.functions) {
            for (WasmExpression part : function.getBody()) {
                part.acceptVisitor(this);
            }
            this.addUsage(function.getType());
        }
        for (WasmGlobal global : module.globals) {
            global.getInitialValue().acceptVisitor(this);
            this.addUsage(global.getType());
        }
    }

    public int usages(WasmFunction function) {
        return this.usagesByFunction.get((Object)function);
    }

    public int usages(WasmGlobal global) {
        return this.usagesByGlobals.get((Object)global);
    }

    public int usages(WasmCompositeType type) {
        return this.usagesByTypes.get((Object)type);
    }

    @Override
    public void visit(WasmStructure type) {
        for (WasmField field : type.getFields()) {
            this.addUsage(field.getUnpackedType());
        }
    }

    @Override
    public void visit(WasmArray type) {
        this.addUsage(type.getElementType().asUnpackedType());
    }

    @Override
    public void visit(WasmFunctionType type) {
        for (WasmType wasmType : type.getReturnTypes()) {
            this.addUsage(wasmType);
        }
        for (WasmType wasmType : type.getParameterTypes()) {
            this.addUsage(wasmType);
        }
    }

    @Override
    public void visit(WasmCall expression) {
        super.visit(expression);
        this.addUsage(expression.getFunction());
    }

    @Override
    public void visit(WasmFunctionReference expression) {
        super.visit(expression);
        this.addUsage(expression.getFunction());
    }

    @Override
    public void visit(WasmGetGlobal expression) {
        super.visit(expression);
        this.addUsage(expression.getGlobal());
    }

    @Override
    public void visit(WasmSetGlobal expression) {
        super.visit(expression);
        this.addUsage(expression.getGlobal());
    }

    @Override
    public void visit(WasmBlock expression) {
        super.visit(expression);
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmCastBranch expression) {
        super.visit(expression);
        this.addUsage(expression.getSourceType());
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmCallReference expression) {
        super.visit(expression);
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        super.visit(expression);
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmCast expression) {
        super.visit(expression);
        this.addUsage(expression.getTargetType());
    }

    @Override
    public void visit(WasmTest expression) {
        super.visit(expression);
        this.addUsage(expression.getTestType());
    }

    @Override
    public void visit(WasmStructNew expression) {
        super.visit(expression);
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmStructNewDefault expression) {
        super.visit(expression);
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmStructGet expression) {
        super.visit(expression);
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmStructSet expression) {
        super.visit(expression);
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmArrayNewDefault expression) {
        super.visit(expression);
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmArrayNewFixed expression) {
        super.visit(expression);
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmArrayGet expression) {
        super.visit(expression);
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmArraySet expression) {
        super.visit(expression);
        this.addUsage(expression.getType());
    }

    @Override
    public void visit(WasmArrayCopy expression) {
        super.visit(expression);
        this.addUsage(expression.getSourceArrayType());
        this.addUsage(expression.getTargetArrayType());
    }

    private void addUsage(WasmBlockType type) {
        if (type == null) {
            return;
        }
        if (type instanceof WasmBlockType.Function) {
            this.addUsage(((WasmBlockType.Function)type).ref);
        } else {
            this.addUsage(((WasmBlockType.Value)type).type);
        }
    }

    private void addUsage(WasmType type) {
        if (type instanceof WasmType.CompositeReference) {
            this.addUsage(((WasmType.CompositeReference)type).composite);
        }
    }

    private void addUsage(WasmFunction function) {
        int index = this.usagesByFunction.indexOf((Object)function);
        if (index < 0) {
            this.usagesByFunction.put((Object)function, 1);
        } else {
            this.usagesByFunction.indexReplace(index, this.usagesByFunction.indexGet(index) + 1);
        }
    }

    private void addUsage(WasmGlobal function) {
        int index = this.usagesByGlobals.indexOf((Object)function);
        if (index < 0) {
            this.usagesByGlobals.put((Object)function, 1);
        } else {
            this.usagesByGlobals.indexReplace(index, this.usagesByGlobals.indexGet(index) + 1);
        }
    }

    private void addUsage(WasmCompositeType type) {
        int index = this.usagesByTypes.indexOf((Object)type);
        if (index < 0) {
            this.usagesByTypes.put((Object)type, 1);
        } else {
            this.usagesByTypes.indexReplace(index, this.usagesByTypes.indexGet(index) + 1);
        }
    }
}

