/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import java.util.List;
import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmCastBranch;
import org.teavm.backend.wasm.model.expression.WasmCatch;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmCopy;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmExternConversion;
import org.teavm.backend.wasm.model.expression.WasmFill;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatUnary;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt31Get;
import org.teavm.backend.wasm.model.expression.WasmInt31Reference;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIsNull;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmMemoryGrow;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmPop;
import org.teavm.backend.wasm.model.expression.WasmPush;
import org.teavm.backend.wasm.model.expression.WasmReferencesEqual;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmTest;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmTry;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;

public class WasmDefaultExpressionVisitor
implements WasmExpressionVisitor {
    @Override
    public void visit(WasmBlock expression) {
        this.visitMany(expression.getBody());
    }

    @Override
    public void visit(WasmBranch expression) {
        this.visitDefault(expression.getCondition());
        if (expression.getResult() != null) {
            this.visitDefault(expression.getResult());
        }
    }

    @Override
    public void visit(WasmNullBranch expression) {
        this.visitDefault(expression.getValue());
        if (expression.getResult() != null) {
            this.visitDefault(expression.getResult());
        }
    }

    @Override
    public void visit(WasmCastBranch expression) {
        this.visitDefault(expression.getValue());
        if (expression.getResult() != null) {
            this.visitDefault(expression.getResult());
        }
    }

    @Override
    public void visit(WasmBreak expression) {
        if (expression.getResult() != null) {
            this.visitDefault(expression.getResult());
        }
    }

    @Override
    public void visit(WasmSwitch expression) {
        this.visitDefault(expression.getSelector());
    }

    @Override
    public void visit(WasmConditional expression) {
        this.visitDefault(expression.getCondition());
        this.visitMany(expression.getThenBlock().getBody());
        this.visitMany(expression.getElseBlock().getBody());
    }

    @Override
    public void visit(WasmReturn expression) {
        if (expression.getValue() != null) {
            this.visitDefault(expression.getValue());
        }
    }

    @Override
    public void visit(WasmUnreachable expression) {
    }

    @Override
    public void visit(WasmInt32Constant expression) {
    }

    @Override
    public void visit(WasmInt64Constant expression) {
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
    }

    @Override
    public void visit(WasmNullConstant expression) {
    }

    @Override
    public void visit(WasmIsNull expression) {
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmGetLocal expression) {
    }

    @Override
    public void visit(WasmSetLocal expression) {
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmGetGlobal expression) {
    }

    @Override
    public void visit(WasmSetGlobal expression) {
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmIntBinary expression) {
        this.visitDefault(expression.getFirst());
        this.visitDefault(expression.getSecond());
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        this.visitDefault(expression.getFirst());
        this.visitDefault(expression.getSecond());
    }

    @Override
    public void visit(WasmIntUnary expression) {
        this.visitDefault(expression.getOperand());
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        this.visitDefault(expression.getOperand());
    }

    @Override
    public void visit(WasmConversion expression) {
        this.visitDefault(expression.getOperand());
    }

    @Override
    public void visit(WasmCall expression) {
        this.visitMany(expression.getArguments());
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        this.visitDefault(expression.getSelector());
        this.visitMany(expression.getArguments());
    }

    @Override
    public void visit(WasmCallReference expression) {
        this.visitDefault(expression.getFunctionReference());
        this.visitMany(expression.getArguments());
    }

    @Override
    public void visit(WasmDrop expression) {
        this.visitDefault(expression.getOperand());
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        this.visitDefault(expression.getIndex());
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        this.visitDefault(expression.getIndex());
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        this.visitDefault(expression.getIndex());
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        this.visitDefault(expression.getIndex());
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        this.visitDefault(expression.getIndex());
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        this.visitDefault(expression.getIndex());
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        this.visitDefault(expression.getIndex());
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        this.visitDefault(expression.getIndex());
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmMemoryGrow expression) {
        this.visitDefault(expression.getAmount());
    }

    @Override
    public void visit(WasmFill expression) {
        this.visitDefault(expression.getIndex());
        this.visitDefault(expression.getValue());
        this.visitDefault(expression.getCount());
    }

    @Override
    public void visit(WasmCopy expression) {
        this.visitDefault(expression.getDestinationIndex());
        this.visitDefault(expression.getSourceIndex());
        this.visitDefault(expression.getCount());
    }

    @Override
    public void visit(WasmTry expression) {
        this.visitMany(expression.getBody());
        for (WasmCatch catchClause : expression.getCatches()) {
            this.visitMany(catchClause.getBody());
        }
    }

    @Override
    public void visit(WasmThrow expression) {
        this.visitMany(expression.getArguments());
    }

    @Override
    public void visit(WasmReferencesEqual expression) {
        this.visitDefault(expression.getFirst());
        this.visitDefault(expression.getSecond());
    }

    @Override
    public void visit(WasmCast expression) {
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmTest expression) {
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmExternConversion expression) {
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmStructNew expression) {
        this.visitMany(expression.getInitializers());
    }

    @Override
    public void visit(WasmStructNewDefault expression) {
    }

    @Override
    public void visit(WasmStructGet expression) {
        this.visitDefault(expression.getInstance());
    }

    @Override
    public void visit(WasmStructSet expression) {
        this.visitDefault(expression.getInstance());
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmArrayNewDefault expression) {
        this.visitDefault(expression.getLength());
    }

    @Override
    public void visit(WasmArrayNewFixed expression) {
        this.visitMany(expression.getElements());
    }

    @Override
    public void visit(WasmArrayGet expression) {
        this.visitDefault(expression.getInstance());
        this.visitDefault(expression.getIndex());
    }

    @Override
    public void visit(WasmArraySet expression) {
        this.visitDefault(expression.getInstance());
        this.visitDefault(expression.getIndex());
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmArrayLength expression) {
        this.visitDefault(expression.getInstance());
    }

    @Override
    public void visit(WasmArrayCopy expression) {
        this.visitDefault(expression.getTargetArray());
        this.visitDefault(expression.getTargetIndex());
        this.visitDefault(expression.getSourceArray());
        this.visitDefault(expression.getSourceIndex());
        this.visitDefault(expression.getSize());
    }

    @Override
    public void visit(WasmFunctionReference expression) {
    }

    @Override
    public void visit(WasmInt31Reference expression) {
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmInt31Get expression) {
        this.visitDefault(expression.getValue());
    }

    @Override
    public void visit(WasmPush expression) {
        this.visitDefault(expression.getArgument());
    }

    @Override
    public void visit(WasmPop expression) {
    }

    public void visitMany(List<WasmExpression> expressions) {
        for (WasmExpression expression : expressions) {
            this.visitDefault(expression);
        }
    }

    public void visitDefault(WasmExpression expression) {
        expression.acceptVisitor(this);
    }
}

