/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.model.MethodReference;
import org.teavm.runtime.RuntimeClass;

public class RuntimeClassIntrinsic
implements WasmIntrinsic {
    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (!methodReference.getClassName().equals(RuntimeClass.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "pack": 
            case "unpack": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "pack": {
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_UNSIGNED, manager.generate(invocation.getArguments().get(0)), new WasmInt32Constant(3));
            }
            case "unpack": {
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, manager.generate(invocation.getArguments().get(0)), new WasmInt32Constant(3));
            }
        }
        throw new AssertionError();
    }
}

