/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generators.gc;

import org.teavm.backend.wasm.generators.gc.WasmGCCustomGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorContext;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.model.MethodReference;
import org.teavm.runtime.EventQueue;

public class EventQueueGenerator
implements WasmGCCustomGenerator {
    @Override
    public void apply(MethodReference method, WasmFunction function, WasmGCCustomGeneratorContext context) {
        WasmType.CompositeReference eventType = context.classInfoProvider().getClassInfo(EventQueue.Event.class.getName()).getType();
        WasmFunctionType eventCallbackType = context.functionTypes().of(null, eventType);
        WasmFunction runtimeFn = new WasmFunction(context.functionTypes().of(WasmType.INT32, eventType, eventCallbackType.getReference(), WasmType.FLOAT64));
        runtimeFn.setName(context.names().topLevel("teavmAsync.offer"));
        runtimeFn.setImportModule("teavmAsync");
        runtimeFn.setImportName("offer");
        context.module().functions.add(runtimeFn);
        WasmFunction callerFn = context.functions().forStaticMethod(new MethodReference(EventQueue.class, "run", EventQueue.Event.class, Void.TYPE));
        callerFn.setReferenced(true);
        WasmLocal eventVar = new WasmLocal(eventType, "event");
        WasmLocal timeVar = new WasmLocal(WasmType.FLOAT64, "time");
        function.add(eventVar);
        function.add(timeVar);
        WasmCall call = new WasmCall(runtimeFn, new WasmGetLocal(eventVar), new WasmFunctionReference(callerFn), new WasmGetLocal(timeVar));
        function.getBody().add(call);
    }
}

