/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generators;

import java.lang.reflect.Array;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.generators.WasmMethodGenerator;
import org.teavm.backend.wasm.generators.WasmMethodGeneratorContext;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmInt64Subtype;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.model.ClassReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;

public class ArrayGenerator
implements WasmMethodGenerator {
    private static FieldReference componentField = new FieldReference(RuntimeClass.class.getName(), "itemType");
    private static FieldReference flagsField = new FieldReference(RuntimeClass.class.getName(), "flags");
    private static final String[] primitiveWrappers = new String[]{"Byte", "Short", "Character", "Integer", "Long", "Float", "Double", "Boolean"};
    private static final ValueType.Primitive[] primitiveTypes = new ValueType.Primitive[]{ValueType.BYTE, ValueType.SHORT, ValueType.CHARACTER, ValueType.INTEGER, ValueType.LONG, ValueType.FLOAT, ValueType.DOUBLE, ValueType.BOOLEAN};
    private static final int[] shift = new int[]{0, 0, 1, 1, 2, 3, 2, 3, 0};

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (!methodReference.getClassName().equals(Array.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "getImpl": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(MethodReference method, WasmFunction function, WasmMethodGeneratorContext context) {
        int i;
        WasmLocal arrayVar = new WasmLocal(WasmType.INT32, "_array");
        WasmLocal indexVar = new WasmLocal(WasmType.INT32, "_index");
        WasmLocal flagsVar = new WasmLocal(WasmType.INT32, "_flags");
        function.add(arrayVar);
        function.add(indexVar);
        function.add(flagsVar);
        WasmExpression arrayClass = new WasmLoadInt32(4, new WasmGetLocal(arrayVar), WasmInt32Subtype.INT32);
        arrayClass = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, arrayClass, new WasmInt32Constant(3));
        int componentOffset = context.getClassGenerator().getFieldOffset(componentField);
        WasmLoadInt32 componentClass = new WasmLoadInt32(4, arrayClass, WasmInt32Subtype.INT32, componentOffset);
        int flagsOffset = context.getClassGenerator().getFieldOffset(flagsField);
        WasmLoadInt32 flags = new WasmLoadInt32(4, componentClass, WasmInt32Subtype.INT32, flagsOffset);
        function.getBody().add(new WasmSetLocal(flagsVar, flags));
        WasmIntBinary isPrimitive = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.AND, new WasmGetLocal(flagsVar), new WasmInt32Constant(2));
        WasmBlock objectBlock = new WasmBlock(false);
        objectBlock.getBody().add(new WasmBranch(isPrimitive, objectBlock));
        function.getBody().add(objectBlock);
        int base = context.getClassGenerator().getClassSize(RuntimeArray.class.getName());
        WasmBlock currentBlock = new WasmBlock(false);
        function.getBody().add(currentBlock);
        function.getBody().add(new WasmReturn(new WasmInt32Constant(0)));
        WasmIntBinary primitiveExpr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_UNSIGNED, new WasmGetLocal(flagsVar), new WasmInt32Constant(2));
        primitiveExpr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, new WasmGetLocal(flagsVar), new WasmInt32Constant(15));
        WasmSwitch primitiveSwitch = new WasmSwitch(primitiveExpr, currentBlock);
        for (i = 0; i <= 8; ++i) {
            primitiveSwitch.getTargets().add(currentBlock);
        }
        for (i = 0; i < primitiveWrappers.length; ++i) {
            MethodReader valueOfMethod;
            String wrapper = "java.lang." + primitiveWrappers[i];
            MethodReference methodRef = new MethodReference(wrapper, "valueOf", primitiveTypes[i], ValueType.object(wrapper));
            ClassReader cls = context.getClassSource().get(methodRef.getClassName());
            if (cls == null || (valueOfMethod = cls.getMethod(methodRef.getDescriptor())) == null || valueOfMethod.getProgram() == null) continue;
            WasmBlock nextBlock = new WasmBlock(false);
            primitiveSwitch.getTargets().set(i, nextBlock);
            WasmExpression offset = new WasmGetLocal(indexVar);
            if (shift[i] != 0) {
                offset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, new WasmGetLocal(indexVar), new WasmInt32Constant(shift[i]));
            }
            offset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, offset, new WasmGetLocal(arrayVar));
            int baseAddr = BinaryWriter.align(base, 1 << shift[i]);
            WasmCall call = new WasmCall(context.getFunctions().forStaticMethod(methodRef));
            switch (primitiveTypes[i].getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    call.getArguments().add(new WasmLoadInt32(0, offset, WasmInt32Subtype.INT8, baseAddr));
                    break;
                }
                case SHORT: {
                    call.getArguments().add(new WasmLoadInt32(1, offset, WasmInt32Subtype.INT16, baseAddr));
                    break;
                }
                case CHARACTER: {
                    call.getArguments().add(new WasmLoadInt32(1, offset, WasmInt32Subtype.UINT16, baseAddr));
                    break;
                }
                case INTEGER: {
                    call.getArguments().add(new WasmLoadInt32(2, offset, WasmInt32Subtype.INT16, baseAddr));
                    break;
                }
                case LONG: {
                    call.getArguments().add(new WasmLoadInt64(3, offset, WasmInt64Subtype.INT64, baseAddr));
                    break;
                }
                case FLOAT: {
                    call.getArguments().add(new WasmLoadFloat32(2, offset, baseAddr));
                    break;
                }
                case DOUBLE: {
                    call.getArguments().add(new WasmLoadFloat64(3, offset, baseAddr));
                }
            }
            currentBlock.getBody().add(nextBlock);
            currentBlock.getBody().add(new WasmReturn(call));
            currentBlock = nextBlock;
        }
        currentBlock.getBody().add(primitiveSwitch);
        WasmIntBinary objectOffset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, new WasmGetLocal(indexVar), new WasmInt32Constant(2));
        objectOffset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, objectOffset, new WasmGetLocal(arrayVar));
        objectBlock.getBody().add(new WasmReturn(new WasmLoadInt32(4, objectOffset, WasmInt32Subtype.INT32, BinaryWriter.align(base, 4))));
    }
}

