/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.methods;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teavm.ast.RegularMethodNode;
import org.teavm.ast.VariableNode;
import org.teavm.ast.decompilation.Decompiler;
import org.teavm.backend.wasm.BaseWasmFunctionRepository;
import org.teavm.backend.wasm.WasmFunctionTypes;
import org.teavm.backend.wasm.gc.PreciseTypeInference;
import org.teavm.backend.wasm.gc.PreciseValueType;
import org.teavm.backend.wasm.gc.WasmGCVariableCategoryProvider;
import org.teavm.backend.wasm.gc.vtable.WasmGCVirtualTableProvider;
import org.teavm.backend.wasm.generate.gc.WasmGCInitializerContributor;
import org.teavm.backend.wasm.generate.gc.WasmGCNameProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCStandardClasses;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCSupertypeFunctionProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCTypeMapper;
import org.teavm.backend.wasm.generate.gc.methods.NonNullVarsCalculator;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCCustomGeneratorProvider;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationContext;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationVisitor;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCIntrinsicProvider;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringProvider;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorContext;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmTag;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmCatch;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmTry;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.backend.wasm.transformation.gc.CoroutineTransformation;
import org.teavm.dependency.DependencyInfo;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.Async;
import org.teavm.interop.Import;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ElementModifier;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.analysis.ClassInitializerInfo;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.util.InstructionVariableMapper;
import org.teavm.model.util.RegisterAllocator;
import org.teavm.model.util.UsageExtractor;
import org.teavm.parsing.resource.ResourceProvider;

public class WasmGCMethodGenerator
implements BaseWasmFunctionRepository {
    private WasmModule module;
    private ClassHierarchy hierarchy;
    private ListableClassHolderSource classes;
    private ResourceProvider resources;
    private ClassLoader classLoader;
    private WasmGCVirtualTableProvider virtualTables;
    private ClassInitializerInfo classInitInfo;
    private WasmFunctionTypes functionTypes;
    private WasmGCSupertypeFunctionProvider supertypeFunctions;
    public final WasmGCNameProvider names;
    private Diagnostics diagnostics;
    private WasmGCTypeMapper typeMapper;
    private WasmGCCustomGeneratorProvider customGenerators;
    private WasmGCIntrinsicProvider intrinsics;
    private Queue<Runnable> queue = new ArrayDeque<Runnable>();
    private Map<MethodReference, WasmFunction> staticMethods = new HashMap<MethodReference, WasmFunction>();
    private Map<MethodReference, WasmFunction> instanceMethods = new HashMap<MethodReference, WasmFunction>();
    private boolean friendlyToDebugger;
    private Decompiler decompiler;
    private WasmGCGenerationContext context;
    private WasmFunction dummyInitializer;
    private WasmGCClassInfoProvider classInfoProvider;
    private WasmGCStandardClasses standardClasses;
    private WasmGCStringProvider strings;
    private boolean strict;
    private String entryPoint;
    private Consumer<WasmGCInitializerContributor> initializerContributors;
    private boolean compactMode;
    private DependencyInfo dependency;
    private Set<MethodReference> asyncMethods = Set.of();
    private Set<MethodReference> asyncSplitMethods = Set.of();
    private CoroutineTransformation coroutineTransformation;
    private WasmGCCustomGeneratorContext customGeneratorContext = new WasmGCCustomGeneratorContext(){

        @Override
        public ClassLoader classLoader() {
            return WasmGCMethodGenerator.this.classLoader;
        }

        @Override
        public ListableClassReaderSource classes() {
            return WasmGCMethodGenerator.this.classes;
        }

        @Override
        public WasmModule module() {
            return WasmGCMethodGenerator.this.module;
        }

        @Override
        public WasmFunctionTypes functionTypes() {
            return WasmGCMethodGenerator.this.functionTypes;
        }

        @Override
        public WasmGCTypeMapper typeMapper() {
            return WasmGCMethodGenerator.this.typeMapper;
        }

        @Override
        public WasmGCClassInfoProvider classInfoProvider() {
            return WasmGCMethodGenerator.this.classInfoProvider;
        }

        @Override
        public WasmGCNameProvider names() {
            return WasmGCMethodGenerator.this.names;
        }

        @Override
        public WasmTag exceptionTag() {
            return WasmGCMethodGenerator.this.context.getExceptionTag();
        }

        @Override
        public BaseWasmFunctionRepository functions() {
            return WasmGCMethodGenerator.this;
        }

        @Override
        public Diagnostics diagnostics() {
            return WasmGCMethodGenerator.this.diagnostics;
        }

        @Override
        public WasmGCStringProvider strings() {
            return WasmGCMethodGenerator.this.context.strings();
        }

        @Override
        public WasmGCVirtualTableProvider virtualTables() {
            return WasmGCMethodGenerator.this.context.virtualTables();
        }

        @Override
        public String entryPoint() {
            return WasmGCMethodGenerator.this.context.entryPoint();
        }

        @Override
        public boolean isCompactMode() {
            return WasmGCMethodGenerator.this.compactMode;
        }

        @Override
        public void addToInitializer(Consumer<WasmFunction> initializerContributor) {
            WasmGCMethodGenerator.this.context.addToInitializer(initializerContributor);
        }
    };

    public WasmGCMethodGenerator(WasmModule module, ClassHierarchy hierarchy, ListableClassHolderSource classes, ResourceProvider resources, ClassLoader classLoader, WasmGCVirtualTableProvider virtualTables, ClassInitializerInfo classInitInfo, WasmFunctionTypes functionTypes, WasmGCNameProvider names, Diagnostics diagnostics, WasmGCCustomGeneratorProvider customGenerators, WasmGCIntrinsicProvider intrinsics, DependencyInfo dependency, boolean strict, String entryPoint, Consumer<WasmGCInitializerContributor> initializerContributors) {
        this.module = module;
        this.hierarchy = hierarchy;
        this.classes = classes;
        this.resources = resources;
        this.classLoader = classLoader;
        this.virtualTables = virtualTables;
        this.classInitInfo = classInitInfo;
        this.functionTypes = functionTypes;
        this.names = names;
        this.diagnostics = diagnostics;
        this.customGenerators = customGenerators;
        this.intrinsics = intrinsics;
        this.dependency = dependency;
        this.strict = strict;
        this.entryPoint = entryPoint;
        this.initializerContributors = initializerContributors;
    }

    public void setAsyncMethods(Set<MethodReference> asyncMethods) {
        this.asyncMethods = asyncMethods;
    }

    public void setAsyncSplitMethods(Set<MethodReference> asyncSplitMethods) {
        this.asyncSplitMethods = asyncSplitMethods;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    public void setTypeMapper(WasmGCTypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public void setFriendlyToDebugger(boolean friendlyToDebugger) {
        this.friendlyToDebugger = friendlyToDebugger;
    }

    public void setClassInfoProvider(WasmGCClassInfoProvider classInfoProvider) {
        this.classInfoProvider = classInfoProvider;
    }

    public void setStandardClasses(WasmGCStandardClasses standardClasses) {
        this.standardClasses = standardClasses;
    }

    public void setSupertypeFunctions(WasmGCSupertypeFunctionProvider supertypeFunctions) {
        this.supertypeFunctions = supertypeFunctions;
    }

    public void setStrings(WasmGCStringProvider strings) {
        this.strings = strings;
    }

    public boolean process() {
        if (this.queue.isEmpty()) {
            return false;
        }
        while (!this.queue.isEmpty()) {
            this.queue.remove().run();
        }
        return true;
    }

    public boolean hasSomethingToGenerate() {
        return !this.queue.isEmpty();
    }

    @Override
    public WasmFunction forStaticMethod(MethodReference methodReference) {
        return this.staticMethods.computeIfAbsent(methodReference, this::createStaticFunction);
    }

    private WasmFunction createStaticFunction(MethodReference methodReference) {
        MethodHolder method;
        WasmType returnType = this.typeMapper.mapType(methodReference.getReturnType());
        WasmType[] parameterTypes = new WasmType[methodReference.parameterCount()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = this.typeMapper.mapType(methodReference.parameterType(i));
        }
        WasmFunction function = new WasmFunction(this.functionTypes.of(returnType, parameterTypes));
        function.setName(this.names.topLevel(this.names.suggestForMethod(methodReference)));
        this.module.functions.add(function);
        function.setJavaMethod(methodReference);
        ClassHolder cls = this.classes.get(methodReference.getClassName());
        if (cls != null && (method = cls.getMethod(methodReference.getDescriptor())) != null && method.hasModifier(ElementModifier.STATIC)) {
            this.queue.add(() -> this.generateMethodBody(method, function));
        }
        return function;
    }

    @Override
    public WasmFunction forInstanceMethod(MethodReference methodReference) {
        return this.instanceMethods.computeIfAbsent(methodReference, this::createInstanceFunction);
    }

    private WasmFunction createInstanceFunction(MethodReference methodReference) {
        MethodHolder method;
        WasmType returnType = this.typeMapper.mapType(methodReference.getReturnType());
        WasmType[] parameterTypes = new WasmType[methodReference.parameterCount() + 1];
        boolean compactMethod = this.compactMode && this.typeMapper.mapType(ValueType.object(methodReference.getClassName())) instanceof WasmType.Reference;
        parameterTypes[0] = compactMethod ? WasmType.Reference.ANY : this.typeMapper.mapType(ValueType.object(methodReference.getClassName()));
        for (int i = 0; i < methodReference.parameterCount(); ++i) {
            parameterTypes[i + 1] = this.typeMapper.mapType(methodReference.parameterType(i));
        }
        WasmFunction function = new WasmFunction(this.functionTypes.of(returnType, parameterTypes));
        function.setName(this.names.topLevel(this.names.suggestForMethod(methodReference)));
        this.module.functions.add(function);
        function.setJavaMethod(methodReference);
        ClassHolder cls = this.classes.get(methodReference.getClassName());
        if (cls != null && (method = cls.getMethod(methodReference.getDescriptor())) != null && !method.hasModifier(ElementModifier.STATIC)) {
            this.queue.add(() -> this.generateMethodBody(method, function));
        }
        return function;
    }

    private void generateMethodBody(MethodHolder method, WasmFunction function) {
        try {
            WasmGCCustomGenerator customGenerator = this.customGenerators.get(method.getReference());
            if (customGenerator != null) {
                this.generateCustomMethodBody(customGenerator, method.getReference(), function);
            } else if (!method.hasModifier(ElementModifier.NATIVE)) {
                this.generateRegularMethodBody(method, function);
            } else {
                this.generateNativeMethodBody(method, function);
            }
        }
        catch (RuntimeException e) {
            StringWriter buffer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(buffer);
            e.printStackTrace(printWriter);
            this.diagnostics.error(new CallLocation(method.getReference()), "Failed generating method body due to internal exception: " + String.valueOf(buffer), new Object[0]);
            function.getBody().clear();
            function.getBody().add(new WasmUnreachable());
        }
    }

    private void generateCustomMethodBody(WasmGCCustomGenerator customGenerator, MethodReference method, WasmFunction function) {
        customGenerator.apply(method, function, this.customGeneratorContext);
        boolean isSuspend = this.asyncMethods.contains(method);
        if (isSuspend) {
            if (this.coroutineTransformation == null) {
                this.coroutineTransformation = new CoroutineTransformation(this.functionTypes, this, this.classInfoProvider);
            }
            this.coroutineTransformation.transform(function);
        }
    }

    private void generateRegularMethodBody(MethodHolder method, WasmFunction function) {
        PreciseValueType inferredType;
        int i;
        int varNodeIndex;
        Variable variable;
        int i2;
        Objects.requireNonNull(method.getProgram());
        this.eliminateMultipleNullConstantUsages(method.getProgram());
        Decompiler decompiler = this.getDecompiler();
        WasmGCVariableCategoryProvider categoryProvider = new WasmGCVariableCategoryProvider(this.hierarchy);
        boolean methodCompact = this.compactMode && !method.hasModifier(ElementModifier.STATIC) && this.typeMapper.mapType(ValueType.object(method.getOwnerName())) instanceof WasmType.Reference;
        categoryProvider.setCompactMode(methodCompact);
        RegisterAllocator allocator = new RegisterAllocator(categoryProvider);
        allocator.allocateRegisters(method.getReference(), method.getProgram(), this.friendlyToDebugger);
        RegularMethodNode ast = decompiler.decompileRegular(method);
        int firstVar = method.hasModifier(ElementModifier.STATIC) ? 1 : 0;
        PreciseTypeInference typeInference = new PreciseTypeInference(method.getProgram(), method.getReference(), this.hierarchy);
        typeInference.setPhisSkipped(true);
        typeInference.setBackPropagation(true);
        typeInference.ensure();
        int registerCount = 0;
        for (int i3 = 0; i3 < method.getProgram().variableCount(); ++i3) {
            registerCount = Math.max(registerCount, method.getProgram().variableAt(i3).getRegister() + 1);
        }
        int[] originalIndexToIndex = new int[registerCount];
        Arrays.fill(originalIndexToIndex, -1);
        for (VariableNode varNode : ast.getVariables()) {
            originalIndexToIndex[varNode.getOriginalIndex()] = varNode.getIndex();
        }
        int[] variableRepresentatives = new int[registerCount];
        Arrays.fill(variableRepresentatives, -1);
        for (i2 = 0; i2 < method.getProgram().variableCount(); ++i2) {
            variable = method.getProgram().variableAt(i2);
            int n = varNodeIndex = variable.getRegister() >= 0 ? originalIndexToIndex[variable.getRegister()] : -1;
            if (varNodeIndex < 0 || variableRepresentatives[varNodeIndex] >= 0 || typeInference.typeOf(variable) == null) continue;
            variableRepresentatives[varNodeIndex] = variable.getIndex();
        }
        for (i2 = 0; i2 < method.getProgram().variableCount(); ++i2) {
            variable = method.getProgram().variableAt(i2);
            int n = varNodeIndex = variable.getRegister() >= 0 ? originalIndexToIndex[variable.getRegister()] : -1;
            if (varNodeIndex < 0 || variableRepresentatives[varNodeIndex] >= 0) continue;
            variableRepresentatives[varNodeIndex] = variable.getIndex();
        }
        boolean[] nonNullableVars = new boolean[ast.getVariables().size()];
        PreciseValueType[] preciseTypes = new PreciseValueType[ast.getVariables().size()];
        boolean isSuspend = this.asyncMethods.contains(method.getReference()) && method.getAnnotations().get(Async.class.getName()) == null;
        for (i = firstVar; i < ast.getVariables().size(); ++i) {
            Variable representative = method.getProgram().variableAt(variableRepresentatives[i]);
            inferredType = (PreciseValueType)typeInference.typeOf(representative);
            if (inferredType == null) {
                inferredType = new PreciseValueType(ValueType.object("java.lang.Object"), false);
            }
            preciseTypes[i] = inferredType;
            nonNullableVars[i] = !isSuspend && inferredType.isArrayUnwrap;
        }
        if (!isSuspend) {
            this.calculateNonNullableVars(nonNullableVars, ast);
        }
        for (i = firstVar; i < ast.getVariables().size(); ++i) {
            WasmType type;
            VariableNode localVar = ast.getVariables().get(i);
            inferredType = preciseTypes[i];
            if (i == 0 && this.compactMode) {
                type = WasmType.Reference.ANY;
            } else if (!inferredType.isArrayUnwrap || inferredType.valueType == null) {
                type = this.typeMapper.mapType(inferredType.valueType);
            } else {
                WasmArray arrayType = this.classInfoProvider.getClassInfo(inferredType.valueType).getArray();
                type = nonNullableVars[i] ? arrayType.getNonNullReference() : arrayType.getReference();
            }
            WasmLocal wasmLocal = new WasmLocal(type, localVar.getName());
            function.add(wasmLocal);
        }
        this.addInitializerErase(method, function);
        WasmGCGenerationVisitor visitor = new WasmGCGenerationVisitor(this.getGenerationContext(), method.getReference(), function, firstVar, isSuspend, typeInference, this.asyncSplitMethods);
        visitor.setCompactMode(methodCompact);
        List<WasmExpression> target = function.getBody();
        target = this.wrapSynchronizedMethod(method, visitor, function, target);
        visitor.generate(ast.getBody(), target);
        if (isSuspend) {
            if (this.coroutineTransformation == null) {
                this.coroutineTransformation = new CoroutineTransformation(this.functionTypes, this, this.classInfoProvider);
            }
            this.coroutineTransformation.transform(function);
        }
    }

    private List<WasmExpression> wrapSynchronizedMethod(MethodHolder method, WasmGCGenerationVisitor visitor, WasmFunction function, List<WasmExpression> target) {
        if (!method.hasModifier(ElementModifier.SYNCHRONIZED)) {
            return target;
        }
        Supplier<WasmExpression> obj = method.hasModifier(ElementModifier.STATIC) ? () -> new WasmGetGlobal(this.context.classInfoProvider().getClassInfo(method.getOwnerName()).getPointer()) : () -> new WasmGetLocal(function.getLocalVariables().get(0));
        visitor.monitorEnter(obj.get(), null, target);
        WasmBlock returnBlock = new WasmBlock(false);
        returnBlock.setType(this.context.functionTypes().blockType(function.getType().getReturnTypes()));
        target.add(returnBlock);
        WasmTry tryCatch = new WasmTry();
        tryCatch.setType(function.getType().getSingleReturnType());
        returnBlock.getBody().add(tryCatch);
        WasmCatch catchClause = new WasmCatch(this.context.getExceptionTag());
        WasmLocal catchVar = new WasmLocal(this.context.classInfoProvider().getClassInfo("java.lang.Throwable").getType());
        catchClause.getCatchVariables().add(catchVar);
        function.add(catchVar);
        visitor.monitorExit(obj.get(), null, catchClause.getBody());
        WasmThrow rethrow = new WasmThrow(this.context.getExceptionTag());
        rethrow.getArguments().add(new WasmGetLocal(catchVar));
        catchClause.getBody().add(rethrow);
        tryCatch.getCatches().add(catchClause);
        visitor.monitorExit(obj.get(), null, target);
        visitor.setReturnBlock(returnBlock);
        return tryCatch.getBody();
    }

    private void eliminateMultipleNullConstantUsages(final Program program) {
        final boolean[] nulls = new boolean[program.variableCount()];
        final int[] usageCount = new int[program.variableCount()];
        final TextLocation[] locations = new TextLocation[program.variableCount()];
        UsageExtractor usageExtractor = new UsageExtractor();
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction insn : block) {
                insn.acceptVisitor(usageExtractor);
                Variable[] usedVars = usageExtractor.getUsedVariables();
                if (usedVars != null) {
                    for (Variable usedVar : usedVars) {
                        int n = usedVar.getIndex();
                        usageCount[n] = usageCount[n] + 1;
                    }
                }
                if (!(insn instanceof NullConstantInstruction)) continue;
                int index = ((NullConstantInstruction)insn).getReceiver().getIndex();
                nulls[index] = true;
                locations[index] = insn.getLocation();
            }
            for (Phi phi : block.getPhis()) {
                for (Incoming input : phi.getIncomings()) {
                    int n = input.getValue().getIndex();
                    usageCount[n] = usageCount[n] + 1;
                }
            }
        }
        for (int i = 0; i < program.variableCount(); ++i) {
            if (nulls[i]) {
                if (usageCount[i] > 1) continue;
                nulls[i] = false;
                continue;
            }
            usageCount[i] = 0;
        }
        var mapFunction = new Function<Variable, Variable>(){
            Instruction instruction;

            @Override
            public Variable apply(Variable variable) {
                block3: {
                    block2: {
                        if (variable.getIndex() >= nulls.length || !nulls[variable.getIndex()]) break block2;
                        int n = variable.getIndex();
                        int n2 = usageCount[n];
                        usageCount[n] = n2 + 1;
                        if (n2 != 0) break block3;
                    }
                    return variable;
                }
                NullConstantInstruction nullConstant = new NullConstantInstruction();
                nullConstant.setReceiver(program.createVariable());
                nullConstant.setLocation(locations[variable.getIndex()]);
                this.instruction.insertPrevious(nullConstant);
                return nullConstant.getReceiver();
            }
        };
        InstructionVariableMapper mapper = new InstructionVariableMapper(mapFunction);
        for (BasicBlock block : program.getBasicBlocks()) {
            Iterator<Object> iterator = block.iterator();
            while (iterator.hasNext()) {
                Instruction insn;
                mapFunction.instruction = insn = (Instruction)iterator.next();
                insn.acceptVisitor(mapper);
            }
            for (Phi phi : block.getPhis()) {
                for (Incoming input : phi.getIncomings()) {
                    int index = input.getValue().getIndex();
                    if (index >= nulls.length || !nulls[index]) continue;
                    int n = index;
                    int n2 = usageCount[n];
                    usageCount[n] = n2 + 1;
                    if (n2 <= 0) continue;
                    NullConstantInstruction nullConstant = new NullConstantInstruction();
                    nullConstant.setReceiver(program.createVariable());
                    nullConstant.setLocation(locations[index]);
                    input.setValue(nullConstant.getReceiver());
                    input.getSource().getLastInstruction().insertPrevious(nullConstant);
                }
            }
        }
    }

    private void calculateNonNullableVars(boolean[] nonNullVars, RegularMethodNode ast) {
        NonNullVarsCalculator calculator = new NonNullVarsCalculator(nonNullVars);
        ast.getBody().acceptVisitor(calculator);
    }

    private void generateNativeMethodBody(MethodHolder method, WasmFunction function) {
        AnnotationHolder importAnnot = method.getAnnotations().get(Import.class.getName());
        if (importAnnot == null) {
            this.diagnostics.error(new CallLocation(method.getReference()), "Method is not annotated with {{c0}}", Import.class.getName());
            return;
        }
        function.setImportName(importAnnot.getValue("name").getString());
        AnnotationValue moduleName = importAnnot.getValue("module");
        function.setImportModule(moduleName != null ? moduleName.getString() : "teavm");
    }

    private void addInitializerErase(MethodReader method, WasmFunction function) {
        if (method.hasModifier(ElementModifier.STATIC) && method.getName().equals("<clinit>") && method.parameterCount() == 0 && this.classInitInfo.isDynamicInitializer(method.getOwnerName())) {
            WasmGCClassInfo classInfo = this.classInfoProvider.getClassInfo(method.getOwnerName());
            WasmSetGlobal erase = new WasmSetGlobal(classInfo.getInitializerPointer(), new WasmFunctionReference(this.getDummyInitializer()));
            function.getBody().add(erase);
            if (this.classInfoProvider.getClassInitializerOffset() >= 0) {
                function.getBody().add(new WasmStructSet(this.standardClasses.classClass().getStructure(), new WasmGetGlobal(classInfo.getPointer()), this.classInfoProvider.getClassInitializerOffset(), new WasmFunctionReference(this.getDummyInitializer())));
            }
        }
    }

    private Decompiler getDecompiler() {
        if (this.decompiler == null) {
            this.decompiler = new Decompiler(this.classes, Set.of(), this.friendlyToDebugger);
        }
        return this.decompiler;
    }

    public WasmGCGenerationContext getGenerationContext() {
        if (this.context == null) {
            this.context = new WasmGCGenerationContext(this.module, this.virtualTables, this.typeMapper, this.functionTypes, this.classes, this.resources, this.classLoader, this.hierarchy, this, this.supertypeFunctions, this.classInfoProvider, this.standardClasses, this.strings, this.customGenerators, this.intrinsics, this.names, this.strict, this.entryPoint, this.initializerContributors, this.diagnostics, this.classInitInfo, this.dependency);
        }
        return this.context;
    }

    public WasmFunction getDummyInitializer() {
        if (this.dummyInitializer == null) {
            this.dummyInitializer = new WasmFunction(this.functionTypes.of(null, new WasmType[0]));
            this.dummyInitializer.setName(this.names.topLevel("teavm@dummyInitializer"));
            this.dummyInitializer.setReferenced(true);
            this.module.functions.add(this.dummyInitializer);
        }
        return this.dummyInitializer;
    }
}

