/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.teavm.backend.javascript.codegen.NamingStrategy;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.common.ServiceRepository;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.dependency.DependencyInfo;
import org.teavm.interop.PlatformMarker;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.ClassInitializerInfo;
import org.teavm.parsing.resource.ResourceProvider;

public abstract class RenderingContext {
    private final DebugInformationEmitter debugEmitter;
    private ClassReaderSource initialClassSource;
    private ListableClassReaderSource classSource;
    private ResourceProvider resourceProvider;
    private ClassLoader classLoader;
    private ServiceRepository services;
    private Properties properties;
    private NamingStrategy naming;
    private DependencyInfo dependencyInfo;
    private Predicate<MethodReference> virtualPredicate;
    private Predicate<MethodReference> forcedFunctionPredicate;
    private final Map<String, Integer> stringPoolMap = new HashMap<String, Integer>();
    private final List<String> stringPool = new ArrayList<String>();
    private final List<String> readonlyStringPool = Collections.unmodifiableList(this.stringPool);
    private final Map<MethodReference, InjectorHolder> injectorMap = new HashMap<MethodReference, InjectorHolder>();
    private boolean minifying;
    private ClassInitializerInfo classInitializerInfo;
    private boolean strict;

    public RenderingContext(DebugInformationEmitter debugEmitter, ClassReaderSource initialClassSource, ListableClassReaderSource classSource, ResourceProvider resourceProvider, ClassLoader classLoader, ServiceRepository services, Properties properties, NamingStrategy naming, DependencyInfo dependencyInfo, Predicate<MethodReference> virtualPredicate, Predicate<MethodReference> forcedFunctionPredicate, ClassInitializerInfo classInitializerInfo, boolean strict) {
        this.debugEmitter = debugEmitter;
        this.initialClassSource = initialClassSource;
        this.classSource = classSource;
        this.resourceProvider = resourceProvider;
        this.classLoader = classLoader;
        this.services = services;
        this.properties = properties;
        this.naming = naming;
        this.dependencyInfo = dependencyInfo;
        this.virtualPredicate = virtualPredicate;
        this.forcedFunctionPredicate = forcedFunctionPredicate;
        this.classInitializerInfo = classInitializerInfo;
        this.strict = strict;
    }

    public ClassReaderSource getInitialClassSource() {
        return this.initialClassSource;
    }

    public ListableClassReaderSource getClassSource() {
        return this.classSource;
    }

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ServiceRepository getServices() {
        return this.services;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public NamingStrategy getNaming() {
        return this.naming;
    }

    public DependencyInfo getDependencyInfo() {
        return this.dependencyInfo;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public DebugInformationEmitter getDebugEmitter() {
        return this.debugEmitter;
    }

    public boolean isVirtual(MethodReference method) {
        return this.virtualPredicate.test(method);
    }

    public boolean isForcedFunction(MethodReference method) {
        return this.forcedFunctionPredicate.test(method);
    }

    public boolean isDynamicInitializer(String className) {
        return this.classInitializerInfo.isDynamicInitializer(className);
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    public int lookupString(String string) {
        return this.stringPoolMap.computeIfAbsent(string, key -> {
            this.stringPool.add((String)key);
            return this.stringPool.size() - 1;
        });
    }

    public List<String> getStringPool() {
        return this.readonlyStringPool;
    }

    public void constantToString(SourceWriter writer, Object cst) {
        if (cst == null) {
            writer.append("null");
        }
        if (cst instanceof ValueType) {
            ValueType type = (ValueType)cst;
            writer.appendFunction("$rt_cls").append("(");
            this.typeToClsString(writer, type);
            writer.append(")");
        } else if (cst instanceof String) {
            String string = (String)cst;
            int index = this.lookupString(string);
            writer.appendFunction("$rt_s").append("(" + index + ")");
        } else if (cst instanceof Long) {
            long value = (Long)cst;
            if (value == 0L) {
                writer.appendFunction("Long_ZERO");
            } else if ((long)((int)value) == value) {
                writer.appendFunction("Long_fromInt").append("(").append(String.valueOf(value)).append(")");
            } else {
                writer.appendFunction("Long_create").append("(" + (value & 0xFFFFFFFFL) + ", " + (value >>> 32) + ")");
            }
        } else if (cst instanceof Character) {
            writer.append(Integer.toString(((Character)cst).charValue()));
        } else if (cst instanceof Boolean) {
            writer.append((Boolean)cst != false ? "1" : "0");
        } else if (cst instanceof Integer) {
            int value = (Integer)cst;
            if (value < 0) {
                writer.append("(");
                writer.append(Integer.toString(value));
                writer.append(")");
            } else {
                writer.append(Integer.toString(value));
            }
        } else if (cst instanceof Byte) {
            byte value = (Byte)cst;
            if (value < 0) {
                writer.append("(");
                writer.append(Integer.toString(value));
                writer.append(")");
            } else {
                writer.append(Integer.toString(value));
            }
        } else if (cst instanceof Short) {
            short value = (Short)cst;
            if (value < 0) {
                writer.append("(");
                writer.append(Integer.toString(value));
                writer.append(")");
            } else {
                writer.append(Integer.toString(value));
            }
        } else if (cst instanceof Double) {
            double value = (Double)cst;
            if (value < 0.0) {
                writer.append("(");
                writer.append(Double.toString(value));
                writer.append(")");
            } else {
                writer.append(Double.toString(value));
            }
        } else if (cst instanceof Float) {
            float value = ((Float)cst).floatValue();
            if (value < 0.0f) {
                writer.append("(");
                writer.append(Double.toString(value));
                writer.append(")");
            } else {
                writer.append(Double.toString(value));
            }
        }
    }

    public void typeToClsString(SourceWriter writer, ValueType type) {
        int arrayCount = 0;
        while (type instanceof ValueType.Array) {
            ++arrayCount;
            type = ((ValueType.Array)type).getItemType();
        }
        for (int i = 0; i < arrayCount; ++i) {
            writer.appendFunction("$rt_arraycls").append("(");
        }
        if (type instanceof ValueType.Object) {
            ValueType.Object objType = (ValueType.Object)type;
            writer.appendClass(objType.getClassName());
        } else if (type instanceof ValueType.Void) {
            writer.appendFunction("$rt_voidcls");
        } else if (type instanceof ValueType.Primitive) {
            ValueType.Primitive primitiveType = (ValueType.Primitive)type;
            switch (primitiveType.getKind()) {
                case BOOLEAN: {
                    writer.appendFunction("$rt_booleancls");
                    break;
                }
                case CHARACTER: {
                    writer.appendFunction("$rt_charcls");
                    break;
                }
                case BYTE: {
                    writer.appendFunction("$rt_bytecls");
                    break;
                }
                case SHORT: {
                    writer.appendFunction("$rt_shortcls");
                    break;
                }
                case INTEGER: {
                    writer.appendFunction("$rt_intcls");
                    break;
                }
                case LONG: {
                    writer.appendFunction("$rt_longcls");
                    break;
                }
                case FLOAT: {
                    writer.appendFunction("$rt_floatcls");
                    break;
                }
                case DOUBLE: {
                    writer.appendFunction("$rt_doublecls");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The type is not renderable");
                }
            }
        } else {
            throw new IllegalArgumentException("The type is not renderable");
        }
        for (int i = 0; i < arrayCount; ++i) {
            writer.append(")");
        }
    }

    public String pointerName() {
        return this.minifying ? "$p" : "$ptr";
    }

    public String mainLoopName() {
        return this.minifying ? "_" : "main";
    }

    public String tempVarName() {
        return this.minifying ? "$z" : "$tmp";
    }

    public String threadName() {
        return this.minifying ? "$T" : "$thread";
    }

    public void addInjector(MethodReference method, Injector injector) {
        this.injectorMap.put(method, new InjectorHolder(injector));
    }

    public Injector getInjector(MethodReference ref) {
        InjectorHolder holder = this.injectorMap.get(ref);
        if (holder == null) {
            AnnotationReader injectedByAnnot;
            MethodReader method;
            ClassReader cls;
            holder = new InjectorHolder(null);
            if (!RenderingContext.isBootstrap() && (cls = this.classSource.get(ref.getClassName())) != null && (method = cls.getMethod(ref.getDescriptor())) != null && (injectedByAnnot = method.getAnnotations().get(InjectedBy.class.getName())) != null) {
                ValueType type = injectedByAnnot.getValue("value").getJavaClass();
                holder = new InjectorHolder(this.instantiateInjector(((ValueType.Object)type).getClassName()));
            }
            this.injectorMap.put(ref, holder);
        }
        return holder.injector;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public abstract String importModule(String var1);

    @PlatformMarker
    private static boolean isBootstrap() {
        return false;
    }

    private Injector instantiateInjector(String type) {
        try {
            Class<Injector> cls = Class.forName(type, true, this.classLoader).asSubclass(Injector.class);
            Constructor<Injector> cons = cls.getConstructor(new Class[0]);
            return cons.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Illegal injector: " + type, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Default constructor was not found in the " + type + " injector", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Error instantiating injector " + type, e);
        }
    }

    private static class InjectorHolder {
        public final Injector injector;

        private InjectorHolder(Injector injector) {
            this.injector = injector;
        }
    }
}

