/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.ast.optimization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.BlockStatement;
import org.teavm.ast.BreakStatement;
import org.teavm.ast.ConditionalStatement;
import org.teavm.ast.ContinueStatement;
import org.teavm.ast.GotoPartStatement;
import org.teavm.ast.IdentifiedStatement;
import org.teavm.ast.InitClassStatement;
import org.teavm.ast.MonitorEnterStatement;
import org.teavm.ast.MonitorExitStatement;
import org.teavm.ast.ReturnStatement;
import org.teavm.ast.SequentialStatement;
import org.teavm.ast.Statement;
import org.teavm.ast.StatementVisitor;
import org.teavm.ast.SwitchClause;
import org.teavm.ast.SwitchStatement;
import org.teavm.ast.ThrowStatement;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.WhileStatement;

class AllBlocksCountVisitor
implements StatementVisitor {
    private Map<IdentifiedStatement, Integer> blocksCount = new HashMap<IdentifiedStatement, Integer>();
    private IdentifiedStatement currentBlock;
    private boolean last = true;

    AllBlocksCountVisitor() {
    }

    public void visit(List<Statement> statements) {
        if (statements == null) {
            return;
        }
        if (statements.isEmpty()) {
            this.incrementCurrentBlock();
            return;
        }
        boolean oldLast = this.last;
        for (int i = 0; i < statements.size() - 1; ++i) {
            this.last = false;
            statements.get(i).acceptVisitor(this);
        }
        this.last = true;
        statements.get(statements.size() - 1).acceptVisitor(this);
        this.last = oldLast;
    }

    public int getCount(IdentifiedStatement statement) {
        Integer result = this.blocksCount.get(statement);
        return result != null ? result : 0;
    }

    @Override
    public void visit(AssignmentStatement statement) {
        if (this.last) {
            this.incrementCurrentBlock();
        }
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.visit(statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        this.visit(statement.getConsequent());
        this.visit(statement.getAlternative());
    }

    @Override
    public void visit(SwitchStatement statement) {
        IdentifiedStatement oldCurrentBlock = this.currentBlock;
        this.currentBlock = statement;
        for (SwitchClause clause : statement.getClauses()) {
            this.visit(clause.getBody());
        }
        this.visit(statement.getDefaultClause());
        this.currentBlock = oldCurrentBlock;
        if (this.last && this.blocksCount.containsKey(statement)) {
            this.incrementCurrentBlock();
        }
    }

    @Override
    public void visit(WhileStatement statement) {
        IdentifiedStatement oldCurrentBlock = this.currentBlock;
        this.currentBlock = statement;
        this.visit(statement.getBody());
        this.currentBlock = oldCurrentBlock;
        if (this.last && (statement.getCondition() != null || this.blocksCount.containsKey(statement))) {
            this.incrementCurrentBlock();
        }
    }

    @Override
    public void visit(BlockStatement statement) {
        IdentifiedStatement oldCurrentBlock = this.currentBlock;
        this.currentBlock = statement;
        this.visit(statement.getBody());
        this.currentBlock = oldCurrentBlock;
        if (this.last && this.blocksCount.containsKey(statement)) {
            this.incrementCurrentBlock();
        }
    }

    @Override
    public void visit(BreakStatement statement) {
        IdentifiedStatement target = statement.getTarget();
        if (target == null) {
            target = this.currentBlock;
        }
        this.incrementBlock(target);
    }

    @Override
    public void visit(ContinueStatement statement) {
        IdentifiedStatement target = statement.getTarget();
        if (target == null) {
            target = this.currentBlock;
        }
        this.incrementBlock(target);
    }

    private void incrementBlock(IdentifiedStatement statement) {
        this.blocksCount.put(statement, this.getCount(statement) + 1);
    }

    private void incrementCurrentBlock() {
        if (this.currentBlock != null) {
            this.incrementBlock(this.currentBlock);
        }
    }

    @Override
    public void visit(ReturnStatement statement) {
    }

    @Override
    public void visit(ThrowStatement statement) {
    }

    @Override
    public void visit(InitClassStatement statement) {
    }

    @Override
    public void visit(TryCatchStatement statement) {
        this.visit(statement.getProtectedBody());
        this.visit(statement.getHandler());
    }

    @Override
    public void visit(GotoPartStatement statement) {
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        if (this.last) {
            this.incrementCurrentBlock();
        }
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        if (this.last) {
            this.incrementCurrentBlock();
        }
    }
}

