/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.ast;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.teavm.ast.ArrayType;
import org.teavm.ast.BinaryExpr;
import org.teavm.ast.BinaryOperation;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.ExprVisitor;
import org.teavm.ast.InstanceOfExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.InvocationType;
import org.teavm.ast.NewArrayExpr;
import org.teavm.ast.NewExpr;
import org.teavm.ast.NewMultiArrayExpr;
import org.teavm.ast.OperationType;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.SubscriptExpr;
import org.teavm.ast.UnaryExpr;
import org.teavm.ast.UnaryOperation;
import org.teavm.ast.VariableExpr;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;

public abstract class Expr
implements Cloneable {
    private TextLocation location;
    private int variableIndex = -1;

    public abstract void acceptVisitor(ExprVisitor var1);

    public int getVariableIndex() {
        return this.variableIndex;
    }

    public void setVariableIndex(int variableIndex) {
        this.variableIndex = variableIndex;
    }

    public Expr clone() {
        return this.clone(new HashMap<Expr, Expr>());
    }

    protected abstract Expr clone(Map<Expr, Expr> var1);

    public static Expr constant(Object value) {
        ConstantExpr expr = new ConstantExpr();
        expr.setValue(value);
        return expr;
    }

    public static Expr var(int index) {
        VariableExpr expr = new VariableExpr();
        expr.setIndex(index);
        expr.setVariableIndex(index);
        return expr;
    }

    public static Expr binary(BinaryOperation op, OperationType type, Expr first, Expr second) {
        BinaryExpr expr = new BinaryExpr();
        expr.setFirstOperand(first);
        expr.setSecondOperand(second);
        expr.setOperation(op);
        expr.setType(type);
        return expr;
    }

    public static Expr and(Expr first, Expr second) {
        return Expr.binary(BinaryOperation.AND, null, first, second);
    }

    public static Expr or(Expr first, Expr second) {
        return Expr.binary(BinaryOperation.OR, null, first, second);
    }

    public static Expr addInt(Expr first, Expr second) {
        return Expr.binary(BinaryOperation.ADD, OperationType.INT, first, second);
    }

    public static Expr divInt(Expr first, Expr second) {
        return Expr.binary(BinaryOperation.DIVIDE, OperationType.INT, first, second);
    }

    public static Expr less(Expr first, Expr second) {
        return Expr.binary(BinaryOperation.LESS, OperationType.INT, first, second);
    }

    public static Expr binary(BinaryOperation op, OperationType type, Expr first, Expr second, TextLocation loc) {
        Expr expr = Expr.binary(op, type, first, second);
        expr.setLocation(loc);
        return expr;
    }

    public static Expr unary(UnaryOperation op, OperationType type, Expr arg) {
        UnaryExpr expr = new UnaryExpr();
        expr.setOperand(arg);
        expr.setOperation(op);
        expr.setType(type);
        return expr;
    }

    public static Expr invert(Expr expr) {
        UnaryExpr result = new UnaryExpr();
        result.setOperand(expr);
        result.setOperation(UnaryOperation.NOT);
        result.setLocation(expr.getLocation());
        return result;
    }

    public static Expr subscript(Expr array, Expr index, ArrayType type) {
        SubscriptExpr expr = new SubscriptExpr();
        expr.setArray(array);
        expr.setIndex(index);
        expr.setType(type);
        return expr;
    }

    public static Expr createArray(ValueType type, Expr length) {
        NewArrayExpr expr = new NewArrayExpr();
        expr.setType(type);
        expr.setLength(length);
        return expr;
    }

    public static Expr createArray(ValueType type, Expr ... dimensions) {
        NewMultiArrayExpr expr = new NewMultiArrayExpr();
        expr.setType(type);
        expr.getDimensions().addAll(Arrays.asList(dimensions));
        return expr;
    }

    public static Expr createObject(String type) {
        NewExpr expr = new NewExpr();
        expr.setConstructedClass(type);
        return expr;
    }

    public static InvocationExpr constructObject(MethodReference method, Expr[] arguments) {
        InvocationExpr expr = new InvocationExpr();
        expr.setMethod(method);
        expr.setType(InvocationType.CONSTRUCTOR);
        expr.getArguments().addAll(Arrays.asList(arguments));
        return expr;
    }

    public static Expr qualify(Expr target, FieldReference field) {
        QualificationExpr expr = new QualificationExpr();
        expr.setQualified(target);
        expr.setField(field);
        return expr;
    }

    public static InvocationExpr invoke(MethodReference method, Expr target, Expr[] arguments) {
        InvocationExpr expr = new InvocationExpr();
        expr.setMethod(method);
        expr.setType(InvocationType.DYNAMIC);
        expr.getArguments().add(target);
        expr.getArguments().addAll(Arrays.asList(arguments));
        return expr;
    }

    public static InvocationExpr invokeSpecial(MethodReference method, Expr target, Expr[] arguments) {
        InvocationExpr expr = new InvocationExpr();
        expr.setMethod(method);
        expr.setType(InvocationType.SPECIAL);
        expr.getArguments().add(target);
        expr.getArguments().addAll(Arrays.asList(arguments));
        return expr;
    }

    public static InvocationExpr invokeStatic(MethodReference method, Expr ... arguments) {
        InvocationExpr expr = new InvocationExpr();
        expr.setMethod(method);
        expr.setType(InvocationType.STATIC);
        expr.getArguments().addAll(Arrays.asList(arguments));
        return expr;
    }

    public static Expr instanceOf(Expr target, ValueType className) {
        InstanceOfExpr expr = new InstanceOfExpr();
        expr.setExpr(target);
        expr.setType(className);
        return expr;
    }

    public TextLocation getLocation() {
        return this.location;
    }

    public void setLocation(TextLocation location) {
        this.location = location;
    }
}

