/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import org.teavm.model.DynamicConstant;
import org.teavm.model.MethodHandle;
import org.teavm.model.ValueType;

public final class RuntimeConstant {
    public static final byte INT = 0;
    public static final byte LONG = 1;
    public static final byte FLOAT = 2;
    public static final byte DOUBLE = 3;
    public static final byte STRING = 4;
    public static final byte TYPE = 5;
    public static final byte METHOD = 6;
    public static final byte METHOD_HANDLE = 7;
    public static final byte DYNAMIC_CONSTANT = 8;
    private byte kind;
    private Object value;

    RuntimeConstant(byte kind, Object value) {
        this.kind = kind;
        this.value = value;
    }

    public RuntimeConstant(int value) {
        this(0, value);
    }

    public RuntimeConstant(long value) {
        this(1, value);
    }

    public RuntimeConstant(float value) {
        this(2, Float.valueOf(value));
    }

    public RuntimeConstant(double value) {
        this(2, value);
    }

    public RuntimeConstant(String value) {
        this(4, value);
    }

    public RuntimeConstant(ValueType value) {
        this(5, value);
    }

    public RuntimeConstant(ValueType[] methodType) {
        this(6, methodType.clone());
    }

    public RuntimeConstant(MethodHandle value) {
        this(7, value);
    }

    public RuntimeConstant(DynamicConstant value) {
        this(8, value);
    }

    public byte getKind() {
        return this.kind;
    }

    public int getInt() {
        return (Integer)this.value;
    }

    public long getLong() {
        return (Long)this.value;
    }

    public float getFloat() {
        return ((Float)this.value).floatValue();
    }

    public double getDouble() {
        return (Double)this.value;
    }

    public String getString() {
        return (String)this.value;
    }

    public ValueType getValueType() {
        return (ValueType)this.value;
    }

    public ValueType[] getMethodType() {
        return (ValueType[])((ValueType[])this.value).clone();
    }

    public MethodHandle getMethodHandle() {
        return (MethodHandle)this.value;
    }

    public DynamicConstant getDynamicConstant() {
        return (DynamicConstant)this.value;
    }
}

