/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.transformation.gc;

import org.teavm.backend.wasm.BaseWasmFunctionRepository;
import org.teavm.backend.wasm.model.WasmCompositeType;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExternConversion;
import org.teavm.backend.wasm.model.expression.WasmExternConversionType;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmPush;
import org.teavm.model.MethodReference;
import org.teavm.runtime.Fiber;

class CoroutineFunctions {
    private BaseWasmFunctionRepository functions;
    private WasmFunction pushIntCache;
    private WasmFunction pushLongCache;
    private WasmFunction pushFloatCache;
    private WasmFunction pushDoubleCache;
    private WasmFunction pushObjectCache;
    private WasmFunction pushFunctionCache;
    private WasmFunction popIntCache;
    private WasmFunction popLongCache;
    private WasmFunction popFloatCache;
    private WasmFunction popDoubleCache;
    private WasmFunction popObjectCache;
    private WasmFunction popFunctionCache;
    private WasmFunction isResumingCache;
    private WasmFunction isSuspendingCache;
    private WasmFunction currentFiberCache;

    CoroutineFunctions(BaseWasmFunctionRepository functions) {
        this.functions = functions;
    }

    WasmFunction pushInt() {
        if (this.pushIntCache == null) {
            this.pushIntCache = this.functions.forStaticMethod(new MethodReference(Fiber.class, "reversePush", Integer.TYPE, Fiber.class, Void.TYPE));
        }
        return this.pushIntCache;
    }

    WasmFunction pushLong() {
        if (this.pushLongCache == null) {
            this.pushLongCache = this.functions.forStaticMethod(new MethodReference(Fiber.class, "reversePush", Long.TYPE, Fiber.class, Void.TYPE));
        }
        return this.pushLongCache;
    }

    WasmFunction pushFloat() {
        if (this.pushFloatCache == null) {
            this.pushFloatCache = this.functions.forStaticMethod(new MethodReference(Fiber.class, "reversePush", Float.TYPE, Fiber.class, Void.TYPE));
        }
        return this.pushFloatCache;
    }

    WasmFunction pushDouble() {
        if (this.pushDoubleCache == null) {
            this.pushDoubleCache = this.functions.forStaticMethod(new MethodReference(Fiber.class, "reversePush", Double.TYPE, Fiber.class, Void.TYPE));
        }
        return this.pushDoubleCache;
    }

    WasmFunction pushPlatformObject() {
        if (this.pushObjectCache == null) {
            this.pushObjectCache = this.functions.forStaticMethod(new MethodReference(Fiber.class, "reversePush", Fiber.PlatformObject.class, Fiber.class, Void.TYPE));
        }
        return this.pushObjectCache;
    }

    WasmFunction pushPlatformFunction() {
        if (this.pushFunctionCache == null) {
            this.pushFunctionCache = this.functions.forStaticMethod(new MethodReference(Fiber.class, "reversePush", Fiber.PlatformFunction.class, Fiber.class, Void.TYPE));
        }
        return this.pushFunctionCache;
    }

    WasmFunction popInt() {
        if (this.popIntCache == null) {
            this.popIntCache = this.functions.forInstanceMethod(new MethodReference(Fiber.class, "popInt", Integer.TYPE));
        }
        return this.popIntCache;
    }

    WasmFunction popLong() {
        if (this.popLongCache == null) {
            this.popLongCache = this.functions.forInstanceMethod(new MethodReference(Fiber.class, "popLong", Long.TYPE));
        }
        return this.popLongCache;
    }

    WasmFunction popFloat() {
        if (this.popFloatCache == null) {
            this.popFloatCache = this.functions.forInstanceMethod(new MethodReference(Fiber.class, "popFloat", Float.TYPE));
        }
        return this.popFloatCache;
    }

    WasmFunction popDouble() {
        if (this.popDoubleCache == null) {
            this.popDoubleCache = this.functions.forInstanceMethod(new MethodReference(Fiber.class, "popDouble", Double.TYPE));
        }
        return this.popDoubleCache;
    }

    WasmFunction popPlatformObject() {
        if (this.popObjectCache == null) {
            this.popObjectCache = this.functions.forInstanceMethod(new MethodReference(Fiber.class, "popPlatformObject", Fiber.PlatformObject.class));
        }
        return this.popObjectCache;
    }

    WasmFunction popPlatformFunction() {
        if (this.popFunctionCache == null) {
            this.popFunctionCache = this.functions.forInstanceMethod(new MethodReference(Fiber.class, "popPlatformFunction", Fiber.PlatformFunction.class));
        }
        return this.popFunctionCache;
    }

    WasmFunction isResuming() {
        if (this.isResumingCache == null) {
            this.isResumingCache = this.functions.forInstanceMethod(new MethodReference(Fiber.class, "isResuming", Boolean.TYPE));
        }
        return this.isResumingCache;
    }

    WasmFunction isSuspending() {
        if (this.isSuspendingCache == null) {
            this.isSuspendingCache = this.functions.forInstanceMethod(new MethodReference(Fiber.class, "isSuspending", Boolean.TYPE));
        }
        return this.isSuspendingCache;
    }

    WasmFunction currentFiber() {
        if (this.currentFiberCache == null) {
            this.currentFiberCache = this.functions.forStaticMethod(new MethodReference(Fiber.class, "current", Fiber.class));
        }
        return this.currentFiberCache;
    }

    WasmExpression restoreValue(WasmType type, WasmLocal fiberLocal) {
        if (type instanceof WasmType.Number) {
            switch (((WasmType.Number)type).number) {
                case INT32: {
                    return new WasmCall(this.popInt(), new WasmGetLocal(fiberLocal));
                }
                case INT64: {
                    return new WasmCall(this.popLong(), new WasmGetLocal(fiberLocal));
                }
                case FLOAT32: {
                    return new WasmPush(new WasmCall(this.popFloat(), new WasmGetLocal(fiberLocal)));
                }
                case FLOAT64: {
                    return new WasmPush(new WasmCall(this.popDouble(), new WasmGetLocal(fiberLocal)));
                }
            }
            throw new IllegalArgumentException();
        }
        if (type instanceof WasmType.Reference) {
            WasmCompositeType composite;
            WasmType.Reference refType = (WasmType.Reference)type;
            WasmExpression obj = new WasmCall(this.popPlatformObject(), new WasmGetLocal(fiberLocal));
            if (type instanceof WasmType.SpecialReference) {
                switch (((WasmType.SpecialReference)type).kind) {
                    case EXTERN: {
                        obj = new WasmExternConversion(WasmExternConversionType.ANY_TO_EXTERN, obj);
                        break;
                    }
                    case FUNC: {
                        obj = new WasmCall(this.popPlatformFunction(), new WasmGetLocal(fiberLocal));
                    }
                }
            } else if (type instanceof WasmType.CompositeReference && (composite = ((WasmType.CompositeReference)type).composite) instanceof WasmFunctionType) {
                obj = new WasmCall(this.popPlatformFunction(), new WasmGetLocal(fiberLocal));
            }
            return new WasmCast(obj, refType);
        }
        throw new IllegalArgumentException();
    }

    WasmExpression saveValue(WasmType type, WasmLocal fiberLocal, WasmExpression value) {
        WasmCompositeType composite;
        if (type instanceof WasmType.Number) {
            switch (((WasmType.Number)type).number) {
                case INT32: {
                    return new WasmCall(this.pushInt(), value, new WasmGetLocal(fiberLocal));
                }
                case INT64: {
                    return new WasmCall(this.pushLong(), value, new WasmGetLocal(fiberLocal));
                }
                case FLOAT32: {
                    return new WasmCall(this.pushFloat(), value, new WasmGetLocal(fiberLocal));
                }
                case FLOAT64: {
                    return new WasmCall(this.pushDouble(), value, new WasmGetLocal(fiberLocal));
                }
            }
            throw new IllegalArgumentException();
        }
        if (type instanceof WasmType.SpecialReference) {
            switch (((WasmType.SpecialReference)type).kind) {
                case EXTERN: {
                    value = new WasmExternConversion(WasmExternConversionType.EXTERN_TO_ANY, value);
                    break;
                }
                case FUNC: {
                    return new WasmCall(this.pushPlatformFunction(), value, new WasmGetLocal(fiberLocal));
                }
            }
        } else if (type instanceof WasmType.CompositeReference && (composite = ((WasmType.CompositeReference)type).composite) instanceof WasmFunctionType) {
            return new WasmCall(this.pushPlatformFunction(), value, new WasmGetLocal(fiberLocal));
        }
        return new WasmCall(this.pushPlatformObject(), value, new WasmGetLocal(fiberLocal));
    }
}

