/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import java.util.List;
import java.util.function.Function;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmCastBranch;
import org.teavm.backend.wasm.model.expression.WasmCatch;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmCopy;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmExternConversion;
import org.teavm.backend.wasm.model.expression.WasmFill;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatUnary;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt31Get;
import org.teavm.backend.wasm.model.expression.WasmInt31Reference;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIsNull;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmMemoryGrow;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmPop;
import org.teavm.backend.wasm.model.expression.WasmPush;
import org.teavm.backend.wasm.model.expression.WasmReferencesEqual;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmTest;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmTry;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;

public class WasmReplacingExpressionVisitor
implements WasmExpressionVisitor {
    private Function<WasmExpression, WasmExpression> mapper;

    public WasmReplacingExpressionVisitor(Function<WasmExpression, WasmExpression> mapper) {
        this.mapper = mapper;
    }

    public void replace(WasmFunction function) {
        this.replaceExpressions(function.getBody());
    }

    private void replaceExpressions(List<WasmExpression> expressions) {
        for (int i = 0; i < expressions.size(); ++i) {
            WasmExpression part = expressions.get(i);
            part.acceptVisitor(this);
            part = this.mapper.apply(part);
            expressions.set(i, part);
        }
    }

    @Override
    public void visit(WasmBlock expression) {
        this.replaceExpressions(expression.getBody());
    }

    @Override
    public void visit(WasmBranch expression) {
        expression.getCondition().acceptVisitor(this);
        expression.setCondition(this.mapper.apply(expression.getCondition()));
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
            expression.setResult(this.mapper.apply(expression.getResult()));
        }
    }

    @Override
    public void visit(WasmNullBranch expression) {
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
            expression.setResult(this.mapper.apply(expression.getResult()));
        }
    }

    @Override
    public void visit(WasmCastBranch expression) {
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
            expression.setResult(this.mapper.apply(expression.getResult()));
        }
    }

    @Override
    public void visit(WasmBreak expression) {
        if (expression.getResult() != null) {
            expression.getResult().acceptVisitor(this);
            expression.setResult(this.mapper.apply(expression.getResult()));
        }
    }

    @Override
    public void visit(WasmSwitch expression) {
        expression.getSelector().acceptVisitor(this);
        expression.setSelector(this.mapper.apply(expression.getSelector()));
    }

    @Override
    public void visit(WasmConditional expression) {
        expression.getCondition().acceptVisitor(this);
        expression.setCondition(this.mapper.apply(expression.getCondition()));
        this.replaceExpressions(expression.getThenBlock().getBody());
        this.replaceExpressions(expression.getElseBlock().getBody());
    }

    @Override
    public void visit(WasmReturn expression) {
        if (expression.getValue() != null) {
            expression.getValue().acceptVisitor(this);
            expression.setValue(this.mapper.apply(expression.getValue()));
        }
    }

    @Override
    public void visit(WasmUnreachable expression) {
    }

    @Override
    public void visit(WasmInt32Constant expression) {
    }

    @Override
    public void visit(WasmInt64Constant expression) {
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
    }

    @Override
    public void visit(WasmNullConstant expression) {
    }

    @Override
    public void visit(WasmIsNull expression) {
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmGetLocal expression) {
    }

    @Override
    public void visit(WasmSetLocal expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmGetGlobal expression) {
    }

    @Override
    public void visit(WasmSetGlobal expression) {
        expression.getValue().acceptVisitor(this);
    }

    @Override
    public void visit(WasmIntBinary expression) {
        expression.getFirst().acceptVisitor(this);
        expression.setFirst(this.mapper.apply(expression.getFirst()));
        expression.getSecond().acceptVisitor(this);
        expression.setSecond(this.mapper.apply(expression.getSecond()));
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        expression.getFirst().acceptVisitor(this);
        expression.setFirst(this.mapper.apply(expression.getFirst()));
        expression.getSecond().acceptVisitor(this);
        expression.setSecond(this.mapper.apply(expression.getSecond()));
    }

    @Override
    public void visit(WasmIntUnary expression) {
        expression.getOperand().acceptVisitor(this);
        expression.setOperand(this.mapper.apply(expression.getOperand()));
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        expression.getOperand().acceptVisitor(this);
        expression.setOperand(this.mapper.apply(expression.getOperand()));
    }

    @Override
    public void visit(WasmConversion expression) {
        expression.getOperand().acceptVisitor(this);
        expression.setOperand(this.mapper.apply(expression.getOperand()));
    }

    @Override
    public void visit(WasmCall expression) {
        this.replaceExpressions(expression.getArguments());
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        expression.getSelector().acceptVisitor(this);
        expression.setSelector(this.mapper.apply(expression.getSelector()));
        this.replaceExpressions(expression.getArguments());
    }

    @Override
    public void visit(WasmCallReference expression) {
        expression.getFunctionReference().acceptVisitor(this);
        expression.setFunctionReference(this.mapper.apply(expression.getFunctionReference()));
        this.replaceExpressions(expression.getArguments());
    }

    @Override
    public void visit(WasmDrop expression) {
        expression.getOperand().acceptVisitor(this);
        expression.setOperand(this.mapper.apply(expression.getOperand()));
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmMemoryGrow expression) {
        expression.getAmount().acceptVisitor(this);
        expression.setAmount(this.mapper.apply(expression.getAmount()));
    }

    @Override
    public void visit(WasmFill expression) {
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
        expression.getCount().acceptVisitor(this);
        expression.setCount(this.mapper.apply(expression.getCount()));
    }

    @Override
    public void visit(WasmCopy expression) {
        expression.getSourceIndex().acceptVisitor(this);
        expression.setSourceIndex(this.mapper.apply(expression.getSourceIndex()));
        expression.getDestinationIndex().acceptVisitor(this);
        expression.setDestinationIndex(this.mapper.apply(expression.getDestinationIndex()));
        expression.getCount().acceptVisitor(this);
        expression.setCount(this.mapper.apply(expression.getCount()));
    }

    @Override
    public void visit(WasmTry expression) {
        this.replaceExpressions(expression.getBody());
        for (WasmCatch catchClause : expression.getCatches()) {
            this.replaceExpressions(catchClause.getBody());
        }
    }

    @Override
    public void visit(WasmThrow expression) {
        this.replaceExpressions(expression.getArguments());
    }

    @Override
    public void visit(WasmReferencesEqual expression) {
        expression.getFirst().acceptVisitor(this);
        expression.setFirst(this.mapper.apply(expression.getFirst()));
        expression.getSecond().acceptVisitor(this);
        expression.setSecond(this.mapper.apply(expression.getSecond()));
    }

    @Override
    public void visit(WasmCast expression) {
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmTest expression) {
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmExternConversion expression) {
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmStructNew expression) {
        this.replaceExpressions(expression.getInitializers());
    }

    @Override
    public void visit(WasmStructNewDefault expression) {
    }

    @Override
    public void visit(WasmStructGet expression) {
        expression.getInstance().acceptVisitor(this);
        expression.setInstance(this.mapper.apply(expression.getInstance()));
    }

    @Override
    public void visit(WasmStructSet expression) {
        expression.getInstance().acceptVisitor(this);
        expression.setInstance(this.mapper.apply(expression.getInstance()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmArrayNewDefault expression) {
        expression.getLength().acceptVisitor(this);
        expression.setLength(this.mapper.apply(expression.getLength()));
    }

    @Override
    public void visit(WasmArrayNewFixed expression) {
        this.replaceExpressions(expression.getElements());
    }

    @Override
    public void visit(WasmArrayGet expression) {
        expression.getInstance().acceptVisitor(this);
        expression.setInstance(this.mapper.apply(expression.getInstance()));
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
    }

    @Override
    public void visit(WasmArraySet expression) {
        expression.getInstance().acceptVisitor(this);
        expression.setInstance(this.mapper.apply(expression.getInstance()));
        expression.getIndex().acceptVisitor(this);
        expression.setIndex(this.mapper.apply(expression.getIndex()));
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getIndex()));
    }

    @Override
    public void visit(WasmArrayLength expression) {
        expression.getInstance().acceptVisitor(this);
        expression.setInstance(this.mapper.apply(expression.getInstance()));
    }

    @Override
    public void visit(WasmArrayCopy expression) {
        expression.getSourceArray().acceptVisitor(this);
        expression.setSourceArray(this.mapper.apply(expression.getSourceArray()));
        expression.getSourceIndex().acceptVisitor(this);
        expression.setSourceIndex(this.mapper.apply(expression.getSourceIndex()));
        expression.getTargetArray().acceptVisitor(this);
        expression.setTargetArray(this.mapper.apply(expression.getTargetArray()));
        expression.getTargetIndex().acceptVisitor(this);
        expression.setTargetIndex(this.mapper.apply(expression.getTargetIndex()));
        expression.getSize().acceptVisitor(this);
        expression.setSize(this.mapper.apply(expression.getSize()));
    }

    @Override
    public void visit(WasmFunctionReference expression) {
    }

    @Override
    public void visit(WasmInt31Reference expression) {
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmInt31Get expression) {
        expression.getValue().acceptVisitor(this);
        expression.setValue(this.mapper.apply(expression.getValue()));
    }

    @Override
    public void visit(WasmPush expression) {
    }

    @Override
    public void visit(WasmPop expression) {
    }
}

