/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generators.gc;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCCustomGeneratorProvider;
import org.teavm.backend.wasm.generators.gc.ArrayGenerator;
import org.teavm.backend.wasm.generators.gc.ClassGenerators;
import org.teavm.backend.wasm.generators.gc.EventQueueGenerator;
import org.teavm.backend.wasm.generators.gc.StringGenerator;
import org.teavm.backend.wasm.generators.gc.SystemDoArrayCopyGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorFactory;
import org.teavm.backend.wasm.generators.gc.WasmGCCustomGeneratorFactoryContext;
import org.teavm.backend.wasm.generators.gc.WasmGCResourcesGenerator;
import org.teavm.backend.wasm.generators.gc.WasmGCStringPoolGenerator;
import org.teavm.backend.wasm.generators.gc.WeakReferenceGenerator;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.runtime.gc.WasmGCResources;
import org.teavm.backend.wasm.runtime.gc.WasmGCSupport;
import org.teavm.common.ServiceRepository;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.runtime.EventQueue;

public class WasmGCCustomGenerators
implements WasmGCCustomGeneratorProvider {
    private List<WasmGCCustomGeneratorFactory> factories;
    private Map<MethodReference, Container> generators = new HashMap<MethodReference, Container>();
    private ClassReaderSource classes;
    private ServiceRepository services;
    private WasmGCResourcesGenerator resourcesGenerator;
    private WasmGCCustomGeneratorFactoryContext factoryContext = new WasmGCCustomGeneratorFactoryContext(){

        @Override
        public ClassReaderSource classes() {
            return WasmGCCustomGenerators.this.classes;
        }

        @Override
        public ServiceRepository services() {
            return WasmGCCustomGenerators.this.services;
        }
    };

    public WasmGCCustomGenerators(ClassReaderSource classes, ServiceRepository services, List<WasmGCCustomGeneratorFactory> factories, Map<MethodReference, WasmGCCustomGenerator> generators, Properties properties) {
        this.factories = List.copyOf(factories);
        this.classes = classes;
        this.services = services;
        this.resourcesGenerator = new WasmGCResourcesGenerator(properties);
        this.fillClass();
        this.fillStringPool();
        this.fillSystem();
        this.fillArray();
        this.fillWeakReference();
        this.fillString();
        this.fillResources();
        this.fillEventQueue();
        for (Map.Entry<MethodReference, WasmGCCustomGenerator> entry : generators.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public void contributeToModule(WasmModule module) {
        this.resourcesGenerator.writeModule(module);
    }

    private void fillClass() {
        ClassGenerators classGenerators = new ClassGenerators();
        this.add(new MethodReference(Class.class, "isAssignableFrom", Class.class, Boolean.TYPE), classGenerators);
    }

    private void fillStringPool() {
        this.add(new MethodReference(WasmGCSupport.class, "nextByte", Byte.TYPE), new WasmGCStringPoolGenerator());
    }

    private void fillSystem() {
        this.add(new MethodReference(System.class, "doArrayCopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Void.TYPE), new SystemDoArrayCopyGenerator());
    }

    private void fillArray() {
        ArrayGenerator arrayGenerator = new ArrayGenerator();
        this.add(new MethodReference(Array.class, "newInstanceImpl", Class.class, Integer.TYPE, Object.class), arrayGenerator);
    }

    private void fillWeakReference() {
        WeakReferenceGenerator generator = new WeakReferenceGenerator();
        this.add(new MethodReference(WeakReference.class, "<init>", Object.class, ReferenceQueue.class, Void.TYPE), generator);
        this.add(new MethodReference(WeakReference.class, "get", Object.class), generator);
        this.add(new MethodReference(WeakReference.class, "clear", Void.TYPE), generator);
    }

    private void fillString() {
        StringGenerator generator = new StringGenerator();
        this.add(new MethodReference(String.class, "intern", String.class), generator);
    }

    private void fillResources() {
        this.add(new MethodReference(WasmGCResources.class, "acquireResources", WasmGCResources.Resource[].class), this.resourcesGenerator);
    }

    private void fillEventQueue() {
        EventQueueGenerator generator = new EventQueueGenerator();
        this.add(new MethodReference(EventQueue.class, "offerWasmGC", EventQueue.Event.class, Double.TYPE, Integer.TYPE), generator);
    }

    @Override
    public WasmGCCustomGenerator get(MethodReference method) {
        Container result = this.generators.get(method);
        if (result == null) {
            WasmGCCustomGeneratorFactory factory;
            WasmGCCustomGenerator generator = null;
            Iterator<WasmGCCustomGeneratorFactory> iterator = this.factories.iterator();
            while (iterator.hasNext() && (generator = (factory = iterator.next()).createGenerator(method, this.factoryContext)) == null) {
            }
            result = new Container(generator);
            this.generators.put(method, result);
        }
        return result.generator;
    }

    private void add(MethodReference method, WasmGCCustomGenerator generator) {
        this.generators.put(method, new Container(generator));
    }

    private static class Container {
        final WasmGCCustomGenerator generator;

        Container(WasmGCCustomGenerator generator) {
            this.generator = generator;
        }
    }
}

