/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.annotations;

import java.lang.annotation.Retention;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassGenerator;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.methods.WasmGCGenerationUtil;
import org.teavm.backend.wasm.generate.gc.strings.WasmGCStringProvider;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmGlobal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.MethodReader;
import org.teavm.model.ValueType;
import org.teavm.model.analysis.ClassMetadataRequirements;

public class WasmGCAnnotationsGenerator {
    private ClassReaderSource classes;
    private ClassMetadataRequirements metadataRequirements;
    private WasmGCClassGenerator classInfoProvider;
    private WasmGCStringProvider stringProvider;
    private List<Consumer<WasmFunction>> parts;

    public WasmGCAnnotationsGenerator(ClassReaderSource classes, ClassMetadataRequirements metadataRequirements, WasmGCClassGenerator classInfoProvider, WasmGCStringProvider stringProvider, List<Consumer<WasmFunction>> parts) {
        this.classes = classes;
        this.metadataRequirements = metadataRequirements;
        this.classInfoProvider = classInfoProvider;
        this.stringProvider = stringProvider;
        this.parts = parts;
    }

    public void addClassAnnotations(String className, WasmGCClassInfo classInfo) {
        ClassReader cls = this.classes.get(className);
        if (cls == null) {
            return;
        }
        ClassMetadataRequirements.Info info = this.metadataRequirements.getInfo(className);
        if (!info.annotations()) {
            return;
        }
        ArrayList<AnnotationReader> annotationsToExpose = new ArrayList<AnnotationReader>();
        for (AnnotationReader annotationReader : cls.getAnnotations().all()) {
            AnnotationReader retention;
            ClassReader classReader = this.classes.get(annotationReader.getType());
            if (classReader == null || (retention = classReader.getAnnotations().get(Retention.class.getName())) == null || !Objects.equals(retention.getValue("value").getEnumValue().getFieldName(), "RUNTIME")) continue;
            annotationsToExpose.add(annotationReader);
        }
        if (annotationsToExpose.isEmpty()) {
            return;
        }
        WasmArrayNewFixed array = new WasmArrayNewFixed(this.classInfoProvider.getObjectArrayType());
        for (AnnotationReader annotationReader : annotationsToExpose) {
            array.getElements().add(this.generateAnnotation(annotationReader));
        }
        WasmGlobal wasmGlobal = classInfo.getPointer();
        WasmGCClassInfo wasmGCClassInfo = this.classInfoProvider.getClassInfo("java.lang.Class");
        WasmStructSet setAnnotations = new WasmStructSet(wasmGCClassInfo.getStructure(), new WasmGetGlobal(wasmGlobal), this.classInfoProvider.getClassAnnotationsOffset(), array);
        this.parts.add(f -> f.getBody().add(setAnnotations));
    }

    private WasmExpression generateAnnotation(AnnotationReader annotation) {
        ClassReader annotCls = this.classes.get(annotation.getType());
        ClassReader annotImpl = this.classes.get(annotation.getType() + "$$_impl");
        WasmGCClassInfo annotImplInfo = this.classInfoProvider.getClassInfo(annotImpl.getName());
        WasmStructNew constructor = new WasmStructNew(annotImplInfo.getStructure());
        constructor.getInitializers().add(new WasmGetGlobal(annotImplInfo.getVirtualTablePointer()));
        constructor.getInitializers().add(new WasmNullConstant(WasmType.Reference.EQ));
        int additionalFields = annotImplInfo.getStructure().getFields().size() - 2;
        constructor.getInitializers().addAll(Collections.nCopies(additionalFields, null));
        for (MethodReader methodReader : annotCls.getMethods()) {
            String name = methodReader.getName();
            FieldReader field = annotImpl.getField("$" + name);
            int fieldIndex = this.classInfoProvider.getFieldIndex(field.getReference());
            AnnotationValue value = annotation.getValue(name);
            if (value == null) {
                value = methodReader.getAnnotationDefault();
            }
            constructor.getInitializers().set(fieldIndex, this.generateAnnotationValue(value, field.getType()));
        }
        return constructor;
    }

    private WasmExpression generateAnnotationValue(AnnotationValue value, ValueType type) {
        switch (value.getType()) {
            case 0: {
                return new WasmInt32Constant(value.getBoolean() ? 1 : 0);
            }
            case 12: {
                return new WasmInt32Constant(value.getChar());
            }
            case 1: {
                return new WasmInt32Constant(value.getByte());
            }
            case 2: {
                return new WasmInt32Constant(value.getShort());
            }
            case 3: {
                return new WasmInt32Constant(value.getInt());
            }
            case 4: {
                return new WasmInt64Constant(value.getLong());
            }
            case 5: {
                return new WasmFloat32Constant(value.getFloat());
            }
            case 6: {
                return new WasmFloat64Constant(value.getDouble());
            }
            case 7: {
                return new WasmGetGlobal(this.stringProvider.getStringConstant((String)value.getString()).global);
            }
            case 9: {
                String string;
                ClassReader itemClass;
                ValueType itemType;
                WasmGCGenerationUtil util = new WasmGCGenerationUtil(this.classInfoProvider);
                ValueType arrayItemType = itemType = ((ValueType.Array)type).getItemType();
                if (itemType instanceof ValueType.Object && (itemClass = this.classes.get(string = ((ValueType.Object)itemType).getClassName())) != null && itemClass.hasModifier(ElementModifier.ENUM)) {
                    arrayItemType = ValueType.INTEGER;
                }
                return util.allocateArrayWithElements(arrayItemType, () -> value.getList().stream().map(elem -> this.generateAnnotationValue((AnnotationValue)elem, itemType)).collect(Collectors.toList()));
            }
            case 11: {
                return this.generateAnnotation(value.getAnnotation());
            }
            case 10: {
                ClassReader enumCls = this.classes.get(value.getEnumValue().getClassName());
                if (enumCls == null) {
                    return new WasmInt32Constant(0);
                }
                int index = 0;
                for (FieldReader fieldReader : enumCls.getFields()) {
                    if (!fieldReader.hasModifier(ElementModifier.STATIC) || !fieldReader.hasModifier(ElementModifier.ENUM)) continue;
                    if (fieldReader.getName().equals(value.getEnumValue().getFieldName())) break;
                    ++index;
                }
                return new WasmInt32Constant(index);
            }
            case 8: {
                WasmGCClassInfo valueClassInfo = this.classInfoProvider.getClassInfo(value.getJavaClass());
                return new WasmGetGlobal(valueClassInfo.getPointer());
            }
        }
        throw new IllegalArgumentException();
    }
}

