/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.debug.parser;

import java.util.ArrayList;
import org.teavm.backend.wasm.debug.info.PackageInfo;
import org.teavm.backend.wasm.debug.parser.DebugSectionParser;
import org.teavm.backend.wasm.debug.parser.DebugStringParser;

public class DebugPackageParser
extends DebugSectionParser {
    private DebugStringParser strings;
    private PackageInfoImpl[] packages;

    public DebugPackageParser(DebugStringParser strings) {
        super("teavm_pkg", strings);
        this.strings = strings;
    }

    public PackageInfo getPackage(int index) {
        return index == 0 ? null : this.packages[index - 1];
    }

    @Override
    protected void doParse() {
        int i;
        ArrayList<PackageBuilder> packageBuilders = new ArrayList<PackageBuilder>();
        while (this.ptr < this.data.length) {
            packageBuilders.add(new PackageBuilder(this.readLEB(), this.strings.getString(this.readLEB())));
        }
        this.packages = new PackageInfoImpl[packageBuilders.size()];
        for (i = 0; i < this.packages.length; ++i) {
            this.packages[i] = new PackageInfoImpl(((PackageBuilder)packageBuilders.get((int)i)).name);
        }
        for (i = 0; i < this.packages.length; ++i) {
            this.packages[i].parent = this.getPackage(((PackageBuilder)packageBuilders.get((int)i)).parent);
        }
    }

    private static class PackageInfoImpl
    extends PackageInfo {
        private PackageInfo parent;
        private String name;

        PackageInfoImpl(String name) {
            this.name = name;
        }

        @Override
        public PackageInfo parent() {
            return this.parent;
        }

        @Override
        public String name() {
            return this.name;
        }
    }

    private static class PackageBuilder {
        int parent;
        String name;

        PackageBuilder(int parent, String name) {
            this.parent = parent;
            this.name = name;
        }
    }
}

