/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime;

import org.teavm.interop.Address;
import org.teavm.interop.Export;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.CallSite;
import org.teavm.runtime.CallSiteLocation;
import org.teavm.runtime.Console;
import org.teavm.runtime.ExceptionHandler;
import org.teavm.runtime.MethodLocation;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;
import org.teavm.runtime.ShadowStack;

@StaticInit
public final class ExceptionHandling {
    private static Throwable thrownException;

    private ExceptionHandling() {
    }

    @Unmanaged
    public static native CallSite findCallSiteById(int var0, Address var1);

    @Unmanaged
    public static native boolean isJumpSupported();

    @Unmanaged
    public static native void jumpToFrame(Address var0, int var1);

    @Unmanaged
    public static native void abort();

    @Unmanaged
    private static native boolean isObfuscated();

    @Unmanaged
    public static void printStack() {
        Address stackFrame = ShadowStack.getStackTop();
        while (stackFrame != null) {
            int callSiteId = ShadowStack.getCallSiteId(stackFrame);
            if (ExceptionHandling.isObfuscated()) {
                Console.printString("\tat Obfuscated.obfuscated(Obfuscated.java:");
                Console.printInt(callSiteId);
                Console.printString(")\n");
            } else {
                CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId, stackFrame);
                CallSiteLocation location = callSite.location;
                while (location != null) {
                    MethodLocation methodLocation = location.method;
                    if (methodLocation != null) {
                        Console.printString("\tat ");
                        if (methodLocation.className == null || methodLocation.methodName == null) {
                            Console.printString("(Unknown method)");
                        } else {
                            Console.printString(methodLocation.className.value);
                            Console.printString(".");
                            Console.printString(methodLocation.methodName.value);
                        }
                        Console.printString("(");
                        if (methodLocation.fileName != null && location.lineNumber >= 0) {
                            Console.printString(methodLocation.fileName.value);
                            Console.printString(":");
                            Console.printInt(location.lineNumber);
                        }
                        Console.printString(")\n");
                    }
                    location = location.next;
                }
            }
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
    }

    @Export(name="teavm_catchException")
    @Unmanaged
    public static Throwable catchException() {
        Throwable exception = thrownException;
        thrownException = null;
        return exception;
    }

    @Unmanaged
    public static Throwable peekException() {
        return thrownException;
    }

    @Unmanaged
    public static void throwException(Throwable exception) {
        int callSiteId;
        thrownException = exception;
        RuntimeObject exceptionPtr = (RuntimeObject)Address.ofObject((Object)exception).toStructure();
        RuntimeClass exceptionClass = RuntimeClass.getClass(exceptionPtr);
        Address stackFrame = ShadowStack.getStackTop();
        int handlerId = 0;
        block0: while (stackFrame != null) {
            callSiteId = ShadowStack.getCallSiteId(stackFrame);
            if (callSiteId >= 0) {
                CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId, stackFrame);
                ExceptionHandler handler = callSite.firstHandler;
                while (handler != null) {
                    if (handler.exceptionClass == null || handler.exceptionClass.isSupertypeOf.apply(exceptionClass)) {
                        handlerId = handler.id;
                        if (ExceptionHandling.isJumpSupported()) break block0;
                        ShadowStack.setExceptionHandlerId(stackFrame, handlerId);
                        break block0;
                    }
                    handler = handler.next;
                }
                if (!ExceptionHandling.isJumpSupported()) {
                    ShadowStack.setExceptionHandlerSkip(stackFrame);
                }
            }
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
        if (stackFrame == null) {
            if (!ExceptionHandling.isJumpSupported()) {
                stackFrame = ShadowStack.getStackTop();
                while (stackFrame != null) {
                    callSiteId = ShadowStack.getCallSiteId(stackFrame);
                    if (callSiteId >= 0) {
                        ShadowStack.setExceptionHandlerRestore(stackFrame);
                    }
                    stackFrame = ShadowStack.getNextStackFrame(stackFrame);
                }
            }
            ExceptionHandling.printStack();
            ExceptionHandling.abort();
        } else {
            ExceptionHandling.jumpToFrame(stackFrame, handlerId);
        }
    }

    @Unmanaged
    public static void throwClassCastException() {
        ExceptionHandling.throwException(new ClassCastException());
    }

    @Unmanaged
    @Export(name="teavm_throwNullPointerException")
    public static void throwNullPointerException() {
        ExceptionHandling.throwException(new NullPointerException());
    }

    @Unmanaged
    @Export(name="teavm_throwArrayIndexOutOfBoundsException")
    public static void throwArrayIndexOutOfBoundsException() {
        ExceptionHandling.throwException(new ArrayIndexOutOfBoundsException());
    }

    @Unmanaged
    private static int callStackSize() {
        Address stackFrame = ShadowStack.getStackTop();
        int size = 0;
        while (stackFrame != null) {
            int callSiteId = ShadowStack.getCallSiteId(stackFrame);
            if (callSiteId >= 0) {
                CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId, stackFrame);
                CallSiteLocation location = callSite.location;
                if (ExceptionHandling.isObfuscated() || location == null) {
                    ++size;
                } else {
                    while (location != null) {
                        ++size;
                        location = location.next;
                    }
                }
            }
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
        return size;
    }

    @Unmanaged
    public static StackTraceElement[] fillStackTrace() {
        Address stackFrame = ShadowStack.getStackTop();
        int size = ExceptionHandling.callStackSize();
        ShadowStack.allocStack(1);
        ShadowStack.removeGCRoot(0);
        StackTraceElement[] target = new StackTraceElement[size];
        ShadowStack.registerGCRoot(0, target);
        int index = 0;
        while (stackFrame != null) {
            int callSiteId = ShadowStack.getCallSiteId(stackFrame);
            if (callSiteId >= 0) {
                CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId, stackFrame);
                CallSiteLocation location = callSite.location;
                if (ExceptionHandling.isObfuscated()) {
                    target[index++] = new StackTraceElement("Obfuscated", "obfuscated", "Obfuscated.java", callSiteId);
                } else if (location == null) {
                    target[index++] = new StackTraceElement("", "", null, -1);
                } else {
                    while (location != null) {
                        MethodLocation methodLocation = location.method;
                        StackTraceElement element = methodLocation != null ? new StackTraceElement(methodLocation.className != null ? methodLocation.className.value : "", methodLocation.methodName != null ? methodLocation.methodName.value : "", methodLocation.fileName != null ? methodLocation.fileName.value : null, location.lineNumber) : new StackTraceElement("", "", null, location.lineNumber);
                        target[index++] = element;
                        location = location.next;
                    }
                }
            }
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
        ShadowStack.releaseStack(1);
        return target;
    }
}

