/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.teavm.ast.ControlFlowEntry;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.model.BasicBlock;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.Incoming;
import org.teavm.model.IncomingReader;
import org.teavm.model.Instruction;
import org.teavm.model.InstructionIterator;
import org.teavm.model.InstructionReadVisitor;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.PhiReader;
import org.teavm.model.Program;
import org.teavm.model.ProgramReader;
import org.teavm.model.TextLocation;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.TryCatchBlockReader;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.util.AssignmentExtractor;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.InstructionCopyReader;
import org.teavm.model.util.LocationGraphBuilder;
import org.teavm.model.util.ModelUtils;
import org.teavm.model.util.TransitionExtractor;

public final class ProgramUtils {
    private static final MethodReference NPE_INIT_METHOD = new MethodReference(NullPointerException.class, "<init>", Void.TYPE);

    private ProgramUtils() {
    }

    public static Graph buildControlFlowGraph(Program program) {
        GraphBuilder graphBuilder = new GraphBuilder(program.basicBlockCount());
        TransitionExtractor transitionExtractor = new TransitionExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Instruction insn = block.getLastInstruction();
            if (insn != null) {
                insn.acceptVisitor(transitionExtractor);
                if (transitionExtractor.getTargets() != null) {
                    for (BasicBlock successor : transitionExtractor.getTargets()) {
                        graphBuilder.addEdge(i, successor.getIndex());
                    }
                }
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                graphBuilder.addEdge(i, tryCatch.getHandler().getIndex());
            }
        }
        return graphBuilder.build();
    }

    public static Graph buildControlFlowGraph2(Program program) {
        GraphBuilder graphBuilder = new GraphBuilder(program.basicBlockCount());
        TransitionExtractor transitionExtractor = new TransitionExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            graphBuilder.addEdge(i * 2, i * 2 + 1);
            BasicBlock block = program.basicBlockAt(i);
            Instruction insn = block.getLastInstruction();
            if (insn != null) {
                insn.acceptVisitor(transitionExtractor);
                if (transitionExtractor.getTargets() != null) {
                    for (BasicBlock successor : transitionExtractor.getTargets()) {
                        graphBuilder.addEdge(i * 2 + 1, successor.getIndex() * 2);
                    }
                }
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                graphBuilder.addEdge(i * 2, tryCatch.getHandler().getIndex() * 2);
            }
        }
        return graphBuilder.build();
    }

    public static ControlFlowEntry[] getLocationCFG(Program program) {
        return new LocationGraphBuilder().build(program);
    }

    public static Program copy(ProgramReader program) {
        int i;
        Program copy = new Program();
        for (i = 0; i < program.variableCount(); ++i) {
            Variable var = copy.createVariable();
            var.setDebugName(program.variableAt(i).getDebugName());
            var.setLabel(program.variableAt(i).getLabel());
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            copy.createBasicBlock();
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlockReader block = program.basicBlockAt(i);
            BasicBlock blockCopy = copy.basicBlockAt(i);
            ProgramUtils.copyBasicBlock(block, blockCopy);
        }
        ModelUtils.copyAnnotations(program.getAnnotations(), copy.getAnnotations());
        return copy;
    }

    public static void copyBasicBlock(BasicBlockReader block, BasicBlock target) {
        Program targetProgram = target.getProgram();
        if (block.getExceptionVariable() != null) {
            target.setExceptionVariable(targetProgram.variableAt(block.getExceptionVariable().getIndex()));
        }
        InstructionCopyReader copyReader = new InstructionCopyReader(targetProgram);
        InstructionIterator iterator = block.iterateInstructions();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.read(copyReader);
            target.add(copyReader.getCopy());
        }
        target.getPhis().addAll(ProgramUtils.copyPhis(block, targetProgram));
        target.getTryCatchBlocks().addAll(ProgramUtils.copyTryCatches(block, targetProgram));
    }

    public static List<Instruction> copyInstructions(Instruction from, Instruction to, Program target) {
        ArrayList<Instruction> result = new ArrayList<Instruction>();
        InstructionCopyReader copyReader = new InstructionCopyReader(target);
        InstructionReadVisitor visitor = new InstructionReadVisitor(copyReader);
        while (from != to) {
            from.acceptVisitor(visitor);
            copyReader.getCopy().setLocation(from.getLocation());
            result.add(copyReader.getCopy());
            from = from.getNext();
        }
        return result;
    }

    public static List<Phi> copyPhis(BasicBlockReader block, Program target) {
        ArrayList<Phi> result = new ArrayList<Phi>();
        for (PhiReader phiReader : block.readPhis()) {
            Phi phiCopy = new Phi();
            phiCopy.setReceiver(target.variableAt(phiReader.getReceiver().getIndex()));
            for (IncomingReader incomingReader : phiReader.readIncomings()) {
                Incoming incomingCopy = new Incoming();
                incomingCopy.setSource(target.basicBlockAt(incomingReader.getSource().getIndex()));
                incomingCopy.setValue(target.variableAt(incomingReader.getValue().getIndex()));
                phiCopy.getIncomings().add(incomingCopy);
            }
            result.add(phiCopy);
        }
        return result;
    }

    public static List<TryCatchBlock> copyTryCatches(BasicBlockReader block, Program target) {
        ArrayList<TryCatchBlock> result = new ArrayList<TryCatchBlock>();
        for (TryCatchBlockReader tryCatchBlockReader : block.readTryCatchBlocks()) {
            TryCatchBlock tryCatchCopy = new TryCatchBlock();
            tryCatchCopy.setExceptionType(tryCatchBlockReader.getExceptionType());
            tryCatchCopy.setHandler(target.basicBlockAt(tryCatchBlockReader.getHandler().getIndex()));
            result.add(tryCatchCopy);
        }
        return result;
    }

    public static List<List<Incoming>> getPhiOutputs(Program program) {
        int i;
        ArrayList<List<Incoming>> outputs = new ArrayList<List<Incoming>>(program.basicBlockCount());
        for (i = 0; i < program.basicBlockCount(); ++i) {
            outputs.add(new ArrayList());
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    ((List)outputs.get(incoming.getSource().getIndex())).add(incoming);
                }
            }
        }
        return outputs;
    }

    public static BasicBlock[] getVariableDefinitionPlaces(Program program) {
        BasicBlock[] places = new BasicBlock[program.variableCount()];
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Variable exceptionVar = block.getExceptionVariable();
            if (exceptionVar != null) {
                places[exceptionVar.getIndex()] = block;
            }
            for (Phi phi : block.getPhis()) {
                places[phi.getReceiver().getIndex()] = block;
            }
            for (Instruction insn : block) {
                insn.acceptVisitor(defExtractor);
                for (Variable var : defExtractor.getDefinedVariables()) {
                    places[var.getIndex()] = block;
                }
            }
        }
        return places;
    }

    public static void makeUniqueLabels(Program program) {
        HashSet<Object> occupiedLabels = new HashSet<Object>();
        for (int i = 0; i < program.variableCount(); ++i) {
            Variable var = program.variableAt(i);
            if (var.getLabel() == null) continue;
            Object suggestedName = var.getLabel();
            if (!occupiedLabels.add(suggestedName)) {
                int suffix = 1;
                String base = (String)suggestedName + "_";
                while (!occupiedLabels.add(suggestedName = base + suffix++)) {
                }
            }
            var.setLabel((String)suggestedName);
        }
    }

    public static List<Instruction> createThrowNPEInstructions(Program program, TextLocation location) {
        ConstructInstruction newNPE = new ConstructInstruction();
        newNPE.setType(NullPointerException.class.getName());
        newNPE.setReceiver(program.createVariable());
        newNPE.setLocation(location);
        InvokeInstruction initNPE = new InvokeInstruction();
        initNPE.setType(InvocationType.SPECIAL);
        initNPE.setInstance(newNPE.getReceiver());
        initNPE.setMethod(NPE_INIT_METHOD);
        initNPE.setLocation(location);
        RaiseInstruction raise = new RaiseInstruction();
        raise.setException(newNPE.getReceiver());
        raise.setLocation(location);
        return Arrays.asList(newNPE, initNPE, raise);
    }

    public static List<Variable> getVariablesDefinedInBlock(BasicBlock block, DefinitionExtractor defExtractor) {
        ArrayList<Variable> varsDefinedInBlock = new ArrayList<Variable>();
        for (Phi phi : block.getPhis()) {
            varsDefinedInBlock.add(phi.getReceiver());
        }
        if (block.getExceptionVariable() != null) {
            varsDefinedInBlock.add(block.getExceptionVariable());
        }
        for (Instruction instruction : block) {
            instruction.acceptVisitor(defExtractor);
            Variable[] varsDefinedByInstruction = defExtractor.getDefinedVariables();
            if (varsDefinedByInstruction == null) continue;
            varsDefinedInBlock.addAll(Arrays.asList(varsDefinedByInstruction));
        }
        return varsDefinedInBlock;
    }

    public static void truncateBlock(Instruction instruction) {
        TransitionExtractor transitionExtractor = new TransitionExtractor();
        BasicBlock block = instruction.getBasicBlock();
        if (block.getLastInstruction() != null) {
            block.getLastInstruction().acceptVisitor(transitionExtractor);
        }
        for (BasicBlock successor : transitionExtractor.getTargets()) {
            successor.removeIncomingsFrom(block);
        }
        if (!block.getTryCatchBlocks().isEmpty()) {
            LinkedHashSet<BasicBlock> handlers = new LinkedHashSet<BasicBlock>();
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                handlers.add(tryCatch.getHandler());
            }
            AssignmentExtractor assignExtractor = new AssignmentExtractor();
            for (Instruction next = instruction; next != null; next = next.getNext()) {
                next.acceptVisitor(assignExtractor);
                Variable definition = assignExtractor.getResult();
                if (definition == null) continue;
                for (BasicBlock handler : handlers) {
                    for (Phi phi : handler.getPhis()) {
                        Iterator<Incoming> iter = phi.getIncomings().iterator();
                        while (iter.hasNext()) {
                            Incoming incoming = iter.next();
                            if (incoming.getSource() != block || incoming.getValue() != definition) continue;
                            iter.remove();
                        }
                    }
                }
            }
        }
        while (instruction.getNext() != null) {
            instruction.getNext().delete();
        }
    }
}

