/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.analysis;

import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ClassMetadataRequirements {
    private static final MethodReference GET_NAME_METHOD = new MethodReference(Class.class, "getName", String.class);
    private static final MethodReference GET_SIMPLE_NAME_METHOD = new MethodReference(Class.class, "getSimpleName", String.class);
    private static final MethodReference GET_SUPERCLASS_METHOD = new MethodReference(Class.class, "getSuperclass", Class.class);
    private static final MethodReference IS_ASSIGNABLE_METHOD = new MethodReference(Class.class, "isAssignableFrom", Class.class, Boolean.TYPE);
    private static final MethodReference GET_DECLARING_CLASS_METHOD = new MethodReference(Class.class, "getDeclaringClass", Class.class);
    private static final MethodReference GET_ENCLOSING_CLASS_METHOD = new MethodReference(Class.class, "getEnclosingClass", Class.class);
    private static final MethodReference NEW_ARRAY = new MethodReference(Array.class, "newInstance", Class.class, Integer.TYPE, Object.class);
    private static final MethodReference ARRAY_GET = new MethodReference(Array.class, "get", Object.class, Integer.TYPE, Object.class);
    private static final MethodReference ARRAY_SET = new MethodReference(Array.class, "set", Object.class, Integer.TYPE, Object.class, Void.TYPE);
    private static final MethodReference ARRAY_LENGTH = new MethodReference(Array.class, "getLength", Object.class, Integer.TYPE);
    private static final MethodReference ARRAY_COPY = new MethodReference(System.class, "arraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Void.TYPE);
    private static final ClassInfo EMPTY_INFO = new ClassInfo();
    private Map<ValueType, ClassInfo> requirements = new HashMap<ValueType, ClassInfo>();
    private boolean hasArrayGet;
    private boolean hasArraySet;
    private boolean hasArrayLength;
    private boolean hasArrayCopy;
    private boolean hasEnumConstants;
    private boolean hasSuperclass;
    private boolean hasIsAssignable;
    private boolean hasArrayNewInstance;
    private boolean hasNewInstance;
    private boolean hasClassInit;
    private boolean hasEnclosingClass;
    private boolean hasDeclaringClass;
    private boolean hasSimpleName;
    private boolean hasName;
    private boolean hasGetAnnotations;
    private boolean hasGetInterfaces;
    private boolean hasGetFields;
    private boolean hasGetMethods;

    public ClassMetadataRequirements(DependencyInfo dependencyInfo) {
        MethodDependencyInfo classInit;
        MethodDependencyInfo newInstance;
        MethodDependencyInfo getConstructors;
        MethodDependencyInfo methodDependencyInfo;
        MethodDependencyInfo getFields;
        MethodDependencyInfo getInterfaces;
        MethodDependencyInfo clone;
        MethodDependencyInfo arrayCopy;
        MethodDependencyInfo arrayLength;
        MethodDependencyInfo arraySet;
        MethodDependencyInfo arrayGet;
        MethodDependencyInfo newArrayMethod;
        MethodDependencyInfo getEnclosingClassMethod;
        MethodDependencyInfo getDeclaringClassMethod;
        MethodDependencyInfo isAssignableMethod;
        MethodDependencyInfo getSuperclassMethod;
        MethodDependencyInfo getSimpleNameMethod;
        MethodDependencyInfo getNameMethod = dependencyInfo.getMethod(GET_NAME_METHOD);
        if (getNameMethod != null) {
            this.hasName = true;
            this.addClassesRequiringName(this.requirements, getNameMethod.getVariable(0).getClassValueNode().getTypes());
        }
        if ((getSimpleNameMethod = dependencyInfo.getMethod(GET_SIMPLE_NAME_METHOD)) != null) {
            this.hasSimpleName = true;
            String[] classNames = getSimpleNameMethod.getVariable(0).getClassValueNode().getTypes();
            this.addClassesRequiringName(this.requirements, classNames);
            for (String className : classNames) {
                ClassInfo classInfo = this.requirements.computeIfAbsent(this.decodeType(className), k -> new ClassInfo());
                classInfo.simpleName = true;
                classInfo.enclosingClass = true;
            }
        }
        if ((getSuperclassMethod = dependencyInfo.getMethod(GET_SUPERCLASS_METHOD)) != null) {
            String[] classNames;
            this.hasSuperclass = true;
            for (String className : classNames = getSuperclassMethod.getVariable(0).getClassValueNode().getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$1(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).superclass = true;
            }
        }
        if ((isAssignableMethod = dependencyInfo.getMethod(IS_ASSIGNABLE_METHOD)) != null) {
            String[] classNames;
            this.hasIsAssignable = true;
            for (String className : classNames = isAssignableMethod.getVariable(0).getClassValueNode().getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$2(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).isAssignable = true;
            }
        }
        if ((getDeclaringClassMethod = dependencyInfo.getMethod(GET_DECLARING_CLASS_METHOD)) != null) {
            String[] classNames;
            this.hasDeclaringClass = true;
            for (String className : classNames = getDeclaringClassMethod.getVariable(0).getClassValueNode().getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$3(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).declaringClass = true;
            }
        }
        if ((getEnclosingClassMethod = dependencyInfo.getMethod(GET_ENCLOSING_CLASS_METHOD)) != null) {
            String[] classNames;
            this.hasEnclosingClass = true;
            for (String className : classNames = getEnclosingClassMethod.getVariable(0).getClassValueNode().getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$4(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).enclosingClass = true;
            }
        }
        if ((newArrayMethod = dependencyInfo.getMethod(NEW_ARRAY)) != null) {
            String[] classNames;
            this.hasArrayNewInstance = true;
            for (String className : classNames = newArrayMethod.getVariable(1).getClassValueNode().getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$5(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).newArray = true;
            }
        }
        if ((arrayGet = dependencyInfo.getMethod(ARRAY_GET)) != null) {
            String[] classNames;
            this.hasArrayGet = arrayGet.isUsed();
            for (String className : classNames = arrayGet.getVariable(1).getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$6(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).arrayGet = true;
            }
        }
        if ((arraySet = dependencyInfo.getMethod(ARRAY_SET)) != null) {
            String[] classNames;
            this.hasArraySet = arraySet.isUsed();
            for (String className : classNames = arraySet.getVariable(1).getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$7(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).arraySet = true;
            }
        }
        if ((arrayLength = dependencyInfo.getMethod(ARRAY_LENGTH)) != null) {
            String[] classNames;
            this.hasArrayLength = arrayLength.isUsed();
            for (String className : classNames = arrayLength.getVariable(1).getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$8(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).arrayLength = true;
            }
        }
        if ((arrayCopy = dependencyInfo.getMethod(ARRAY_COPY)) != null) {
            String[] classNames;
            this.hasArrayCopy = arrayCopy.isUsed();
            for (String className : classNames = arrayCopy.getVariable(1).getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$9(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).arrayCopy = true;
            }
        }
        if ((clone = dependencyInfo.getMethod(new MethodReference(Object.class, "cloneObject", Object.class))) != null) {
            String[] classNames;
            for (String string : classNames = clone.getVariable(0).getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)string), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$10(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).cloneMethod = true;
            }
        }
        List<MethodDependencyInfo> enumConstants = Arrays.asList(dependencyInfo.getMethod(new MethodReference("org.teavm.platform.Platform", "getEnumConstants", ValueType.object("org.teavm.platform.PlatformClass"), ValueType.parse(Enum[].class))), dependencyInfo.getMethod(new MethodReference("org.teavm.classlib.impl.reflection.ClassSupport", "getEnumConstants", ValueType.parse(Class.class), ValueType.parse(Enum[].class))));
        for (MethodDependencyInfo enumConstantsDep : enumConstants) {
            String[] classNames;
            if (enumConstantsDep == null) continue;
            this.hasEnumConstants = true;
            String[] stringArray = classNames = enumConstantsDep.getVariable(1).getClassValueNode().getTypes();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String className2 = stringArray[i];
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className2), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$11(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).enumConstants = true;
            }
        }
        MethodDependencyInfo getAnnotations = dependencyInfo.getMethod(new MethodReference(Class.class, "getDeclaredAnnotations", Annotation[].class));
        if (getAnnotations != null && getAnnotations.isUsed()) {
            String[] classNames;
            this.hasGetAnnotations = true;
            for (String className : classNames = getAnnotations.getVariable(0).getClassValueNode().getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$12(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).annotations = true;
            }
        }
        if ((getInterfaces = dependencyInfo.getMethod(new MethodReference(Class.class, "getInterfaces", Class[].class))) != null && getInterfaces.isUsed()) {
            String[] classNames;
            this.hasGetInterfaces = true;
            for (String className : classNames = getInterfaces.getVariable(0).getClassValueNode().getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$13(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).interfaces = true;
            }
        }
        if ((getFields = dependencyInfo.getMethod(new MethodReference(Class.class, "getDeclaredFields", Field[].class))) != null && getFields.isUsed()) {
            this.hasGetFields = true;
        }
        if ((methodDependencyInfo = dependencyInfo.getMethod(new MethodReference(Class.class, "getDeclaredMethods", Method[].class))) != null && methodDependencyInfo.isUsed()) {
            this.hasGetMethods = true;
        }
        if ((getConstructors = dependencyInfo.getMethod(new MethodReference(Class.class, "getDeclaredConstructors", Constructor[].class))) != null && getConstructors.isUsed()) {
            this.hasGetMethods = true;
        }
        if ((newInstance = dependencyInfo.getMethod(new MethodReference(Class.class, "newInstance", Object.class))) != null && newInstance.isUsed()) {
            this.hasNewInstance = true;
        }
        if ((classInit = dependencyInfo.getMethod(new MethodReference(Class.class, "initialize", Void.TYPE))) != null && classInit.isUsed()) {
            String[] classNames;
            this.hasClassInit = true;
            for (String className : classNames = classInit.getVariable(0).getClassValueNode().getTypes()) {
                this.requirements.computeIfAbsent((ValueType)this.decodeType((String)className), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$14(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).classInit = true;
            }
        }
    }

    public Info getInfo(String className) {
        return this.getInfo(ValueType.object(className));
    }

    public Info getInfo(ValueType className) {
        ClassInfo result = this.requirements.get(className);
        if (result == null) {
            result = EMPTY_INFO;
        }
        return result;
    }

    public boolean hasArrayGet() {
        return this.hasArrayGet;
    }

    public boolean hasArraySet() {
        return this.hasArraySet;
    }

    public boolean hasArrayLength() {
        return this.hasArrayLength;
    }

    public boolean hasArrayCopy() {
        return this.hasArrayCopy;
    }

    public boolean hasEnumConstants() {
        return this.hasEnumConstants;
    }

    public boolean hasSuperclass() {
        return this.hasSuperclass;
    }

    public boolean hasIsAssignable() {
        return this.hasIsAssignable;
    }

    public boolean hasArrayNewInstance() {
        return this.hasArrayNewInstance;
    }

    public boolean hasEnclosingClass() {
        return this.hasEnclosingClass;
    }

    public boolean hasDeclaringClass() {
        return this.hasDeclaringClass;
    }

    public boolean hasSimpleName() {
        return this.hasSimpleName;
    }

    public boolean hasName() {
        return this.hasName;
    }

    public boolean hasGetAnnotations() {
        return this.hasGetAnnotations;
    }

    public boolean hasGetInterfaces() {
        return this.hasGetInterfaces;
    }

    public boolean hasGetFields() {
        return this.hasGetFields;
    }

    public boolean hasGetMethods() {
        return this.hasGetMethods;
    }

    public boolean hasNewInstance() {
        return this.hasNewInstance;
    }

    public boolean hasClassInit() {
        return this.hasClassInit;
    }

    private void addClassesRequiringName(Map<ValueType, ClassInfo> target, String[] source) {
        for (String typeName : source) {
            target.computeIfAbsent((ValueType)this.decodeType((String)typeName), (Function<ValueType, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addClassesRequiringName$15(org.teavm.model.ValueType ), (Lorg/teavm/model/ValueType;)Lorg/teavm/model/analysis/ClassMetadataRequirements$ClassInfo;)()).name = true;
        }
    }

    private ValueType decodeType(String typeName) {
        if (typeName.startsWith("[")) {
            return ValueType.parseIfPossible(typeName);
        }
        if (typeName.startsWith("~")) {
            return ValueType.parseIfPossible(typeName.substring(1));
        }
        return ValueType.object(typeName);
    }

    private static /* synthetic */ ClassInfo lambda$addClassesRequiringName$15(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$14(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$13(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$12(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$11(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$10(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$9(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$8(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$7(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$6(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$5(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$4(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$3(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$2(ValueType k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$1(ValueType k) {
        return new ClassInfo();
    }

    static class ClassInfo
    implements Info {
        boolean name;
        boolean simpleName;
        boolean declaringClass;
        boolean enclosingClass;
        boolean superclass;
        boolean isAssignable;
        boolean newArray;
        boolean arrayLength;
        boolean arrayGet;
        boolean arraySet;
        boolean arrayCopy;
        boolean cloneMethod;
        boolean enumConstants;
        boolean annotations;
        boolean interfaces;
        boolean classInit;

        ClassInfo() {
        }

        @Override
        public boolean name() {
            return this.name;
        }

        @Override
        public boolean simpleName() {
            return this.simpleName;
        }

        @Override
        public boolean declaringClass() {
            return this.declaringClass;
        }

        @Override
        public boolean enclosingClass() {
            return this.enclosingClass;
        }

        @Override
        public boolean superclass() {
            return this.superclass;
        }

        @Override
        public boolean isAssignable() {
            return this.isAssignable;
        }

        @Override
        public boolean newArray() {
            return this.newArray;
        }

        @Override
        public boolean arrayLength() {
            return this.arrayLength;
        }

        @Override
        public boolean arrayCopy() {
            return this.arrayCopy;
        }

        @Override
        public boolean arrayGet() {
            return this.arrayGet;
        }

        @Override
        public boolean arraySet() {
            return this.arraySet;
        }

        @Override
        public boolean cloneMethod() {
            return this.cloneMethod;
        }

        @Override
        public boolean enumConstants() {
            return this.enumConstants;
        }

        @Override
        public boolean annotations() {
            return this.annotations;
        }

        @Override
        public boolean interfaces() {
            return this.interfaces;
        }

        @Override
        public boolean classInit() {
            return this.classInit;
        }
    }

    public static interface Info {
        public boolean name();

        public boolean simpleName();

        public boolean declaringClass();

        public boolean enclosingClass();

        public boolean superclass();

        public boolean isAssignable();

        public boolean newArray();

        public boolean arrayLength();

        public boolean arrayGet();

        public boolean arraySet();

        public boolean arrayCopy();

        public boolean cloneMethod();

        public boolean enumConstants();

        public boolean annotations();

        public boolean interfaces();

        public boolean classInit();
    }
}

