/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.callgraph.CallGraph;
import org.teavm.dependency.DefaultCallGraphNode;
import org.teavm.dependency.DefaultCallSite;
import org.teavm.dependency.DefaultFieldAccessSite;
import org.teavm.dependency.SerializableCallGraph;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;

class DefaultCallGraph
implements CallGraph,
Serializable {
    public Map<MethodReference, DefaultCallGraphNode> nodes = new HashMap<MethodReference, DefaultCallGraphNode>();
    Map<FieldReference, Set<DefaultFieldAccessSite>> fieldAccessSites = new HashMap<FieldReference, Set<DefaultFieldAccessSite>>();

    DefaultCallGraph() {
    }

    @Override
    public DefaultCallGraphNode getNode(MethodReference method) {
        return this.nodes.computeIfAbsent(method, k -> new DefaultCallGraphNode(this, (MethodReference)k));
    }

    public Collection<DefaultFieldAccessSite> getFieldAccess(FieldReference reference) {
        Set<DefaultFieldAccessSite> resultSet = this.fieldAccessSites.get(reference);
        return resultSet != null ? Collections.unmodifiableSet(resultSet) : Collections.emptySet();
    }

    void addFieldAccess(DefaultFieldAccessSite accessSite) {
        this.fieldAccessSites.computeIfAbsent(accessSite.getField(), k -> new LinkedHashSet()).add(accessSite);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializableCallGraphBuilder builder = new SerializableCallGraphBuilder();
        out.writeObject(builder.build(this));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SerializableCallGraph scg = (SerializableCallGraph)in.readObject();
        this.nodes = new LinkedHashMap<MethodReference, DefaultCallGraphNode>();
        this.fieldAccessSites = new LinkedHashMap<FieldReference, Set<DefaultFieldAccessSite>>();
        new CallGraphBuilder().build(scg, this);
    }

    static class SerializableCallGraphBuilder {
        List<SerializableCallGraph.Node> nodes = new ArrayList<SerializableCallGraph.Node>();
        ObjectIntMap<DefaultCallGraphNode> nodeToIndex = new ObjectIntHashMap();
        List<SerializableCallGraph.CallSite> callSites = new ArrayList<SerializableCallGraph.CallSite>();
        ObjectIntMap<DefaultCallSite> callSiteToIndex = new ObjectIntHashMap();
        List<SerializableCallGraph.FieldAccess> fieldAccessList = new ArrayList<SerializableCallGraph.FieldAccess>();
        ObjectIntMap<DefaultFieldAccessSite> fieldAccessToIndex = new ObjectIntHashMap();
        List<DefaultCallGraphNode> nodesToProcess = new ArrayList<DefaultCallGraphNode>();
        List<DefaultCallSite> callSitesToProcess = new ArrayList<DefaultCallSite>();
        List<DefaultFieldAccessSite> fieldAccessToProcess = new ArrayList<DefaultFieldAccessSite>();

        SerializableCallGraphBuilder() {
        }

        SerializableCallGraph build(DefaultCallGraph cg) {
            SerializableCallGraph scg = new SerializableCallGraph();
            scg.nodeIndexes = cg.nodes.values().stream().mapToInt(this::getNode).toArray();
            scg.fieldAccessIndexes = cg.fieldAccessSites.values().stream().flatMapToInt(accessSites -> accessSites.stream().mapToInt(this::getFieldAccess)).toArray();
            while (this.step()) {
            }
            scg.nodes = this.nodes.toArray(new SerializableCallGraph.Node[0]);
            scg.callSites = this.callSites.toArray(new SerializableCallGraph.CallSite[0]);
            scg.fieldAccessList = this.fieldAccessList.toArray(new SerializableCallGraph.FieldAccess[0]);
            return scg;
        }

        boolean step() {
            return this.processNodes() | this.processCallSites() | this.processFieldAccess();
        }

        boolean processNodes() {
            boolean hasAny = false;
            for (DefaultCallGraphNode node : this.nodesToProcess.toArray(new DefaultCallGraphNode[0])) {
                int index = this.nodeToIndex.get((Object)node);
                SerializableCallGraph.Node serializableNode = this.nodes.get(index);
                serializableNode.method = node.getMethod();
                serializableNode.callSites = node.getCallSites().stream().mapToInt(this::getCallSite).toArray();
                serializableNode.callerCallSites = node.getCallerCallSites().stream().mapToInt(this::getCallSite).toArray();
                serializableNode.fieldAccessSites = node.getFieldAccessSites().stream().mapToInt(this::getFieldAccess).toArray();
                hasAny = true;
            }
            this.nodesToProcess.clear();
            return hasAny;
        }

        boolean processCallSites() {
            boolean hasAny = false;
            for (DefaultCallSite callSite : this.callSitesToProcess.toArray(new DefaultCallSite[0])) {
                int index = this.callSiteToIndex.get((Object)callSite);
                SerializableCallGraph.CallSite scs = this.callSites.get(index);
                scs.virtual = callSite.callers != null;
                ArrayList<SerializableCallGraph.Location> locations = new ArrayList<SerializableCallGraph.Location>();
                for (DefaultCallGraphNode defaultCallGraphNode : callSite.getCallers()) {
                    for (TextLocation textLocation : callSite.getLocations(defaultCallGraphNode)) {
                        SerializableCallGraph.Location location = new SerializableCallGraph.Location();
                        location.caller = this.getNode(defaultCallGraphNode);
                        location.value = textLocation;
                        locations.add(location);
                    }
                }
                scs.locations = locations.toArray(new SerializableCallGraph.Location[0]);
                scs.callers = this.getNodes(callSite.getCallers());
                scs.calledMethods = this.getNodes(callSite.getCalledMethods());
                hasAny = true;
            }
            this.callSitesToProcess.clear();
            return hasAny;
        }

        boolean processFieldAccess() {
            boolean hasAny = false;
            for (DefaultFieldAccessSite accessSite : this.fieldAccessToProcess.toArray(new DefaultFieldAccessSite[0])) {
                int index = this.fieldAccessToIndex.get((Object)accessSite);
                SerializableCallGraph.FieldAccess sfa = this.fieldAccessList.get(index);
                sfa.location = accessSite.getLocation();
                sfa.field = accessSite.getField();
                sfa.callee = this.getNode(accessSite.getCallee());
                hasAny = true;
            }
            this.fieldAccessToProcess.clear();
            return hasAny;
        }

        private int getNode(DefaultCallGraphNode node) {
            int index = this.nodeToIndex.getOrDefault((Object)node, -1);
            if (index < 0) {
                index = this.nodeToIndex.size();
                this.nodeToIndex.put((Object)node, index);
                this.nodes.add(new SerializableCallGraph.Node());
                this.nodesToProcess.add(node);
            }
            return index;
        }

        private int[] getNodes(Collection<? extends DefaultCallGraphNode> nodes) {
            int[] result = new int[nodes.size()];
            int index = 0;
            for (DefaultCallGraphNode defaultCallGraphNode : nodes) {
                result[index++] = this.getNode(defaultCallGraphNode);
            }
            return result;
        }

        private int getCallSite(DefaultCallSite callSite) {
            int index = this.callSiteToIndex.getOrDefault((Object)callSite, -1);
            if (index < 0) {
                index = this.callSiteToIndex.size();
                this.callSiteToIndex.put((Object)callSite, index);
                this.callSites.add(new SerializableCallGraph.CallSite());
                this.callSitesToProcess.add(callSite);
            }
            return index;
        }

        private int getFieldAccess(DefaultFieldAccessSite fieldAccessSite) {
            int index = this.fieldAccessToIndex.getOrDefault((Object)fieldAccessSite, -1);
            if (index < 0) {
                index = this.fieldAccessToIndex.size();
                this.fieldAccessToIndex.put((Object)fieldAccessSite, index);
                this.fieldAccessList.add(new SerializableCallGraph.FieldAccess());
                this.fieldAccessToProcess.add(fieldAccessSite);
            }
            return index;
        }
    }

    static class CallGraphBuilder {
        List<DefaultCallGraphNode> nodes = new ArrayList<DefaultCallGraphNode>();
        List<DefaultCallSite> callSites = new ArrayList<DefaultCallSite>();
        List<DefaultFieldAccessSite> fieldAccessList = new ArrayList<DefaultFieldAccessSite>();

        CallGraphBuilder() {
        }

        void build(SerializableCallGraph scg, DefaultCallGraph cg) {
            for (SerializableCallGraph.Node node : scg.nodes) {
                this.nodes.add(new DefaultCallGraphNode(cg, node.method));
            }
            for (Serializable serializable : scg.callSites) {
                DefaultCallSite callSite;
                if (((SerializableCallGraph.CallSite)serializable).virtual) {
                    callSite = new DefaultCallSite(((SerializableCallGraph.CallSite)serializable).method, this.mapNodes(((SerializableCallGraph.CallSite)serializable).callers));
                    callSite.calledMethods.addAll(this.mapNodes(((SerializableCallGraph.CallSite)serializable).calledMethods));
                } else {
                    callSite = new DefaultCallSite(this.nodes.get(((SerializableCallGraph.CallSite)serializable).calledMethods[0]), this.nodes.get(((SerializableCallGraph.CallSite)serializable).callers[0]));
                }
                for (SerializableCallGraph.Location location : ((SerializableCallGraph.CallSite)serializable).locations) {
                    callSite.addLocation(this.nodes.get(location.caller), location.value);
                }
                this.callSites.add(callSite);
            }
            for (Serializable serializable : scg.fieldAccessList) {
                this.fieldAccessList.add(new DefaultFieldAccessSite(((SerializableCallGraph.FieldAccess)serializable).location, this.nodes.get(((SerializableCallGraph.FieldAccess)serializable).callee), ((SerializableCallGraph.FieldAccess)serializable).field));
            }
            for (int i = 0; i < scg.nodes.length; ++i) {
                SerializableCallGraph.Node node = scg.nodes[i];
                DefaultCallGraphNode resultNode = this.nodes.get(i);
                if (node.callSites != null) {
                    for (int callSiteIndex : node.callSites) {
                        resultNode.addCallSite(this.callSites.get(callSiteIndex));
                    }
                }
                if (node.callerCallSites == null) continue;
                for (int callerCallSiteIndex : node.callerCallSites) {
                    resultNode.addCaller(this.callSites.get(callerCallSiteIndex));
                }
            }
            for (int n : scg.nodeIndexes) {
                DefaultCallGraphNode node = this.nodes.get(n);
                cg.nodes.put(node.getMethod(), node);
            }
            for (int n : scg.fieldAccessIndexes) {
                cg.addFieldAccess(this.fieldAccessList.get(n));
            }
        }

        private Set<DefaultCallGraphNode> mapNodes(int[] nodes) {
            LinkedHashSet<DefaultCallGraphNode> result = new LinkedHashSet<DefaultCallGraphNode>();
            for (int i = 0; i < nodes.length; ++i) {
                result.add(this.nodes.get(nodes[i]));
            }
            return result;
        }
    }
}

