/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.parser;

import org.teavm.backend.wasm.parser.BaseSectionParser;
import org.teavm.backend.wasm.parser.ImportSectionListener;
import org.teavm.backend.wasm.parser.ParseException;
import org.teavm.backend.wasm.parser.WasmHollowType;

public class ImportSectionParser
extends BaseSectionParser {
    private final ImportSectionListener listener;

    public ImportSectionParser(ImportSectionListener listener) {
        this.listener = listener;
    }

    @Override
    protected void parseContent() {
        int count = this.readLEB();
        for (int i = 0; i < count; ++i) {
            this.readEntry();
        }
    }

    private void readEntry() {
        this.reportAddress();
        String module = this.readString();
        String name = this.readString();
        this.listener.startEntry(module, name);
        this.reportAddress();
        byte type = this.reader.data[this.reader.ptr++];
        switch (type) {
            case 0: {
                int typeIndex = this.readLEB();
                this.listener.function(typeIndex);
                break;
            }
            case 3: {
                WasmHollowType valueType = this.reader.readType();
                this.listener.global(valueType, this.reader.readLEB() != 0);
                break;
            }
            default: {
                throw new ParseException("Unsupported import type", this.reader.ptr);
            }
        }
        this.listener.endEntry();
    }
}

