/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;

public class WasmSwitch
extends WasmExpression {
    private WasmExpression selector;
    private List<WasmBlock> targets = new ArrayList<WasmBlock>();
    private WasmBlock defaultTarget;

    public WasmSwitch(WasmExpression selector, WasmBlock defaultTarget) {
        this.selector = selector;
        this.defaultTarget = defaultTarget;
    }

    public WasmExpression getSelector() {
        return this.selector;
    }

    public void setSelector(WasmExpression selector) {
        Objects.requireNonNull(selector);
        this.selector = selector;
    }

    public WasmBlock getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(WasmBlock defaultTarget) {
        Objects.requireNonNull(defaultTarget);
        this.defaultTarget = defaultTarget;
    }

    public List<WasmBlock> getTargets() {
        return this.targets;
    }

    @Override
    public void acceptVisitor(WasmExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected boolean isTerminating(Set<WasmBlock> blocks) {
        for (WasmBlock target : this.targets) {
            if (!blocks.contains(target)) continue;
            return false;
        }
        return !blocks.contains(this.defaultTarget);
    }
}

